package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          234,  234,  391,  229,  234,  203,  419,  239,  239,  189, 
          580,  239,  237,  237,  248,  564,  237,  300,  190,  190, 
          591,  281,  252,  240,  240,  203,  519,  240,  257,  259, 
          216,   95,  601,  552,  234,  234,  216,  283,  284,  190, 
          732,  617,  274,  356,  249,  342,  461,  652,  265,  782, 
          466,  109,  109,  551,  442,  673,  675,  291,  275,  696, 
          698,  109,  253,  492,  362,  442,  190,  660,  661,  337, 
           62,  588,  221,  215,  218,  617,  393,  783,  394,  217, 
          469,  786,  492,  387,  382,  217,  606,  353,  441,  435, 
           60,  363,  762,  248,  216,  337,  308,  766,  109,  444, 
          244,  285,   79,   79,  110,  110,  353,  216,   79,  210, 
          210,  210,  492,   89,  225,  210,  210,  354,  441,  210, 
          235,  235,  247,  492,  235,  261,  210,  455,  487,   70, 
          492,  492,  221,  492,  492,  492,  442,  109,  649,  363, 
          363,  470,   71,  217,  387,  308,  253,   79,  210,  210, 
          338,  279,   87,  210,  269,  598,  217,  247,  656,   61, 
          487,   89,   89,  253,  392,  492,  492,  441,  360,  366, 
          447,  492,  361,  230,  264,  535,  338,   82,  492,  494, 
          260,  261,  492,  492,  441,  782,  456,  457,  458,  657, 
          279,  343,  307,  308,  273,  533,  492,   84,  344,  564, 
           87,   87,  256,  291,  230,  210,  262,   79,  684,  438, 
          494,  440,  190,  856,  492,  441,  234,  234,  284,  492, 
          492,  653,  716,  295,  576,   82,   82,  297,  691,  234, 
           69,  234,  234,  278,  264,   40,  239,   55,  239,  420, 
          492,  237,  771,  237,  237,   84,   84,   64,   63,  372, 
           69,   71,  240,  439,  240,  240,  373,  369,  423,  579, 
           67,  394,   65,  814,  265,  335,   40,   64,   61,  217, 
          673,  675,  828,  830,  345,  831,  363,  346,  472,  221, 
           67,  347,   65,  492,  340,  397,  398,  387,  481,  492, 
          481,  341,  348,  381,  479,  480,  481,  482,  483,  484, 
          485,  486,  487,  488,  489,  490,  491,  492,  493,  494, 
          495,  496,  497,  498,  499,  500,  501,  502,  503,  504, 
          536,  352,  210,  210,  377,  455,  550,  234,  376,  471, 
          524,  527,  492,  234,  476,  379,  406,  538,  531,  492, 
          531,  402,  307,  308,  210,  872,  210,  210,  363,  235, 
          265,  235,  417,  518,  234,  388,   79,  380,  617,  802, 
          626,  629,  234,   79,  617,  472,  473,  474,  475,  531, 
           89,  387,  234,  524,  589,  538,  364,   61,  597,  234, 
          518,  642,  721,  429,  456,  457,  594,  234,  492,  741, 
          264,  234,  234,  525,  528,  234,  532,  109,  518,  620, 
          539,   79,  210,  210,  210,  210,   79,  210,  210,   87, 
          389,  622,  634,  518,  390,  614,  564,  637,  638,  639, 
          632,  363,  624,  203,  543,  396,  234,  841,  492,  234, 
          399,  839,  234,  273,   82,  825,  454,  190,  835,  234, 
          273,  403,  210,  518,  406,  210,  210,  269,  210,   79, 
          279,  482,  210,  482,   84,  492,   61,  407,  600,  600, 
          511,  516,  492,  522,  523,  518,  627,  472,   69,  210, 
           79,  210,  278,  628,  269,  410,  264,  426,   79,  278, 
          617,  455,  492,   79,  473,   64,  463,  210,  549,  855, 
          792,   79,  269,   79,  492,  687,  367,  423,   67,  492, 
           65,  492,  210,  368,  423,  511,  516,  269,  617,  670, 
          582,  234,  307,  308,  210,   40,   40,  472,  590,  861, 
          592,  549,  356,  309,  472,  278,  385,  445,   79,  472, 
          432,  492,  433,  386,  666,  436,  492,  492,  428,  671, 
          456,  457,  670,  357,  358,  674,  676,   69,  472,  434, 
          445,  549,  448,  449,  210,  635,  437,  688,  445,  269, 
          422,  445,  446,  459,   64,  217,  190,  423,  424,  701, 
          356,  356,  203,  549,  411,  450,  445,   67,  234,   65, 
          400,  837,  362,  362,   94,   94,  190,  401,  362,  451, 
           94,   94,   94,   94,  459,  464,  234,   94,   94,  455, 
          234,   94,  454,  682,  234,  709,  579,  683,   94,  468, 
          430,  242,  459,  537,  243,  234,  540,  431,  596,   76, 
          579,   78,   76,  492,   78,  562,  563,  692,  744,   94, 
           94,   94,  778,  454,  583,   94,  454,  618,  614,   76, 
          752,   78,  492,  492,  210,   79,  229,  758,  760,  293, 
          294,  454,  394,  763,  765,  608,   81,  631,  456,  457, 
          460,  309,  630,  768,  234,   79,  636,  640,  641,  472, 
          725,  473,  492,  654,  234,  452,  672,  833,  662,   79, 
          663,  679,  453,  813,  834,  668,  815,   94,  680,   94, 
          324,  669,  685,  160,  326,  327,  686,  758,  760,  763, 
          689,  693,  695,  273,  109,  234,  705,  210,   74,  697, 
          759,  761,  234,   87,  455,  699,  764,  234,  234,  700, 
           83,   83,  111,  111,  810,  702,   83,  706,  712,  809, 
          210,  713,  226,  210,  714,  740,  492,  715,  609,  717, 
          811,  492,  160,  492,  773,  492,  718,  737,  738,  109, 
           79,   80,  821,  455,  234,  423,  720,  225,   79,  232, 
           79,   79,  210,  210,  278,   83,  724,  727,  210,  280, 
           86,  278,  794,  456,  457,  462,  473,  746,  153,  356, 
          733,  821,  735,  234,  736,  755,  600,  756,  757,  845, 
          739,  745,   87,  234,  492,   84,   84,  234,  279,  743, 
          767,   84,  788,  774,   94,   94,   79,  228,  280,  210, 
          775,  779,  456,  457,  465,  822,   85,  796,   86,   86, 
          234,   79,   79,   79,  795,   83,   94,  153,   94,   94, 
           88,  797,  234,  793,  234,  807,  816,  817,   94,  413, 
           84,  415,  418,  818,  820,   94,  518,  829,  799,  800, 
          801,  473,  234,  819,  234,  868,  827,   76,  472,   78, 
          473,  842,  234,  832,   85,   85,  234,  210,  843,  847, 
          849,   79,   79,  852,  854,  492,  492,  492,   88,   88, 
          853,  871,  492,   94,   94,   94,   94,   94,   94,   94, 
           94,   89,   79,  873,  875,  877,  163,  476,  824,  493, 
           84,   91,   91,  112,  112,  112,  492,   91,  472,  481, 
          473,  279,  483,  230,  493,  472,  483,  473,  254,  836, 
          472,  483,  473,  485,   94,   75,   79,   94,   94,  485, 
           94,   94,  487,  487,   94,  210,   76,   79,   78,  472, 
          269,  473,  273,   82,   79,  163,   91,  494,  728,  273, 
          282,   94,   94,   94,  549,  492,  299,  115,  734,  302, 
          303,  304,  305,  306,  863,   94,  826,   83,  188,   94, 
           89,  864,  280,   94,   83,   94,   92,   92,  874,  148, 
          690,   83,   92,  754,   94,  339,   88,  160,  351,  282, 
          160,  160,  160,  862,  423,  421,   94,  481,  784,  492, 
          785,  423,  301,  492,  492,    0,   91,  780,    0,    0, 
           94,    0,    0,  418,    0,   83,   83,    0,    0,   83, 
          418,   92,   82,  391,   83,  160,    0,   86,  148,    0, 
          160,  160,  160,  160,    0,    0,   94,  279,  481,    0, 
          473,  208,  208,  208,  279,    0,    0,  381,  280,   84, 
          560,  561,  562,  563,    0,    0,   84,    0,  250,    0, 
          803,    0,  482,  805,  806,   88,   76,   83,  280,  270, 
            0,    0,  153,   85,    0,  153,  153,  153,    0,    6, 
          267,   92,  391,  391,  391,    0,  476,   88,   83,    6, 
          473,    0,    0,    0,   84,    0,    0,  473,  417,   84, 
            0,   83,  473,  482,    0,  417,  381,  381,  381,   83, 
          153,   83,    0,  472,    0,  153,  153,  153,  153,    0, 
            6,  473,  481,    0,    0,  555,   94,   94,  556,  557, 
          558,    0,   77,    0,    0,   77,  476,  359,    6,    0, 
            0,    0,   84,  476,  848,  850,   83,   94,  472,    0, 
          279,    0,   77,    0,    0,   91,    0,  279,    0,    0, 
           83,   94,   91,   84,    0,    0,    0,  476,  560,  561, 
          562,  563,    0,    0,    0,    0,   84,    0,    0,  865, 
          866,    0,  476,    0,   84,  870,   84,  482,    0,   94, 
          163,    0,    0,  163,  163,  163,    0,    0,    0,    0, 
           91,    0,  878,    0,    6,   91,    0,    0,  131,    0, 
          880,  280,   94,  882,    0,   94,  419,  884,  280,  747, 
          748,   84,  749,  419,   83,    0,   41,   42,  163,    0, 
           92,    0,   94,  163,  163,  163,  163,   92,    0,   83, 
           94,    0,   94,   94,   94,   94,    0,    0,   91,  282, 
           94,    0,    0,    0,  208,  208,    0,  131,    0,  481, 
          481,  481,    0,   83,    0,  481,  481,    0,  481,   91, 
            0,    0,    0,  148,    0,   92,  148,  148,  148,  309, 
           92,    0,   91,   83,  404,  405,    0,  280,   94,    0, 
           91,   94,   91,    0,  280,  322,  323,   83,   78,  420, 
            0,   84,  472,   94,   94,   94,  420,    0,  324,    0, 
          325,  148,  326,  327,  328,  329,  148,  148,  148,  148, 
            0,    0,    0,   92,  482,  482,  482,   91,    0,    0, 
          482,  482,    0,  482,  208,  208,  208,  208,   84,  477, 
          478,    6,    6,    6,   92,  473,    0,    6,    6,   94, 
            6,    0,  472,   94,   94,    0,    0,   92,   84,  472, 
            0,    0,  270,    0,  472,   92,    0,   92,   83,  751, 
           77,  476,   84,    0,   94,  226,   83,  309,   83,   83, 
           84,    0,    0,  472,    0,   79,    0,    0,   79,  270, 
            0,   77,    0,  322,  323,    0,    0,  575,  581,  530, 
            0,  534,   92,  553,    0,   79,  324,  270,   94,    0, 
          326,  327,  328,  329,    0,    0,    0,   94,    0,   94, 
          789,  476,  270,    0,   83,    0,   94,    0,  476,    0, 
          577,    0,    0,  472,    0,  278,    0,    0,  476,   83, 
           83,   83,    0,   84,   91,    0,  267,  530,  309,   77, 
          228,   84,  476,   84,   84,    0,    0,    0,    0,  610, 
          613,    0,    0,  616,   91,    0,    0,  623,    0,    0, 
            0,    0,   81,   74,  270,   81,   74,  324,   91,    0, 
            0,  326,  327,  328,  329,    0,    0,    0,   80,   83, 
           83,   80,   81,   74,  644,  790,    0,  616,    0,   84, 
          644,    0,  131,    0,    0,  131,  131,  131,   80,  132, 
           83,    0,    0,    0,   84,   84,   84,    0,    0,   92, 
            0,   75,  273,  423,   75,  659,  659,  659,  422,    0, 
            0,  667,    0,   86,  473,  422,    0,    0,  279,   92, 
          131,   75,  667,  667,   83,  131,  131,  131,  131,   91, 
            0,    0,    0,   92,    0,   83,  230,   91,  132,   91, 
           91,    0,   83,    0,   84,   84,  667,    0,    0,    0, 
            0,  280,    0,    0,    0,    0,  208,    0,    0,  677, 
            0,    0,    0,    0,  473,   84,    0,   95,    0,    0, 
            0,  473,    0,    0,    0,    0,  473,    0,  704,    0, 
          708,  791,  581,    0,    0,   91,    0,    0,    0,    0, 
          581,    0,   86,    0,    0,  473,    0,    0,    0,   84, 
           91,   91,   91,   79,   92,    0,   85,  476,    0,    0, 
           84,    0,   92,    0,   92,   92,   95,   84,    0,  208, 
            0,    0,    0,    0,    0,    0,  719,   34,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   34,    0,    0, 
            0,    0,    0,    0,  726,  742,    0,    0,  729,    0, 
           91,   91,  730,    0,  278,    0,    0,  476,    0,    0, 
           92,  278,    0,  613,  476,    0,  473,    0,   34,  472, 
          412,   91,    0,    0,    0,   92,   92,   92,    0,    0, 
          412,  659,   79,    0,    0,   85,   34,    0,  476,    0, 
           81,   74,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   91,   80,    0,    0,    0, 
            0,  412,  770,    0,  412,    0,   91,    0,    0,    0, 
            0,  208,  777,   91,    0,   92,   92,    0,  412,  412, 
            0,  412,    0,  412,    0,    0,    0,  667,  667,   75, 
            0,  273,  423,    0,    0,    0,   92,    0,  273,  423, 
            0,    0,   34,  644,    0,    0,    0,  279,    0,    0, 
          616,  412,    0,  412,  279,    0,  616,    0,  555,   81, 
           74,  556,  557,  558,    0,    0,    0,    0,    0,    0, 
           92,    0,    0,  132,    0,   80,  132,  132,  132,    0, 
          280,   92,    0,  415,    0,  412,    0,  280,   92,  581, 
            0,    0,  823,  415,    0,    0,  559,    0,    0,  421, 
            0,  560,  561,  562,  563,    0,  421,    0,   75,    0, 
            0,  132,    0,    0,    0,    0,  132,  132,  132,  132, 
            0,  838,    0,    0,  415,  270,    0,  415,    0,    0, 
            0,  846,  309,    0,    0,  851,    0,    0,    0,    0, 
            0,  415,  415,    0,  415,    0,  415,    0,  322,  323, 
          253,   95,    0,  581,   95,   95,   95,    0,    0,    0, 
            0,  324,    0,  325,    0,  326,  327,  328,  329,    0, 
          613,  332,  616,  333,  415,    0,  415,  412,    0,   34, 
           34,   34,    0,    0,  412,   34,   34,    0,   34,   95, 
          876,    0,  879,    0,   95,   95,   95,   95,    0,    0, 
          616,    0,    0,  334,  883,    0,    0,    0,  415,    0, 
           34,   34,   34,   34,   34,    0,    0,  469,  469,  469, 
            0,  469,  412,  412,  412,  469,  469,  412,  412,  412, 
          469,  412,  469,  469,  469,  469,  469,  469,  469,  412, 
          469,  412,  412,  469,  469,  469,  469,  469,  469,  469, 
          412,  412,    0,  412,  412,  412,  412,  412,  334,  469, 
            0,    0,  469,  469,  469,  469,  469,  469,  469,  469, 
            0,  469,  469,  469,  469,    0,  469,  469,  469,  412, 
          412,  412,  412,  412,  412,  412,  412,  412,  412,  412, 
          412,  412,  412,    0,   96,  412,  412,  412,  469,  412, 
          412,  469,  469,  469,  469,  469,  412,  469,  412,  469, 
          412,  469,  412,  412,  412,  412,  412,  412,  412,  469, 
          412,  469,    0,  469,  469,  469,  469,  469,  469,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          470,  470,  470,   96,  470,  415,  415,  415,  470,  470, 
          415,  415,  415,  470,  415,  470,  470,  470,  470,  470, 
          470,  470,  415,  470,  415,  415,  470,  470,  470,  470, 
          470,  470,  470,  415,  415,    0,  415,  415,  415,  415, 
          415,    0,  470,    0,    0,  470,  470,  470,  470,  470, 
          470,  470,  470,    0,  470,  470,  470,  470,    0,  470, 
          470,  470,  415,  415,  415,  415,  415,  415,  415,  415, 
          415,  415,  415,  415,  415,  415,    0,    0,  415,  415, 
          415,  470,  415,  415,  470,  470,  470,  470,  470,  415, 
          470,  415,  470,  415,  470,  415,  415,  415,  415,  415, 
          415,  415,  470,  415,  470,  472,  470,  470,  470,  470, 
          470,  470,    0,    0,    0,  472,    0,    0,    0,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
            0,  320,  321,    0,    0,  322,  323,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  472,    0,  324,  472, 
          325,    0,  326,  327,  328,  329,  330,  331,  332,    0, 
          333,    0,    0,  472,  472,    0,   84,    0,  472,    0, 
            0,    0,    0,    0,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,    0,  320,  321,    0,    0, 
          322,  323,    0,    0,    0,    0,  472,    0,  472,    0, 
            0,    0,    0,  324,    0,  325,    0,  326,  327,  328, 
          329,  330,  331,  332,    0,  333,    0,  473,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  473,    0,    0, 
          472,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   96,    0, 
            0,   96,   96,   96,    0,    0,    0,    0,  473,    0, 
            0,  473,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  415,  473,  473,    0,   86,    0, 
          473,  415,    0,    0,    0,    0,   96,    0,    0,    0, 
            0,   96,   96,   96,   96,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,    0,    0,  473,    0, 
          473,  322,  323,    0,    0,    0,    0,    0,  608,    0, 
            0,    0,    0,    0,  324,    0,  325,    0,  326,  327, 
          328,  329,  330,  331,  332,    0,  333,  334,    0,    0, 
            0,    0,  473,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  472,  472,  472,    0,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,    0,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,    0,  472,  472, 
          472,  472,  472,    0,  472,    0,    0,  472,  472,  472, 
          472,  472,  472,  472,  472,  655,  472,  472,  472,  472, 
          334,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,    0,    0, 
          472,  472,  472,  472,    0,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,    0,  472,  472, 
          472,  472,  472,  472,  473,  473,  473,    0,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,    0,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,    0, 
          473,  473,  473,  473,  473,    0,  473,    0,    0,  473, 
          473,  473,  473,  473,  473,  473,  473,    0,  473,  473, 
          473,  473,  334,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
            0,    0,  473,  473,  473,  473,    0,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  476, 
          473,  473,  473,  473,  473,  473,    0,    0,    0,  476, 
            0,    0,    0,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,    0,  320,  321,    0,    0,  322, 
          323,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          476,    0,  324,  476,  325,    0,  326,  327,  328,  329, 
          330,  331,  332,    0,  333,    0,    0,  476,  476,    0, 
           85,    0,  476,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          476,    0,  476,    0,    0,    0,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,    0,  320,  321, 
            0,  274,  322,  323,    0,    0,    0,    0,    0,    0, 
            0,  274,    0,    0,  476,  324,    0,  325,    0,  326, 
          327,  328,  329,  330,  331,  332,    0,  333,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  508,  509,    0, 
            0,  510,  274,    0,    0,  274,    0,    0,    0,  160, 
          161,    0,  162,  163,  164,  165,    0,  166,  167,  274, 
          274,  168,    0,    0,  274,    0,  169,  170,  171,  172, 
            0,    0,    0,    0,    0,    0,  678,    0,    0,    0, 
          174,  175,    0,  176,  177,  178,  179,  180,  181,  182, 
          183,  184,  274,  185,  274,  186,    0,    0,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,    0, 
          320,  321,    0,    0,  322,  323,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  274,  324,    0,  325, 
            0,  326,  327,  328,  329,  330,  331,  332,    0,  333, 
            0,    0,    0,    0,    0,    0,  472,  472,  472,    0, 
          472,  476,  476,  476,  472,  472,  476,  476,  476,  472, 
          476,  472,  472,  472,  472,  472,  472,  472,    0,  476, 
          476,  476,  472,  472,  472,  472,  472,  472,  472,  476, 
          476,    0,  476,  476,  476,  476,  476,    0,  472,    0, 
            0,  472,  472,  472,  472,  472,  472,  472,  472,    0, 
          472,  472,  472,  472,    0,  472,  472,  472,  476,  476, 
          476,  476,  476,  476,  476,  476,  476,  476,  476,  476, 
          476,  476,    0,    0,  476,  476,  476,  472,    0,  476, 
          472,  472,  472,  472,  472,  476,  472,  476,  472,  476, 
          472,  476,  476,  476,  476,  476,  476,  476,  472,  476, 
          476,    0,  472,  472,  472,  472,  472,  472,  471,  471, 
          471,    0,  471,  274,  274,  274,  471,  471,  274,  274, 
          274,  471,  274,  471,  471,  471,  471,  471,  471,  471, 
            0,  471,  274,  274,  471,  471,  471,  471,  471,  471, 
          471,  274,  274,    0,  274,  274,  274,  274,  274,    0, 
          471,    0,    0,  471,  471,  471,  471,  471,  471,  471, 
          471,    0,  471,  471,  471,  471,    0,  471,  471,  471, 
          274,  274,  274,  274,  274,  274,  274,  274,  274,  274, 
          274,  274,  274,  274,    0,    0,  274,  274,  274,  471, 
            0,  274,  471,  471,  471,  471,  471,  274,  471,  274, 
          471,  274,  471,  274,  274,  274,  274,  274,  274,  274, 
          471,  274,  471,  477,  471,  471,  471,  471,  471,  471, 
            0,    0,    0,  477,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  477,    0,    0,  477,    0,    0, 
            0,    0,    0,    0,    0,    0,    4,    5,    6,    0, 
            8,  477,  477,    0,    9,   10,  477,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,  477,    0,  477,    0,  101,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,    0, 
           39,   40,   41,   42,    0,  478,    0,  104,    0,    0, 
            0,    0,    0,    0,    0,  478,    0,    0,  477,    0, 
            0,    0,    0,    0,    0,    0,    0,  224,    0,    0, 
           47,    0,   48,   49,   50,    0,   51,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  478,  753,    0,  478, 
            0,    0,   54,   55,   56,   57,   58,   59,  513,  514, 
            0,    0,  515,  478,  478,    0,    0,    0,  478,    0, 
          160,  161,    0,  162,  163,  164,  165,    0,  166,  167, 
            0,    0,  168,    0,    0,    0,    0,  169,  170,  171, 
          172,    0,    0,    0,    0,    0,  478,    0,  478,    0, 
            0,  174,  175,    0,  176,  177,  178,  179,  180,  181, 
          182,  183,  184,    0,  185,    0,  186,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          478,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          474,  474,  474,    0,  474,  477,  477,  477,  474,  474, 
          477,  477,  477,  474,  477,  474,  474,  474,  474,  474, 
          474,  474,    0,  477,  477,  477,  474,  474,  474,  474, 
          474,  474,  474,  477,  477,    0,  477,  477,  477,  477, 
          477,    0,  474,    0,    0,  474,  474,  474,  474,  474, 
          474,  474,  474,    0,  474,  474,  474,  474,    0,  474, 
          474,  474,  477,  477,  477,  477,  477,  477,  477,  477, 
          477,  477,  477,  477,  477,  477,    0,    0,  477,  477, 
          477,  474,    0,  477,  474,  474,  474,  474,  474,  477, 
          474,  477,  474,  477,  474,  477,  477,  477,  477,  477, 
          477,  477,  474,  477,  477,    0,  474,  474,  474,  474, 
          474,  474,  475,  475,  475,    0,  475,  478,  478,  478, 
          475,  475,  478,  478,  478,  475,  478,  475,  475,  475, 
          475,  475,  475,  475,    0,  478,  478,  478,  475,  475, 
          475,  475,  475,  475,  475,  478,  478,    0,  478,  478, 
          478,  478,  478,    0,  475,    0,    0,  475,  475,  475, 
          475,  475,  475,  475,  475,    0,  475,  475,  475,  475, 
            0,  475,  475,  475,  478,  478,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,  478,  478,  478,    0,    0, 
          478,  478,  478,  475,    0,  478,  475,  475,  475,  475, 
          475,  478,  475,  478,  475,  478,  475,  478,  478,  478, 
          478,  478,  478,  478,  475,  478,  478,  350,  475,  475, 
          475,  475,  475,  475,    0,    0,    0,  350,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  350,    0, 
            0,  350,    0,    0,    0,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,  350,  350,    9,   10,    0, 
          350,    0,   11,    0,   12,   13,   14,   96,   97,   17, 
           18,    0,    0,    0,    0,   98,   99,  100,   22,   23, 
           24,   25,    0,    0,    0,    0,    0,    0,  350,    0, 
          350,  101,    0,    0,   31,   32,  102,   34,   35,   36, 
          103,   38,    0,   39,   40,   41,   42,    0,    0,  492, 
          104,    0,    0,    0,    0,    0,    0,    0,    0,  492, 
            0,    0,  350,    0,    0,    0,    0,  105,    0,    0, 
          106,    0,    0,  107,    0,   48,   49,   50,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          492,    0,    0,  492,    0,   54,   55,   56,   57,   58, 
           59,  520,  509,    0,    0,  521,    0,  492,  492,    0, 
            0,    0,  492,  160,  161,    0,  162,  163,  164,  165, 
            0,  166,  167,    0,    0,  168,    0,    0,    0,    0, 
          169,  170,  171,  172,    0,    0,    0,    0,    0,    0, 
          492,    0,  492,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,    0,  186, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  492,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  251,  251,  251,    0,  251,  350, 
          350,  350,  251,  251,  350,  350,  350,  251,  350,  251, 
          251,  251,  251,  251,  251,  251,    0,  350,  350,  350, 
          251,  251,  251,  251,  251,  251,  251,  350,  350,    0, 
          350,  350,  350,  350,  350,    0,  251,    0,    0,  251, 
          251,  251,  251,  251,  251,  251,  251,    0,  251,  251, 
          251,  251,    0,  251,  251,  251,  350,  350,  350,  350, 
          350,  350,  350,  350,  350,  350,  350,  350,  350,  350, 
            0,    0,  350,  350,  350,  251,    0,  350,  251,    0, 
          251,  251,  251,  350,  251,  350,  251,  350,  251,  350, 
          350,  350,  350,  350,  350,  350,  251,  350,  350,    0, 
          251,  251,  251,  251,  251,  251,  251,  251,  251,    0, 
          251,  492,  492,  492,  251,  251,  492,  492,  492,  251, 
          492,  251,  251,  251,  251,  251,  251,  251,    0,  492, 
          492,  492,  251,  251,  251,  251,  251,  251,  251,  492, 
          492,    0,  492,  492,  492,  492,  492,    0,  251,    0, 
            0,  251,  251,  251,  251,  251,  251,  251,  251,    0, 
          251,  251,  251,  251,    0,  251,  251,  251,  492,  492, 
          492,  492,  492,  492,  492,  492,  492,  492,  492,  492, 
          492,  492,    0,    0,  492,  492,  492,  251,    0,  492, 
          251,    0,  251,  251,  251,  492,  251,  492,  251,  492, 
          251,  492,  492,  492,  492,  492,  492,  492,  251,  492, 
          492,  278,  251,  251,  251,  251,  251,  251,    0,    0, 
            0,  278,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  547,  514,    0,    0,  548,    0,    0, 
            0,    0,    0,    0,    0,  160,  161,    0,  162,  163, 
          164,  165,  278,  166,  167,  278,    0,  168,    0,    0, 
            0,    0,  169,  170,  171,  172,    0,    0,    0,  278, 
          278,    0,   87,    0,  278,    0,  174,  175,    0,  176, 
          177,  178,  179,  180,  181,  182,  183,  184,    0,  185, 
            0,  186,    0,    0,    0,  584,  509,    0,    0,  585, 
            0,    0,  278,    0,  278,    0,    0,  160,  161,    0, 
          162,  163,  164,  165,    0,  166,  167,    0,    0,  168, 
            0,    0,    0,  286,  169,  170,  171,  172,    0,    0, 
            0,    0,    0,  286,    0,    0,  278,    0,  174,  175, 
            0,  176,  177,  178,  179,  180,  181,  182,  183,  184, 
            0,  185,    0,  186,    0,    0,    0,    0,    0,  586, 
          514,    0,    0,  587,  286,    0,    0,  286,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,  286,  286,  168,    0,    0,  286,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  174,  175,    0,  176,  177,  178,  179,  180, 
          181,  182,  183,  184,  286,  185,  286,  186,  309,  310, 
          311,  312,  313,  314,  315,  316,    0,  318,  319,    0, 
            0,    0,    0,    0,  322,  323,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  324,  286,  325, 
            0,  326,  327,  328,  329,  330,  331,  332,    0,  333, 
            0,    0,    0,    0,    0,    0,    0,    0,  473,  473, 
          473,    0,  473,  278,  278,  278,  473,  473,  278,  278, 
          278,  473,  278,  473,  473,  473,  473,  473,  473,  473, 
            0,    0,  278,  278,  473,  473,  473,  473,  473,  473, 
          473,  278,  278,    0,  278,  278,  278,  278,  278,    0, 
          473,    0,    0,  473,  473,  473,  473,  473,  473,  473, 
          473,    0,  473,  473,  473,  473,    0,  473,  473,  473, 
          278,  278,  278,  278,  278,  278,  278,  278,  278,  278, 
          278,  278,  278,  278,    0,    0,  278,  278,  278,  473, 
            0,  278,  473,  473,  473,  473,  473,  278,  473,  278, 
          473,  278,  473,  278,  278,  278,  278,  278,  278,  278, 
          473,  278,    0,    0,  473,  473,  473,  473,  473,  473, 
          251,  251,  251,    0,  251,  286,  286,  286,  251,  251, 
          286,  286,  286,  251,  286,  251,  251,  251,  251,  251, 
          251,  251,    0,    0,  286,  286,  251,  251,  251,  251, 
          251,  251,  251,  286,  286,    0,  286,  286,  286,  286, 
          286,    0,  251,    0,    0,  251,  251,  251,  251,  251, 
          251,  251,  251,    0,  251, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          251,  251,  251,    0,  251,  251,  251,  286,  286,  286, 
          286,  286,  286,  286,  286,  286,  286,  286,  286,  286, 
          286,    0,    0,  286,  286,  286,  251,    0,  286,  251, 
            0,  251,  251,  251,  286,  251,  286,  251,  286,  251, 
          286,  286,  286,  286,  286,  286,  286,  251,  286,  472, 
            0,  251,  251,  251,  251,  251,  251,    0,    0,  472, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  602,  509,    0,    0,  603,    0,    0,    0,    0, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
          472,  166,  167,   76,    0,  168,    0,    0,    0,    0, 
          169,  170,  171,  172,    0,    0,    0,    0,  472,    0, 
           84,    0,  472,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,    0,  186, 
            0,    0,    0,  604,  514,    0,    0,  605,    0,    0, 
          472,    0,    0,    0,    0,  160,  161,    0,  162,  163, 
          164,  165,    0,  166,  167,    0,    0,  168,    0,    0, 
            0,  473,  169,  170,  171,  172,    0,    0,    0,    0, 
            0,  473,    0,    0,  472,    0,  174,  175,    0,  176, 
          177,  178,  179,  180,  181,  182,  183,  184,    0,  185, 
            0,  186,    0,    0,    0,    0,    0,  645,  509,    0, 
            0,  646,  473,    0,    0,   78,    0,    0,    0,  160, 
          161,    0,  162,  163,  164,  165,    0,  166,  167,    0, 
          473,  168,   86,    0,  473,    0,  169,  170,  171,  172, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          174,  175,    0,  176,  177,  178,  179,  180,  181,  182, 
          183,  184,  473,  185,    0,  186,  309,  310,  311,  312, 
          313,  314,  315,    0,    0,  318,  319,    0,    0,    0, 
            0,    0,  322,  323,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  324,  473,  325,    0,  326, 
          327,  328,  329,  330,  331,  332,    0,  333,    0,    0, 
            0,    0,    0,    0,    0,    0,  472,  472,  472,    0, 
          472,  472,  472,  472,  472,  472,    0,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,    0,  472, 
            0,    0,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,    0,  472,  472,  472,  472,  472,    0,  472,    0, 
            0,  472,  472,  472,  472,  472,  472,  472,  472,    0, 
          472,  472,  472,  472,    0,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,  472,    0,    0,  472,  472,  472,  472,    0,    0, 
          472,  472,  472,  472,  472,    0,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,    0,  472,  472,  472,  472,  472,  472,  473,  473, 
          473,    0,  473,  473,  473,  473,  473,  473,    0,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
            0,  473,    0,    0,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,    0,  473,  473,  473,  473,  473,    0, 
          473,    0,    0,  473,  473,  473,  473,  473,  473,  473, 
          473,    0,  473,  473,  473,  473,    0,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,    0,    0,  473,  473,  473,  473, 
            0,    0,  473,  473,  473,  473,  473,    0,  473,  473, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  476,  473,  473,  473,  473,  473,  473, 
            0,    0,    0,  476,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  647,  514,    0,    0,  648, 
            0,    0,    0,    0,    0,    0,    0,  160,  161,    0, 
          162,  163,  164,  165,  476,  166,  167,   77,    0,  168, 
            0,    0,    0,    0,  169,  170,  171,  172,    0,    0, 
            0,    0,  476,    0,   85,    0,  476,    0,  174,  175, 
            0,  176,  177,  178,  179,  180,  181,  182,  183,  184, 
            0,  185,    0,  186,    0,    0,    0,  857,  509,    0, 
            0,  858,    0,    0,  476,    0,    0,    0,    0,  160, 
          161,    0,  162,  163,  164,  165,    0,  166,  167,    0, 
            0,  168,    0,    0,    0,  278,  169,  170,  171,  172, 
            0,    0,    0,    0,    0,  278,    0,    0,  476,    0, 
          174,  175,    0,  176,  177,  178,  179,  180,  181,  182, 
          183,  184,    0,  185,    0,  186,    0,    0,    0,    0, 
            0,  859,  514,    0,    0,  860,  278,    0,    0,   79, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
            0,  166,  167,    0,  278,  168,   87,    0,  278,    0, 
          169,  170,  171,  172,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,  278,  185,  309,  186, 
            0,    0,    0,  314,  315,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  322,  323,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  324,    0,  325, 
          278,  326,  327,  328,  329,  330,  331,  332,    0,  333, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          472,  472,  472,    0,  472,  476,  476,  476,  472,  472, 
            0,  476,  476,  472,  476,  472,  472,  472,  472,  472, 
          472,  472,    0,  476,    0,    0,  472,  472,  472,  472, 
          472,  472,  472,  476,  476,    0,  476,  476,  476,  476, 
          476,    0,  472,    0,    0,  472,  472,  472,  472,  472, 
          472,  472,  472,    0,  472,  472,  472,  472,    0,  472, 
          472,  472,  476,  476,  476,  476,  476,  476,  476,  476, 
          476,  476,  476,  476,  476,  476,    0,    0,  476,  476, 
          476,  472,    0,    0,  472,  472,  472,  472,  472,    0, 
          472,  476,  472,  476,  472,  476,  476,  476,  476,  476, 
          476,  476,  472,  476,  476,    0,  472,  472,  472,  472, 
          472,  472,  473,  473,  473,    0,  473,  278,  278,  278, 
          473,  473,    0,  278,  278,  473,  278,  473,  473,  473, 
          473,  473,  473,  473,    0,    0,    0,    0,  473,  473, 
          473,  473,  473,  473,  473,  278,  278,    0,  278,  278, 
          278,  278,  278,    0,  473,    0,    0,  473,  473,  473, 
          473,  473,  473,  473,  473,    0,  473,  473,  473,  473, 
            0,  473,  473,  473,  278,  278,  278,  278,  278,  278, 
          278,  278,  278,  278,  278,  278,  278,  278,    0,    0, 
          278,  278,  278,  473,    0,    0,  473,  473,  473,  473, 
          473,    0,  473,  278,  473,  278,  473,  278,  278,  278, 
          278,  278,  278,  278,  473,  278,  492,    0,  473,  473, 
          473,  473,  473,  473,    0,    0,  492,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  492,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  492,  492,   32,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   32,    8,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    8,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   32,    0,    0, 
          261,    0,    0,  350,    0,    0,    0,    0,    8,    0, 
            0,    0,    0,  350,    0,   32,    0,    0,    0,    0, 
            0,  492,    0,    0,    0,    0,    8,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  350,    0,    0,  350,    0,    0, 
            7,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            7,  350,  350,    0,    0,    0,  350,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   32,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    7,    8,    0,  350,    0,  350,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    7, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  350,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,  251,  251,    0,  251,  492,  492, 
          492,  251,  251,  492,  492,  492,  251,  492,  251,  251, 
          251,  251,  251,  251,  251,    7,    0,  492,    0,  251, 
          251,  251,  251,  251,  251,  251,  492,  492,    0,  492, 
          492,  492,  492,  492,    0,  251,    0,    0,  251,  251, 
          251,  251,  251,  251,  251,  251,    0,  251,  251,  251, 
          251,    0,  251,  251,  251,    0,    0,    0,   32,   32, 
           32,    0,    0,    0,   32,   32,  492,   32,    0,    8, 
            8,    8,    0,  492,  251,    8,    8,  251,    8,  251, 
          251,  251,    0,  251,    0,  251,  263,  251,    0,   32, 
           32,   32,   32,   32,    0,  251,  263,    0,    0,  251, 
          251,  251,  251,  251,  251,  350,  350,  350,    0,    0, 
          350,  350,  350,    0,  350,    0,    0,    0,    0,    0, 
            0,    0,    0,  350,  350,  350,    0,  263,    0,    0, 
          262,    0,    0,  350,  350,    0,  350,  350,  350,  350, 
          350,    0,    0,    0,  263,  263,    0,    0,    0,    0, 
            0,    0,    7,    7,    7,    0,    0,    0,    7,    7, 
            0,    7,  350,  350,  350,  350,  350,  350,  350,  350, 
          350,  350,  350,  350,  350,  350,  492,    0,  350,  350, 
          350,    0,    0,  350,    0,    0,  492,    0,    0,  350, 
            0,  350,    0,  350,    0,  350,  350,  350,  350,  350, 
          350,  350,    0,  350,  350,    0,    0,    0,    0,    0, 
            0,  263,    0,    0,    0,    0,    0,  492,    0,    0, 
          492,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  492,  492,    0,    0,    0,  492, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  492,    0,  492, 
            0,    0,    0,    0,    0,    0,  423,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  423,    0,    0,    0, 
            0,    0,   14,    0,    0,    0,    0,    0,    0,    0, 
            0,  492,   14,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  423,    0,    0, 
          423,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   14,  423,  423,    0,   82,    0,  423, 
            0,    0,    0,    0,    0,    0,    0,    0,  263,  263, 
          263,   14,    0,  263,  263,  263,    0,  263,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  423,    0,  423, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  263, 
          263,  263,  263,  263,    0,    0,    0,    0,    0,    0, 
          273,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          273,  423,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   14,    0,    0, 
            0,    0,    0,    0,    0,    0,  263,    0,    0,    0, 
            0,  273,    0,    0,  273,    0,    0,    0,  492,  492, 
          492,    0,    0,  492,  492,  492,    0,  492,  273,  273, 
            0,   89,    0,  273,    0,    0,  492,  492,  492,    0, 
            0,    0,    0,    0,    0,    0,  492,  492,    0,  492, 
          492,  492,  492,  492,    0,    0,    0,    0,    0,    0, 
            0,  273,    0,  273,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  492,  492,  492,  492,  492, 
          492,  492,  492,  492,  492,  492,  492,  492,  492,    0, 
            0,  492,  492,  492,    0,  273,  492,    0,    0,    0, 
            0,    0,  492,    0,  492,    0,  492,    0,  492,  492, 
          492,  492,  492,  492,  492,    0,  492,  492,  423,  423, 
          423,    0,    0,  423,  423,  423,    0,  423,    0,    0, 
            0,    0,    0,    0,   14,   14,   14,  423,  423,    0, 
           14,   14,    0,   14,    0,    0,  423,  423,    0,  423, 
          423,  423,  423,  423,    0,    0,    0,    0,    0,    0, 
            0,    0,   40,    0,    0,   14,   14,   14,   14,   14, 
            0,    0,   40,    0,    0,  423,  423,  423,  423,  423, 
          423,  423,  423,  423,  423,  423,  423,  423,  423,    0, 
            0,  423,  423,  423,    0,  424,  423,    0,    0,    0, 
            0,    0,  423,   40,  423,    0,  423,    0,  423,  423, 
          423,  423,  423,  423,  423,    0,  423,    0,  279,    0, 
           40,   40,    0,    0,    0,    0,    0,    0,  279,    0, 
            0,    0,  273,  273,  273,    0,    0,  273,  273,  273, 
            0,  273,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  273,  273,    0,    0,    0,    0,    0,    0,  279, 
          273,  273,  279,  273,  273,  273,  273,  273,    0,    0, 
            0,    0,    0,    0,    0,    0,  279,  279,    0,   88, 
            0,  279,    0,    0,    0,    0,    0,   40,    0,  273, 
          273,  273,  273,  273,  273,  273,  273,  273,  273,  273, 
          273,  273,  273,    0,    0,  273,  273,  273,    0,  279, 
          273,  279,    0,    0,    0,    0,  273,    0,  273,  280, 
          273,    0,  273,  273,  273,  273,  273,  273,  273,  280, 
          273,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  279,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          280,    0,    0,  280,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  280,  280,    0, 
           83,    0,  280,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          280,    0,  280,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   40,   40,   40,    0,    0,   40, 
           40,   40,  373,   40,    0,    0,    0,    0,    0,    0, 
            0,    0,  373,   40,  280,    0,    0,    0,    0,    0, 
            0,    0,   40,   40,    0,   40,   40,   40,   40,   40, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  373,    0,    0,  373,    0,    0,    0, 
          279,  279,  279,    0,    0,  279,  279,  279,    0,  279, 
          373,  373,    0,    0,    0,  373,    0,    0,    0,  279, 
          279,    0,    0,    0,    0,    0,    0,    0,  279,  279, 
            0,  279,  279,  279,  279,  279,    0,    0,    0,    0, 
            0,    0,    0,  373,    0,  373,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
          279,    0,    0,  279,  279,  279,    0,  373,  279,    0, 
            0,    0,    0,    0,  279,    0,  279,  216,  279,    0, 
          279,  279,  279,  279,  279,  279,  279,  216,  279,    0, 
            0,  280,  280,  280,    0,    0,  280,  280,  280,    0, 
          280,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          280,  280,    0,    0,    0,    0,    0,    0,  216,  280, 
          280,  216,  280,  280,  280,  280,  280,    0,    0,    0, 
            0,    0,    0,    0,    0,  216,  216,    0,    0,    0, 
          216,    0,    0,    0,    0,    0,    0,    0,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,    0,    0,  280,  280,  280,    0,  322,  280, 
          216,    0,    0,    0,    0,  280,    0,  280,    0,  280, 
            0,  280,  280,  280,  280,  280,  280,  280,    0,  280, 
          290,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          290,    0,  216,    0,  373,  373,  373,    0,    0,  373, 
          373,  373,    0,  373,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  373,  373,    0,    0,    0,    0,    0, 
            0,  290,  373,  373,  290,  373,  373,  373,  373,  373, 
            0,    0,    0,    0,    0,    0,    0,    0,  290,  290, 
            0,    0,    0,  290,    0,    0,    0,    0,    0,    0, 
            0,  373,  373,  373,  373,  373,  373,  373,  373,  373, 
          373,  373,  373,  373,  373,    0,    0,  373,  373,  373, 
            0,  290,  373,  290,    0,    0,    0,    0,  373,    0, 
          373,  286,  373,    0,  373,  373,  373,  373,  373,  373, 
          373,  286,  373,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  290,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  286,    0,    0,  286,    0,    0,    0,  216, 
          216,  216,    0,    0,  216,  216,  216,    0,  216,  286, 
          286,    0,    0,    0,  286,    0,    0,    0,  216,  216, 
            0,    0,    0,    0,    0,    0,    0,  216,  216,    0, 
          216,  216,  216,  216,  216,    0,    0,    0,    0,    0, 
            0,    0,  286,    0,  286,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  216,  216,  216,  216, 
          216,  216,  216,  216,  216,  216,  216,  322,  216,  216, 
            0,    0,  216,  216,  322,    0,  286,  216,    0,    0, 
            0,    0,    0,  216,    0,  216,    0,  216,    0,  216, 
          216,  216,  216,  216,  216,  216,    0,  216,  410,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  410,    0, 
            0,    0,  290,  290,  290,    0,    0,  290,  290,  290, 
            0,  290,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  290,  290,    0,    0,    0,    0,    0,    0,  410, 
          290,  290,  410,  290,  290,  290,  290,  290,    0,    0, 
            0,    0,    0,    0,    0,    0,  410,  410,    0,    0, 
            0,  410,    0,    0,    0,    0,    0,    0,    0,  290, 
          290,  290,  290,  290,  290,  290,  290,  290,  290,  290, 
          290,  290,  290,    0,    0,  290,  290,  290,    0,  410, 
          290,  410,    0,    0,    0,    0,  290,    0,  290,  411, 
          290,    0,  290,  290,  290,  290,  290,  290,  290,  411, 
          290,    0,    0,  286,  286,  286,    0,    0,  286,  286, 
          286,    0,  286,  410,    0,    0,    0,    0,    0,    0, 
            0,    0,  286,  286,    0,    0,    0,    0,    0,    0, 
          411,  286,  286,  411,  286,  286,  286,  286,  286,    0, 
            0,    0,    0,    0,    0,    0,    0,  411,  411,    0, 
            0,    0,  411,    0,    0,    0,    0,    0,    0,    0, 
          286,  286,  286,  286,  286,  286,  286,  286,  286,  286, 
          286,  286,  286,  286,    0,    0,  286,  286,  286,    0, 
          411,  286,  411,    0,    0,    0,    0,  286,    0,  286, 
            0,  286,    0,  286,  286,  286,  286,  286,  286,  286, 
            0,  286,  318,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  318,    0,  411,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  318,    0,    0,  318,    0,    0,    0, 
          410,  410,  410,    0,    0,  410,  410,  410,    0,  410, 
          318,  318,    0,    0,    0,  318,    0,    0,    0,  410, 
          410,    0,    0,    0,    0,    0,    0,    0,  410,  410, 
            0,  410,  410,  410,  410,  410,    0,    0,    0,    0, 
            0,    0,    0,  318,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  410,  410, 
          410,  410,  410,  410,  410,  410,  410,  410,  410,  410, 
          410,    0,    0,  410,  410,  410,    0,  318,  410,    0, 
            0,    0,    0,    0,  410,    0,  410,  319,  410,    0, 
          410,  410,  410,  410,  410,  410,  410,  319,  410,    0, 
            0,  411,  411,  411,    0,    0,  411,  411,  411,    0, 
          411,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          411,  411,    0,    0,    0,    0,    0,    0,  319,  411, 
          411,  319,  411,  411,  411,  411,  411,    0,    0,    0, 
            0,    0,    0,    0,    0,  319,  319,    0,    0,    0, 
          319,    0,    0,    0,    0,    0,    0,    0,    0,  411, 
          411,  411,  411,  411,  411,  411,  411,  411,  411,  411, 
          411,  411,    0,    0,  411,  411,  411,    0,  319,  411, 
            0,    0,    0,    0,    0,  411,    0,  411,    0,  411, 
            0,  411,  411,  411,  411,  411,  411,  411,    0,  411, 
          283,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          283,    0,  319,    0,  318,  318,  318,    0,    0,  318, 
          318,  318,    0,  318,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  318,    0,    0,    0,    0,    0,    0, 
            0,  283,  318,  318,  283,  318,  318,  318,  318,  318, 
            0,    0,    0,    0,    0,    0,    0,    0,  283,  283, 
            0,    0,    0,  283,    0,    0,    0,    0,    0,    0, 
            0,  318,  318,  318,  318,  318,  318,  318,  318,  318, 
          318,  318,  318,  318,  318,    0,    0,  318,  318,  318, 
            0,  283,  318,    0,    0,    0,    0,    0,    0,    0, 
          318,  193,  318,    0,  318,  318,  318,  318,  318,  318, 
          318,  193,  318,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  283,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  193,    0,    0,  193,    0,    0,    0,  319, 
          319,  319,    0,    0,  319,  319,  319,    0,  319,  193, 
          193,    0,    0,    0,  193,    0,    0,    0,  319,    0, 
            0,    0,    0,    0,    0,    0,    0,  319,  319,    0, 
          319,  319,  319,  319,  319,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  193,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  319,  319,  319,  319, 
          319,  319,  319,  319,  319,  319,  319,  319,  319,  319, 
            0,    0,  319,  319,  319,    0,  193,  319,    0,    0, 
            0,    0,    0,    0,    0,  319,    0,  319,    0,  319, 
          319,  319,  319,  319,  319,  319,    0,  319,  189,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  189,    0, 
            0,    0,  283,  283,  283,    0,    0,  283,  283,  283, 
            0,  283,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  283,    0,    0,    0,    0,    0,    0,    0,  189, 
          283,  283,  189,  283,  283,  283,  283,  283,    0,    0, 
            0,    0,    0,    0,    0,    0,  189,  189,    0,    0, 
            0,  189,    0,    0,    0,    0,    0,    0,    0,  283, 
          283,  283,  283,  283,  283,  283,  283,  283,  283,  283, 
          283,  283,  283,    0,    0,  283,  283,  283,    0,    0, 
          283,  189,    0,    0,    0,    0,    0,    0,  283,  186, 
          283,    0,  283,  283,  283,  283,  283,  283,  283,  186, 
          283,    0,    0,  193,  193,  193,    0,    0,  193,  193, 
          193,    0,  193,  189,    0,    0,    0,    0,    0,    0, 
            0,    0,  193,  193,    0,    0,    0,    0,    0,    0, 
          186,  193,  193,  186,  193,  193,  193,  193,  193,    0, 
            0,    0,    0,    0,    0,    0,    0,  186,  186,    0, 
            0,    0,  186,    0,    0,    0,    0,    0,    0,    0, 
            0,  193,  193,  193,  193,  193,  193,  193,  193,  193, 
          193,    0,  193,  193,    0,    0,  193,  193,    0,    0, 
            0,  193,  186,    0,    0,    0,    0,  193,    0,  193, 
            0,  193,    0,  193,  193,  193,  193,  193,  193,  193, 
            0,  193,  188,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  188,    0,  186,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  188,    0,    0,  188,    0,    0,    0, 
          189,  189,  189,    0,    0,  189,  189,  189,    0,  189, 
          188,  188,    0,    0,    0,  188,    0,    0,    0,  189, 
          189,    0,    0,    0,    0,    0,    0,    0,  189,  189, 
            0,  189,  189,  189,  189,  189,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  188,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  189,  189, 
          189,  189,  189,  189,  189,  189,  189,  189,    0,  189, 
          189,    0,    0,  189,  189,    0,    0,  188,  189,    0, 
            0,    0,    0,    0,  189,    0,  189,  187,  189,    0, 
          189,  189,  189,  189,  189,  189,  189,  187,  189,    0, 
            0,  186,  186,  186,    0,    0,  186,  186,  186,    0, 
          186,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          186,  186,    0,    0,    0,    0,    0,    0,  187,  186, 
          186,  187,  186,  186,  186,  186,  186,    0,    0,    0, 
            0,    0,    0,    0,    0,  187,  187,    0,    0,    0, 
          187,    0,    0,    0,    0,    0,    0,    0,    0,  186, 
          186,  186,  186,  186,  186,  186,  186,  186,  186,    0, 
          186,  186,    0,    0,  186,  186,    0,    0,    0,  186, 
          187,    0,    0,    0,    0,  186,    0,  186,    0,  186, 
            0,  186,  186,  186,  186,  186,  186,  186,    0,  186, 
          190,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          190,    0,  187,    0,  188,  188,  188,    0,    0,  188, 
          188,  188,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  188,  188,    0,    0,    0,    0,    0, 
            0,  190,  188,  188,  190,  188,  188,  188,  188,  188, 
            0,    0,    0,    0,    0,    0,    0,    0,  190,  190, 
            0,    0,    0,  190,    0,    0,    0,    0,    0,    0, 
            0,    0,  188,  188,  188,  188,  188,  188,  188,  188, 
          188,  188,    0,  188,  188,    0,    0,  188,  188,    0, 
            0,    0,  188,  190,    0,    0,    0,    0,  188,    0, 
          188,  191,  188,    0,  188,  188,  188,  188,  188,  188, 
          188,  191,  188,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  191,    0,    0,  191,    0,    0,    0,  187, 
          187,  187,    0,    0,  187,  187,  187,    0,  187,  191, 
          191,    0,    0,    0,  191,    0,    0,    0,  187,  187, 
            0,    0,    0,    0,    0,    0,    0,  187,  187,    0, 
          187,  187,  187,  187,  187,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  191,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  187,  187,  187, 
          187,  187,  187,  187,  187,  187,  187,    0,  187,  187, 
            0,    0,  187,  187,    0,    0,  191,  187,    0,    0, 
            0,    0,    0,  187,    0,  187,    0,  187,    0,  187, 
          187,  187,  187,  187,  187,  187,    0,  187,  423,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  423,    0, 
            0,    0,  190,  190,  190,    0,    0,  190,  190,  190, 
            0,  190,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  190,  190,    0,    0,    0,    0,    0,    0,  423, 
          190,  190,   74,  190,  190,  190,  190,  190,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  423,    0,   82, 
            0,  423,    0,    0,    0,    0,    0,    0,    0,    0, 
          190,  190,  190,  190,  190,  190,  190,  190,  190,  190, 
            0,  190,  190,    0,    0,  190,  190,    0,    0,  423, 
          190,    0,    0,    0,    0,    0,  190,    0,  190,  273, 
          190,    0,  190,  190,  190,  190,  190,  190,  190,  273, 
          190,    0,    0,  191,  191,  191,    0,    0,  191,  191, 
          191,    0,  191,  423,    0,    0,    0,    0,    0,    0, 
            0,    0,  191,  191,    0,    0,    0,    0,    0,    0, 
          273,  191,  191,   81,  191,  191,  191,  191,  191,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  273,    0, 
           89,    0,  273,    0,    0,    0,    0,    0,    0,    0, 
            0,  191,  191,  191,  191,  191,  191,  191,  191,  191, 
          191,    0,  191,  191,    0,    0,  191,  191,    0,    0, 
          273,  191,    0,    0,    0,    0,    0,  191,    0,  191, 
            0,  191,    0,  191,  191,  191,  191,  191,  191,  191, 
            0,  191,    0,  279,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  279,  273,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  279,    0,    0,   80,    0,    0, 
          423,  423,  423,    0,    0,    0,  423,  423,    0,  423, 
            0,    0,  279,    0,   88,    0,  279,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  423,  423, 
            0,  423,  423,  423,  423,  423,    0,    0,    0,    0, 
            0,    0,    0,    0,  279,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  423,  423,  423, 
          423,  423,  423,  423,  423,  423,  423,  423,  423,  423, 
          423,    0,    0,  423,  423,  423,    0,  424,  279,    0, 
            0,    0,    0,    0,    0,    0,  423,  280,  423,    0, 
          423,  423,  423,  423,  423,  423,  423,  280,  423,    0, 
            0,  273,  273,  273,    0,    0,    0,  273,  273,    0, 
          273,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  280,  273, 
          273,   75,  273,  273,  273,  273,  273,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  280,    0,   83,    0, 
          280,    0,    0,    0,    0,    0,    0,    0,  273,  273, 
          273,  273,  273,  273,  273,  273,  273,  273,  273,  273, 
          273,  273,    0,    0,  273,  273,  273,    0,  280,    0, 
            0,    0,    0,    0,    0,    0,    0,  273,    0,  273, 
            0,  273,  273,  273,  273,  273,  273,  273,  184,  273, 
            0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,  184,    0,    0,    0,  280,    0,    0,  279, 
          279,  279,    0,    0,    0,  279,  279,    0,  279,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  184,    0,    0,  184,  279,  279,    0, 
          279,  279,  279,  279,  279,    0,    0,    0,    0,    0, 
          184,  184,    0,    0,    0,  184,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
            0,    0,  279,  279,  279,  184,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  279,  185,  279,    0,  279, 
          279,  279,  279,  279,  279,  279,  185,  279,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  184,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  185,    0,    0, 
          185,    0,    0,  280,  280,  280,    0,    0,    0,  280, 
          280,    0,  280,    0,  185,  185,    0,    0,    0,  185, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  280,  280,    0,  280,  280,  280,  280,  280,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  185, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,    0,    0,  280,  280,  280,    0, 
            0,  185,    0,    0,    0,    0,    0,    0,    0,  280, 
            0,  280,    0,  280,  280,  280,  280,  280,  280,  280, 
            0,  280,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  184,  184,  184,    0,    0,  184, 
          184,  184,    0,  184,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  184,  184,    0,    0,    0,    0,    0, 
            0,  209,  184,  184,    0,  184,  184,  184,  184,  184, 
            0,  209,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  184,  184,  184,  184,  184,  184,  184,  184, 
          184,  184,  209,  184,  184,  209,    0,  184,  184,    0, 
            0,    0,  184,    0,    0,    0,    0,    0,  184,  209, 
          209,    0,  184,    0,  209,    0,  184,  184,  184,  184, 
          184,    0,  184,    0,    0,    0,    0,    0,  185,  185, 
          185,    0,    0,  185,  185,  185,    0,  185,    0,    0, 
            0,    0,    0,    0,  209,    0,    0,  185,  185,    0, 
            0,    0,    0,    0,    0,  210,  185,  185,    0,  185, 
          185,  185,  185,  185,    0,  210,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  209,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  185,  185,  185,  185, 
          185,  185,  185,  185,  185,  185,  210,  185,  185,  210, 
            0,  185,  185,    0,    0,    0,  185,    0,    0,    0, 
            0,    0,  185,  210,  210,    0,  185,    0,  210,    0, 
          185,  185,  185,  185,  185,    0,  185,    0,    0,    0, 
            0,    0,    0,    0,    0,  196,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  196,    0,    0,  210,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  196,    0,    0,  196, 
          210,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  196,  196,    0,    0,    0,  196,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  209,  209,  209,    0,    0,  209,  209, 
          209,    0,  209,    0,    0,    0,    0,    0,  196,    0, 
            0,    0,  209,  209,    0,    0,    0,    0,    0,    0, 
          194,  209,  209,    0,  209,  209,  209,  209,  209,    0, 
          194,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          196,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  209,  209,  209,  209,  209,  209,  209,  209,  209, 
          209,  194,  209,  209,  194,    0,  209,  209,    0,    0, 
            0,  209,    0,    0,    0,    0,    0,  209,  194,  194, 
            0,  209,    0,  194,    0,    0,    0,  209,  209,  209, 
            0,  209,    0,    0,    0,    0,    0,  210,  210,  210, 
            0,    0,  210,  210,  210,    0,  210,    0,    0,    0, 
            0,    0,    0,  194,    0,    0,  210,  210,    0,    0, 
            0,    0,    0,    0,    0,  210,  210,    0,  210,  210, 
          210,  210,  210,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  194,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  210,  210,  210,  210,  210, 
          210,  210,  210,  210,  210,    0,  210,  210,    0,    0, 
          210,  210,    0,    0,    0,  210,    0,  196,  196,  196, 
            0,  210,  196,  196,  196,  210,  196,    0,    0,    0, 
            0,  210,  210,  210,    0,  210,  196,  196,    0,    0, 
            0,    0,    0,    0,  195,  196,  196,    0,  196,  196, 
          196,  196,  196,    0,  195,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  196,  196,  196,  196,  196, 
          196,  196,  196,  196,  196,  195,  196,  196,  195,    0, 
            0,    0,    0,    0,    0,  196,    0,    0,    0,    0, 
            0,  196,  195,  195,    0,  196,    0,  195,    0,    0, 
            0,  196,  196,  196,    0,  196,    0,    0,    0,    0, 
            0,    0,  194,  194,  194,    0,    0,  194,  194,  194, 
            0,  194,    0,    0,    0,    0,    0,  195,    0,    0, 
            0,  194,  194,    0,    0,    0,    0,    0,    0,    0, 
          194,  194,    0,  194,  194,  194,  194,  194,    0,   90, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  195, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          194,  194,  194,  194,  194,  194,  194,  194,  194,  194, 
            0,  194,  194,    0,    0,    0,    0,    0,    0,    0, 
          194,    0,    0,    0,    0,    0,  194,    0,   90,    0, 
            0,    0,    0,    0,    0,    0,  194,  194,  194,    0, 
          194,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          412,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   91,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  195,  195,  195,    0, 
            0,  195,  195,  195,    0,  195,    0,    0,    0,    0, 
            0,   91,    0,    0,    0,  195,  195,    0,    0,    0, 
            0,    0,    0,    0,  195,  195,    0,  195,  195,  195, 
          195,  195,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  415,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  195,  195,  195,  195,  195,  195, 
          195,  195,  195,  195,    0,  195,  195,    0,    0,    0, 
            0,    0,    0,    0,  195,    0,    0,    0,    0,    0, 
          195,   90,    0,    0,    0,    0,    0,    0,    0,    0, 
          195,  195,  195,    0,  195,   90,   90,   90,   90,   90, 
           90,   90,   90,   90,   90,   90,    0,    0,   90,   90, 
            0,   90,   90,   90,   90,   90,   90,   90,    0,  469, 
            0,    0,   90,   90,   90,   90,   90,   90,   90,    0, 
           90,   90,    0,    0,    0,    0,    0,   90,   90,   90, 
           90,   90,   90,   90,   90,   90,   90,   90,   90,    0, 
           90,   90,   90,   90,    0,   90,   90,   90,    0,    0, 
            0,    0,  476,    0,    0,    0,    0,    0,    0,  412, 
            0,    0,    0,    0,    0,    0,  412,   90,    0,    0, 
           90,  469,   90,   90,   90,    0,   90,    0,    0,    0, 
           90,    0,    0,    0,   91,   90,    0,    0,   90,    0, 
          469,    0,   90,   90,   90,   90,   90,   90,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,    0, 
            0,   91,   91,    0,   91,   91,   91,   91,   91,   91, 
           91,    0,  470,    0,    0,   91,   91,   91,   91,   91, 
           91,   91,    0,   91,   91,    0,    0,    0,    0,    0, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,    0,   91,   91,   91,   91,    0,   91,   91, 
           91,    0,    0,    0,    0,  278,    0,    0,    0,    0, 
            0,    0,  415,    0,    0,    0,    0,    0,    0,  415, 
           91,    0,    0,   91,  470,   91,   91,   91,    0,   91, 
            0,    0,    0,   91,    0,    0,    0,    0,   91,    0, 
            0,   91,   91,  470,    0,   91,   91,   91,   91,   91, 
           91,    0,    0,    0,    0,    0,    0,   90,   90,   90, 
           90,   90,   90,   90,   90,   90,   90,   90,    0,    0, 
           90,   90,    0,   90,   90,   90,   90,   90,   90,   90, 
            0,  476,    0,    0,   90,   90,   90,   90,   90,   90, 
           90,   91,    0,   90,    0,    0,    0,    0,    0,   90, 
           90,   90,   90,   90,   90,   90,   90,   90,   90,   90, 
           90,    0,   90,   90,   90,   90,    0,   90,   90,   90, 
            0,    0,    0,  279,    0,    0,    0,    0,    0,    0, 
            0,  476,    0,    0,    0,    0,    0,    0,  476,   90, 
            0,    0,   90,  472,   90,   90,   90,    0,   90,    0, 
            0,    0,   90,    0,    0,  323,    0,   90,    0,    0, 
           90,    0,  476,    0,   90,   90,   90,   90,   90,   90, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,    0,    0,   91,   91,    0,   91,   91,   91,   91, 
           91,   91,   91,    0,    0,    0,    0,   91,   91,   91, 
           91,   91,   91,   91,  323,    0,   91,    0,    0,    0, 
            0,    0,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,   91,   91,    0,   91,   91,   91,   91,    0, 
           91,   91,   91,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  278,    0,    0,    0,    0,    0, 
            0,  278,   91,    0,    0,   91,  473,   91,   91,   91, 
            0,   91,    0,    0,    0,   91,    0,    0,    0,    0, 
           91,    0,    0,   91,  492,    0,    0,   91,   91,   91, 
           91,   91,   91,    0,    0,    0,    0,    0,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,    0, 
            0,   91,   91,    0,   91,   91,   91,   91,   91,   91, 
           91,    0,    0,    0,    0,   91,   91,   91,   91,   91, 
           91,   91,    0,  492,   91,    0,    0,    0,    0,    0, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,   91,    0,   91,   91,   91,   91,    0,   91,   91, 
           91,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  279,    0,    0,    0,    0,    0,    0,  279, 
           91,    0,    0,   91,    0,   91,   91,   91,    0,   91, 
            0,    0,    0,   91,    0,    0,    0,  492,   91,    0, 
            0,   91,    0,    0,    0,   91,   91,   91,   91,   91, 
           91,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,    0,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,    0,    0,    0,    0,  323,  323, 
          323,  323,  323,  323,  323,    0,  492,  323,    0,    0, 
            0,    0,    0,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,    0,  323,  323,  323,  323, 
            0,  323,  323,  323,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  323,    0,    0,  323,    0,  323,  323, 
          323,    0,  323,    0,    0,    0,  323,    0,    0,    0, 
            0,    0,  492,    0,  323,  216,    0,    0,  323,  323, 
          323,  323,  323,  323,    0,    0,    0,    0,    0,    0, 
          492,  492,  492,  492,  492,  492,    0,    0,  492,  492, 
          492,    0,    0,    0,  492,    0,  492,  492,  492,  492, 
          492,  492,  492,    0,    0,    0,    0,  492,  492,  492, 
          492,  492,  492,  492,  217,    0,  492,    0,    0,    0, 
            0,    0,  492,  492,  492,  492,  492,  492,  492,  492, 
          492,  492,  492,  492,    0,  492,  492,  492,  492,    0, 
          492,  492,  492,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  492,    0,    0,  492,    0,  492,  492,  492, 
            0,  492,    0,    0,    0,  492,    0,    0,    0,    0, 
            0,    0,    0,  492,    0,    0,    0,  492,  492,  492, 
          492,  492,  492,  492,  492,  492,  492,  492,  492,    0, 
            0,    0,  492,  492,    0,    0,    0,  492,    0,  492, 
          492,  492,  492,  492,  492,  492,    0,    0,    0,    0, 
          492,  492,  492,  492,  492,  492,  492,    0,    0,  492, 
            0,    0,    0,    0,    0,  492,  492,  492,  492,  492, 
          492,  492,  492,  492,  492,  492,  492,    0,  492,  492, 
          492,  492,    0,  492,  492,  492,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  492,   42,    0,  492,    0, 
          492,  492,  492,    0,  492,    0,   42,    0,  492,    0, 
            0,    0,    0,    0,    0,    0,  492,    0,    0,    0, 
          492,  492,  492,  492,  492,  492,    0,    0,    0,    0, 
            0,    0,    4,    5,    6,    0,    8,   42,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,   42,   42,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,  199,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,  199,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,    0,   39,   40,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  199,    0,    0,  199, 
            0,    0,    0,  207,    0,    0,  107,    0,   48,   49, 
           50,   42,    0,  199,  199,    0,   52,    0,  199,    0, 
            0,    0,    0,    0,   53,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,    0,  201,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  201,    0,    0,  199,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  201,    0,  172,  201, 
          199,    0,    0,    0,    0,    0,    0,    0,  172,    0, 
            0,    0,    0,  201,  201,    0,    0,    0,  201,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  200,    0,    0,    0,  172, 
            0,    0,  217,    0,    0,  200,    0,    0,  201,    0, 
            0,    0,    0,    0,    0,    0,    0,  172,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   42,   42, 
           42,    0,    0,   42,   42,   42,  200,   42,    0,  200, 
          201,    0,    0,    0,    0,    0,    0,   42,    0,    0, 
            0,    0,    0,  200,  200,    0,   42,   42,  200,   42, 
           42,   42,   42,   42,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  172,    0,    0,    0,    0,  200,    0, 
            0,    0,    0,    0,    0,    0,    0,  199,  199,  199, 
            0,    0,  199,  199,  199,    0,  199,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  199,  199,    0,    0, 
          200,    0,    0,    0,    0,  199,  199,    0,  199,  199, 
          199,  199,  199,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  199,  199,  199,  199,  199, 
          199,  199,  199,  199,  199,    0,  199,  199,    0,    0, 
            0,    0,    0,    0,    0,  199,    0,  201,  201,  201, 
            0,  199,  201,  201,  201,    0,  201,    0,    0,    0, 
            0,  199,  199,    0,    0,    0,  201,  201,    0,    0, 
            0,    0,    0,    0,    0,  201,  201,    0,  201,  201, 
          201,  201,  201,    0,    0,    0,    0,    0,    0,    0, 
          172,  172,  172,    0,   47,    0,  172,  172,    0,  172, 
            0,    0,    0,    0,   47,  201,  201,  201,  201,  201, 
          201,  201,  201,  201,  201,    0,  201,  201,  172,  172, 
            0,  172,  172,  172,  172,  201,    0,  200,  200,  200, 
            0,  201,  200,  200,  200,   47,  200,    0,    0,    0, 
          198,  201,  201,    0,    0,    0,  200,  200,    0,    0, 
          198,    0,   47,   47,    0,  200,  200,    0,  200,  200, 
          200,  200,  200,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  198,    0,    0,  198,  200,  200,  200,  200,  200, 
          200,  200,  200,  200,  200,    0,  200,  200,  198,  198, 
            0,    0,    0,  198,    0,  200,    0,    0,    0,    0, 
            0,  200,    0,    0,    0,    0,    0,    0,    0,   47, 
          197,  200,  200,    0,    0,    0,    0,    0,    0,    0, 
          197,    0,    0,  198,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  197,    0,    0,  197,  198,    0,    0,    0,    0, 
            0,    0,    0,    0,  202,    0,    0,    0,  197,  197, 
            0,    0,    0,  197,  202,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  197,    0,  202,    0,    0,  202,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  202,  202,    0,    0,    0,  202,    0,    0, 
            0,    0,    0,    0,    0,  197,    0,    0,    0,    0, 
            0,    0,    0,    0,  203,    0,   47,   47,   47,    0, 
            0,   47,   47,   47,  203,   47,    0,  202,    0,    0, 
            0,    0,    0,    0,    0,   47,    0,    0,    0,    0, 
            0,    0,    0,    0,   47,   47,    0,   47,   47,   47, 
           47,   47,    0,    0,    0,  203,    0,    0,  203,  202, 
            0,    0,  198,  198,  198,    0,    0,  198,  198,  198, 
            0,  198,  203,  203,    0,    0,    0,  203,    0,    0, 
            0,  198,  198,    0,    0,    0,    0,    0,    0,    0, 
          198,  198,    0,  198,  198,  198,  198,  198,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  203,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          198,  198,  198,  198,  198,  198,  198,  198,  198,  198, 
            0,  198,  198,    0,    0,    0,    0,    0,    0,  203, 
          198,    0,  197,  197,  197,    0,  198,  197,  197,  197, 
          204,  197,    0,    0,    0,    0,  198,  198,    0,    0, 
          204,  197,  197,    0,    0,    0,    0,    0,    0,    0, 
          197,  197,    0,  197,  197,  197,  197,  197,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  204,    0,    0,  204,    0,  202,  202,  202,    0, 
            0,  202,  202,  202,  211,  202,  197,  197,  204,  204, 
            0,  197,  197,  204,  211,  202,  202,    0,    0,    0, 
          197,    0,    0,    0,  202,  202,  197,  202,  202,  202, 
          202,  202,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  204,    0,  211,    0,    0,  211,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  205,    0, 
          202,  202,  211,  211,    0,  202,  202,  211,  205,    0, 
            0,    0,    0,    0,  202,  204,  203,  203,  203,    0, 
          202,  203,  203,  203,    0,  203,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  203,  203,  211,    0,  205, 
            0,    0,  205,    0,  203,  203,    0,  203,  203,  203, 
          203,  203,  206,    0,    0,    0,  205,  205,    0,    0, 
            0,  205,  206,    0,    0,    0,    0,    0,    0,  211, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          203,  203,    0,    0,    0,  203,  203,    0,    0,    0, 
            0,  205,    0,  206,  203,    0,  206,    0,    0,    0, 
          203,    0,    0,    0,    0,    0,  212,    0,    0,    0, 
          206,  206,    0,    0,    0,  206,  212,    0,    0,    0, 
            0,    0,    0,  205,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  206,    0,  212,    0,    0, 
          212,    0,  204,  204,  204,    0,    0,  204,  204,  204, 
          182,  204,    0,    0,  212,  212,    0,    0,    0,  212, 
          182,  204,  204,    0,    0,    0,    0,  206,    0,    0, 
          204,  204,    0,  204,  204,  204,  204,  204,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  212, 
            0,  182,    0,    0,  182,    0,  211,  211,  211,    0, 
            0,  211,  211,  211,  183,  211,  204,  204,  182,  182, 
            0,  204,  204,  182,  183,  211,  211,    0,    0,    0, 
          204,  212,    0,    0,  211,  211,  204,  211,  211,  211, 
          211,  211,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  182,    0,  183,    0,    0,  183,    0, 
          205,  205,  205,    0,    0,  205,  205,  205,  217,  205, 
          211,  211,  183,  183,    0,  211,  211,  183,  217,  205, 
          205,    0,    0,    0,  211,  182,    0,    0,  205,  205, 
          211,  205,  205,  205,  205,  205,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  183,    0,  217, 
            0,    0,  217,    0,  206,  206,  206,    0,    0,  206, 
          206,  206,  181,  206,  205,  205,  217,  217,    0,  205, 
          205,    0,  181,  206,  206,    0,    0,    0,  205,  183, 
            0,    0,  206,  206,  205,  206,  206,  206,  206,  206, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  217,    0,  181,    0,    0,  181,    0,  212,  212, 
          212,    0,    0,  212,  212,  212,  174,  212,  206,  206, 
          181,  181,    0,  206,  206,    0,  174,  212,  212,    0, 
            0,    0,  206,  217,    0,    0,  212,  212,  206,  212, 
          212,  212,  212,  212,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  181,    0,  174,    0,    0, 
          174,    0,  182,  182,  182,    0,    0,  182,  182,  182, 
          214,  182,    0,  212,  174,  174,    0,  212,  212,    0, 
          214,  182,  182,    0,    0,    0,  212,  181,    0,    0, 
          182,  182,  212,  182,  182,  182,  182,  182,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
            0,  214,    0,    0,  214,    0,  183,  183,  183,    0, 
            0,  183,  183,  183,  180,  183,    0,    0,  214,  214, 
            0,    0,    0,    0,  180,  183,  183,    0,    0,    0, 
          182,  174,    0,    0,  183,  183,  182,  183,  183,  183, 
          183,  183,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  214,    0,  180,    0,    0,  180,    0, 
          217,  217,  217,    0,    0,  217,  217,  217,  215,  217, 
            0,    0,  180,  180,    0,    0,    0,    0,  215,  217, 
          217,    0,    0,    0,  183,  214,    0,    0,  217,  217, 
          183,  217,  217,  217,  217,  217,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  180,    0,  215, 
            0,    0,  215,    0,  181,  181,  181,    0,    0,  181, 
          181,  181,  176,  181,    0,    0,  215,  215,    0,    0, 
            0,    0,  176,  181,  181,    0,    0,    0,  217,  180, 
            0,    0,  181,  181,  217,  181,  181,  181,  181,  181, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  215,    0,  176,    0,    0,  176,    0,  174,  174, 
          174,    0,    0,  174,  174,  174,  177,  174,    0,    0, 
          176,  176,    0,    0,    0,    0,  177,  174,  174,    0, 
            0,    0,  181,  215,    0,    0,  174,  174,  181,  174, 
          174,  174,  174,  174,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  176,    0,  177,    0,    0, 
          177,    0,  214,  214,  214,    0,    0,  214,  214,  214, 
          178,  214,    0,    0,  177,  177,    0,    0,    0,    0, 
          178,  214,  214,    0,    0,    0,  174,  176,    0,    0, 
          214,  214,  174,  214,  214,  214,  214,  214,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  177, 
            0,  178,    0,    0,  178,    0,  180,  180,  180,    0, 
            0,  180,  180,  180,  179,  180,    0,    0,  178,  178, 
            0,    0,    0,    0,  179,  180,  180,    0,    0,    0, 
          214,  177,    0,    0,  180,  180,  214,  180,  180,  180, 
          180,  180,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  178,    0,  179,    0,    0,  179,    0, 
          215,  215,  215,    0,    0,  215,  215,  215,  173,  215, 
            0,    0,  179,  179,    0,    0,    0,    0,  173,  215, 
          215,    0,    0,    0,  180,  178,    0,    0,  215,  215, 
          180,  215,  215,  215,  215,  215,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  179,    0,  173, 
            0,    0,  173,    0,  176,  176,  176,    0,    0,  176, 
          176,  176,  175,  176,    0,    0,  173,  173,    0,    0, 
            0,    0,  175,  176,  176,    0,    0,    0,  215,  179, 
            0,    0,  176,  176,  215,  176,  176,  176,  176,  176, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  173,    0,  175,    0,    0,  175,    0,  177,  177, 
          177,    0,    0,  177,  177,  177,  261,  177,    0,    0, 
          175,  175,    0,    0,    0,    0,  261,  177,  177,    0, 
            0,    0,  176,  173,    0,    0,  177,  177,  176,  177, 
          177,  177,  177,  177,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  175,    0,  261,    0,    0, 
          261,    0,  178,  178,  178,    0,    0,  178,  178,  178, 
          172,  178,    0,    0,  261,  261,    0,    0,    0,    0, 
          172,  178,  178,    0,    0,    0,  177,  175,    0,    0, 
          178,  178,  177,  178,  178,  178,  178,  178,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  261, 
            0,  172,    0,    0,  172,    0,  179,  179,  179,    0, 
            0,  179,  179,  179,  262,  179,    0,    0,  172,  172, 
            0,    0,    0,    0,  262,  179,  179,    0,    0,    0, 
          178,  261,    0,    0,  179,  179,  178,  179,  179,  179, 
          179,  179,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  172,    0,  262,    0,    0,  262,    0, 
          173,  173,  173,    0,    0,  173,  173,  173,  494,  173, 
            0,    0,  262,  262,    0,    0,    0,    0,  494,  173, 
          173,    0,    0,    0,  179,  172,    0,    0,  173,  173, 
          179,  173,  173,  173,  173,  173,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  262,    0,  494, 
            0,    0,    0,    0,  175,  175,  175,    0,    0,  175, 
          175,  175,    0,  175,    0,    0,  494,  494,    0,    0, 
            0,    0,    0,  175,  175,    0,    0,    0,  173,  262, 
            0,    0,  175,  175,  173,  175,  175,  175,  175,  175, 
            0,    0,    0,    0,  412,    0,    0,    0,    0,    0, 
            0,  494,    0,    0,    0,    0,    0,    0,  261,  261, 
          261,    0,    0,  261,  261,  261,    0,  261,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  261,  261,    0, 
            0,    0,  175,  494,    0,    0,  261,  261,  175,  261, 
          261,  261,  261,  261,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  172,  172,  172,    0,    0,  172,  172,  172, 
            0,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  172,  172,    0,    0,    0,    0,    0,    0,    0, 
          172,  172,  261,  172,  172,  172,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  262,  262,  262,    0, 
            0,  262,  262,  262,  396,  262,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  262,  262,    0,    0,    0, 
          172,    0,    0,    0,  262,  262,  172,  262,  262,  262, 
          262,  262,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          494,  494,  494,    0,    0,  494,  494,  494,    0,  494, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  494, 
          494,    0,    0,    0,    0,    0,    0,    0,  494,  494, 
          262,  494,  494,  494,  494,  494,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,   52,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,   52,    0,    0,    0,   98,   20,   21,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,  494,   31,   32,   33,   34,   35, 
           36,   37,   38,   52,   39,   40,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  207,    0,    0,  107,    0,   48,   49,   50,    0, 
          231,    0,  232,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,   52,   54,   55,   56,   57, 
           58,   59,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,   54,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,   54,    0,    0,   52,   19,   20, 
           21,   22,   23,   24,   25,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,   26,    0,    0,    0,    0,    0,   27,   28,   29, 
           30,   31,   32,   33,   34,   35,   36,   37,   38,   54, 
           39,   40,   41,   42,   56,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,   56,    0,   54,   54,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   46,    0,    0, 
           47,    0,   48,   49,   50,    0,   51,    0,    0,    0, 
           52,    0,    0,    0,    0,   56,    0,    0,   53,    0, 
            0,   54,   54,   55,   56,   57,   58,   59,    0,    0, 
           41,    0,   56,   56,    0,    0,    0,    0,    0,    0, 
           41,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   54,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   56,    0,    0, 
            0,   41,    0,    0,    0,    0,    0,    0,   52,   52, 
           52,    0,    0,   52,   52,   52,    0,   52,   41,   41, 
            0,    0,    0,    0,    0,    0,    0,   52,   52,   56, 
            0,    0,    0,    0,    0,    0,   52,   52,    0,   52, 
           52,   52,   52,   52,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,   41,    0,    0,    0,    0, 
            0,    0,  101,    0,    0,   31,   32,  102,   34,   35, 
           36,  103,   38,    0,   39,   40,   41,   42,    0,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,    0,    0, 
           54,   54,   54,    0,    0,   54,   54,   54,    0,   54, 
            0,  106,    0,    0,  107,    0,   48,   49,   50,   54, 
           54,    0,    0,    0,    0,    0,    0,    0,   54,   54, 
            0,   54,   54,   54,   54,   54,   54,   55,   56,   57, 
           58,   59,    0,    0,    0,    0,   56,   56,   56,    0, 
            0,   56,   56,   56,    0,   56,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   56,   56,    0,    0,    0, 
            0,    0,    0,    0,   56,   56,    0,   56,   56,   56, 
           56,   56,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   41,   41,   41,    0,    0,   41,   41,   41, 
            0,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   41,   41,   41,   41,   41,    3,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,   33,   34,   35,   36, 
           37,   38,    0,   39,   40,   41,   42,    0,   43,   44, 
           45,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           46,    0,    0,   47,    0,   48,   49,   50,    0,   51, 
            0,    0,    0,   52,    0,    0,    0,    0,    0,    0, 
            0,   53,    0,    0,    0,   54,   55,   56,   57,   58, 
           59,    3,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,   29,   30,   31,   32,   33, 
           34,   35,   36,   37,   38,    0,   39,   40,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   46,    0,    0,  263,    0,   48,   49, 
           50,    0,   51,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,   53,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,   29,   30,   31, 
           32,   33,   34,   35,   36,   37,   38,    0,   39,   40, 
           41,   42,    0,   43,   44,   45,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   46,    0,    0,   47,    0, 
           48,   49,   50,    0,   51,    0,    0,    0,   52,    0, 
            0,    0,    0,    0,    0,    0,   53,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,    0, 
           39,   40,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  207,    0,    0, 
          107,    0,   48,   49,   50,    0,  619,    0,  232,    0, 
           52,    0,    0,    0,    0,    0,    0,    0,   53,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   20,   21,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,    0,   39,   40,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,   48,   49,   50,    0,  231,    0, 
          232,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          233,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   20,   21,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,    0,   39,   40,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  207,    0,    0,  107,    0,  414,   49,   50,    0, 
          231,    0,  232,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,   54,   55,   56,   57, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,    0,   39,   40,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  207,    0,    0,  107,    0,   48,   49, 
           50,    0,  611,    0,  232,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  233,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   99,  100,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,   34,   35,   36,   37,   38,    0,   39,   40, 
           41,   42,    0,   43,   44,   45,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  207,    0,    0,  107,    0, 
           48,   49,   50,    0,  615,    0,  232,    0,   52,    0, 
            0,    0,    0,    0,    0,    0,  233,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   20,   21,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,    0, 
           39,   40,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  207,    0,    0, 
          107,    0,   48,   49,   50,    0,  611,    0,  232,    0, 
           52,    0,    0,    0,    0,    0,    0,    0,  233,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,    0,   39,   40,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,   48,   49,   50,    0,  804,    0, 
          232,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          233,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,    0,   39,   40,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  207,    0,    0,  107,    0,   48,   49,   50,    0, 
          808,    0,  232,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,   54,   55,   56,   57, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,    0,   39,   40,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  207,    0,    0,  107,    0,   48,   49, 
           50,    0,  812,    0,  232,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  233,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   99,  100,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,   34,   35,   36,   37,   38,    0,   39,   40, 
           41,   42,    0,   43,   44,   45,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  207,    0,    0,  107,    0, 
           48,   49,   50,    0,  867,    0,  232,    0,   52,    0, 
            0,    0,    0,    0,    0,    0,  233,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,    0, 
           39,   40,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  207,    0,    0, 
          107,    0,   48,   49,   50,    0,  869,    0,  232,    0, 
           52,    0,    0,    0,    0,    0,    0,    0,  233,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,    0,   39,   40,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,   48,   49,   50,    0,  881,    0, 
          232,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          233,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
          251,  251,  251,    0,  251,    0,    0,    0,  251,  251, 
            0,    0,    0,  251,    0,  251,  251,  251,  251,  251, 
          251,  251,    0,    0,    0,    0,  251,  251,  251,  251, 
          251,  251,  251,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  251,    0,    0,  251,  251,  251,  251,  251, 
          251,  251,  251,    0,  251,  251,  251,  251,    0,  251, 
          251,  251,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  251,    0,    0,  251,    0,  251,  251,  251,    0, 
          251,    0,  251,    0,  251,    0,    0,    0,    0,    0, 
            0,    0,  251,    0,    0,    0,  251,  251,  251,  251, 
          251,  251,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,    0,   39,   40,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  207,    0,    0,  107,    0,   48,   49, 
           50,    0,    0,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,   53,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   20,   21,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,   34,   35,   36,   37,   38,    0,   39,   40, 
           41,   42,    0,   43,   44,   45,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  207,    0,    0,  107,    0, 
           48,   49,   50,    0,  268,    0,    0,    0,   52,    0, 
            0,    0,    0,    0,    0,    0,  233,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,    0, 
           39,   40,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  207,    0,    0, 
          107,    0,   48,   49,   50,    0,  526,    0,    0,    0, 
           52,    0,    0,    0,    0,    0,    0,    0,  233,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,    0,   39,   40,   41,   42,    0,   43,   44,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,  107,    0,   48,   49,   50,    0,  526,    0, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
          233,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,    0,   39,   40,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  207,    0,    0,  107,    0,   48,   49,   50,    0, 
          593,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,   54,   55,   56,   57, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,    0,   39,   40,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  207,    0,    0,  107,    0,   48,   49, 
           50,    0,  643,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  233,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   99,  100,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,   34,   35,   36,   37,   38,    0,   39,   40, 
           41,   42,    0,   43,   44,   45,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  207,    0,    0,  107,    0, 
           48,   49,   50,    0,  769,    0,    0,    0,   52,    0, 
            0,    0,    0,    0,    0,    0,  233,    0,    0,    0, 
           54,   55,   56,   57,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,    0, 
           39,   40,   41,   42,    0,   43,   44,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  207,    0,    0, 
          107,    0,   48,   49,   50,    0,  798,    0,    0,    0, 
           52,    0,    0,    0,    0,    0,    0,    0,  233,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,  483,  483, 
          483,    0,  483,    0,    0,    0,  483,  483,    0,    0, 
            0,  483,    0,  483,  483,  483,  483,  483,  483,  483, 
            0,    0,    0,    0,  483,  483,  483,  483,  483,  483, 
          483,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          483,    0,    0,  483,  483,  483,  483,  483,  483,  483, 
          483,    0,  483,  483,  483,  483,    0,  483,  483,  483, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  483, 
            0,    0,  483,  483,  483,  483,  483,    0,    0,    0, 
            0,    0,  483,    0,    0,    0,    0,    0,    0,    0, 
          483,    0,    0,    0,  483,  483,  483,  483,  483,  483, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,    0,   39,   40,   41,   42,    0,   43, 
           44,   45,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  207,    0,    0,  107,    0,   48,   49,   50,    0, 
            0,    0,    0,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,  233,    0,    0,    0,   54,   55,   56,   57, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,    0,   39,   40,   41,   42, 
            0,   43,   44,   45,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  207,    0,    0,  107,    0,   48,   49, 
           50,    0,    0,    0,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,  233,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,  213,  213,  213,    0,  213,    0, 
            0,    0,  213,  213,    0,    0,    0,  213,    0,  213, 
          213,  213,  213,  213,  213,  213,    0,    0,    0,    0, 
          213,  213,  213,  213,  213,  213,  213,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  213,    0,    0,  213, 
          213,  213,  213,  213,  213,  213,  213,    0,  213,  213, 
          213,  213,    0,  213,  213,  213,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  213,    0,    0,  213,    0, 
          213,  213,  213,    0,    0,    0,    0,    0,  213,    0, 
            0,    0,    0,    0,    0,    0,  213,    0,    0,    0, 
          213,  213,  213,  213,  213,  213,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  101,    0, 
            0,   31,   32,   33,   34,   35,   36,   37,   38,    0, 
           39,   40,   41,   42,    0,    0,    0,  104,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  224,    0,    0, 
           47,    0,   48,   49,   50,    0,   51,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   54,   55,   56,   57,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          101,    0,    0,   31,   32,   33,   34,   35,   36,   37, 
           38,    0,   39,   40,   41,   42,    0,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  278, 
            0,    0,  349,    0,   48,   49,   50,    0,  350,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   54,   55,   56,   57,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  101,    0,    0,   31,   32,   33,   34,   35, 
           36,   37,   38,    0,   39,   40,   41,   42,    0,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  278,    0,    0,  107,    0,   48,   49,   50,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   54,   55,   56,   57, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  101,    0,    0,   31,   32,   33, 
           34,   35,   36,   37,   38,    0,   39,   40,   41,   42, 
            0,    0,    0,  104,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  787,    0,    0,  107,    0,   48,   49, 
           50,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   54,   55, 
           56,   57,   58,   59,  116,  117,  118,  119,  120,  121, 
          122,  123,    0,    0,  124,  125,  126,  127,  128,    0, 
            0,  129,  130,  131,  132,  133,  134,  135,    0,    0, 
          136,  137,  138,  192,  193,  194,  195,  143,  144,  145, 
          146,  147,  148,  149,  150,  151,  152,  153,  154,  196, 
          197,  198,  158,  251,    0,  199,    0,    0,    0,    0, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
            0,  166,  167,    0,    0,  168,    0,    0,    0,    0, 
          169,  170,  171,  172,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,    0,  186, 
          200,  116,  117,  118,  119,  120,  121,  122,  123,    0, 
            0,  124,  125,  126,  127,  128,    0,    0,  129,  130, 
          131,  132,  133,  134,  135,    0,    0,  136,  137,  138, 
          192,  193,  194,  195,  143,  144,  145,  146,  147,  148, 
          149,  150,  151,  152,  153,  154,  196,  197,  198,  158, 
            0,    0,  199,    0,    0,    0,    0,    0,    0,    0, 
          160,  161,    0,  162,  163,  164,  165,    0,  166,  167, 
            0,    0,  168,    0,    0,    0,    0,  169,  170,  171, 
          172,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  174,  175,    0,  176,  177,  178,  179,  180,  181, 
          182,  183,  184,    0,  185,    0,  186,  200,  116,  117, 
          118,  119,  120,  121,  122,  123,    0,    0,  124,  125, 
          126,  127,  128,    0,    0,  129,  130,  131,  132,  133, 
          134,  135,    0,    0,  136,  137,  138,  139,  140,  141, 
          142,  143,  144,  145,  146,  147,  148,  149,  150,  151, 
          152,  153,  154,  155,  156,  157,  158,   35,   36,  159, 
           38,    0,    0,    0,    0,    0,    0,  160,  161,    0, 
          162,  163,  164,  165,    0,  166,  167,    0,    0,  168, 
            0,    0,    0,    0,  169,  170,  171,  172,    0,    0, 
            0,    0,    0,  173,    0,    0,    0,    0,  174,  175, 
            0,  176,  177,  178,  179,  180,  181,  182,  183,  184, 
            0,  185,    0,  186,  116,  117,  118,  119,  120,  121, 
          122,  123,    0,    0,  124,  125,  126,  127,  128,    0, 
            0,  129,  130,  131,  132,  133,  134,  135,    0,    0, 
          136,  137,  138,  192,  193,  194,  195,  143,  144,  145, 
          146,  147,  148,  149,  150,  151,  152,  153,  154,  196, 
          197,  198,  158,  286,  287,  199,  288,    0,    0,    0, 
            0,    0,    0,  160,  161,    0,  162,  163,  164,  165, 
            0,  166,  167,    0,    0,  168,    0,    0,    0,    0, 
          169,  170,  171,  172,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,    0,  186, 
          116,  117,  118,  119,  120,  121,  122,  123,    0,    0, 
          124,  125,  126,  127,  128,    0,    0,  129,  130,  131, 
          132,  133,  134,  135,    0,    0,  136,  137,  138,  192, 
          193,  194,  195,  143,  144,  145,  146,  147,  148,  149, 
          150,  151,  152,  153,  154,  196,  197,  198,  158,    0, 
            0,  199,    0,    0,    0,    0,    0,    0,    0,  160, 
          161,    0,  162,  163,  164,  165,    0,  166,  167,    0, 
            0,  168,    0,    0,    0,    0,  169,  170,  171,  172, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          174,  175,    0,  176,  177,  178,  179,  180,  181,  182, 
          183,  184,    0,  185,    0,  186, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           15,   16,  215,   14,   19,    7,  247,   15,   16,    6, 
          378,   19,   15,   16,   21,  375,   19,   71,    6,    7, 
          392,   51,   27,   15,   16,   27,  342,   19,   43,   44, 
           10,    3,  398,  370,   49,   50,   10,   52,   53,   27, 
           44,  410,   50,  101,   21,   91,  292,   32,   47,  693, 
          296,    4,    5,  369,   10,  522,  523,   54,   50,  570, 
          571,   14,   10,   10,  106,   10,   54,  506,  507,  280, 
           41,  387,   11,   10,   11,  444,  269,  693,  271,   59, 
          310,  697,   10,  310,   58,   59,  402,   94,   44,  263, 
           61,   10,  666,  100,   10,  280,   10,  671,   51,   44, 
          342,   53,    2,    3,    4,    5,  113,   10,    8,    9, 
           10,   11,   59,   10,   14,   15,   16,   94,   10,   19, 
           15,   16,  342,    0,   19,   44,   26,  310,   93,    2, 
           58,   59,   71,   10,   10,   10,   10,   90,  454,   58, 
           59,  371,   44,   59,  371,   59,   10,   47,   48,   49, 
          361,   51,   10,   53,   49,   58,   59,  342,  327,   61, 
          125,   58,   59,   10,  218,   10,   41,   59,  304,  108, 
           44,   10,  308,   10,   47,  349,  361,   10,  125,   10, 
          311,  312,   59,   59,   10,  829,  369,  370,  371,  358, 
           90,  330,  290,  291,   91,  348,   41,   10,  337,  559, 
           58,   59,  361,  200,   41,  105,  308,  107,  545,  267, 
           41,  269,  200,  829,   59,   41,  231,  232,  233,   58, 
           59,  467,  590,   32,  377,   58,   59,   32,  565,  244, 
           41,  246,  247,   91,  107,   10,  244,  364,  246,  247, 
           10,  244,  681,  246,  247,   58,   59,   41,   41,  330, 
           61,   44,  244,  268,  246,  247,  337,   91,   91,  269, 
           41,  271,   41,   41,  263,  282,   41,   61,   61,   44, 
          737,  738,  783,  784,  339,  786,  256,   61,   91,  218, 
           61,   44,   61,   10,  330,  222,  223,   91,  269,   59, 
          271,  337,   61,  267,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          350,  339,  222,  223,  262,  310,  368,  342,   44,  301, 
          345,  346,   59,  348,  306,  264,  340,  352,  346,  267, 
          348,   91,  290,  291,  244,  856,  246,  247,  267,  244, 
          349,  246,  247,  341,  369,  339,  256,  308,  727,  725, 
          418,  419,  377,  263,  733,  302,  303,  304,  305,  377, 
          267,   91,  387,  388,  389,  390,  356,  279,  281,  394, 
          368,  439,  595,  256,  369,  370,  394,  402,  264,  630, 
          263,  406,  407,  345,  346,  410,  348,  350,  386,  414, 
          352,  301,  302,  303,  304,  305,  306,  307,  308,  267, 
           61,  414,  427,  401,  339,  407,  776,  432,  433,  434, 
          425,  340,  414,  425,  363,   59,  441,  799,  267,  444, 
          308,  799,  447,  330,  267,  772,   91,  425,   91,  454, 
          337,  279,  342,  431,  340,  345,  346,  342,  348,  349, 
          350,  269,  352,  271,  267,  330,  358,   44,  397,  398, 
          340,  341,  337,  343,  344,  453,  330,  280,  279,  369, 
          370,  371,  330,  337,  369,   44,  349,  342,   44,  337, 
          849,  310,   10,  383,  342,  279,  315,  387,  368,  826, 
          703,  391,  387,  393,  264,  553,  330,  330,  279,  269, 
          279,  340,  402,  337,  337,  385,  386,  402,  877,  516, 
          383,  526,  290,  291,  414,  290,  291,  330,  391,  835, 
          393,  401,   10,  319,  337,   91,  330,   10,  428,  342, 
          319,   59,  319,  337,  511,   41,  263,  264,  361,  516, 
          369,  370,  549,  311,  312,  522,  523,  358,  361,  339, 
          272,  431,  274,  275,  454,  428,   41,  554,   41,  454, 
          306,   44,   93,   10,  358,  340,  554,  313,  314,  574, 
           58,   59,  574,  453,  240,  125,   59,  358,  593,  358, 
          330,  794,  263,  264,    2,    3,  574,  337,  269,  308, 
            8,    9,   10,   11,   41,  371,  611,   15,   16,  310, 
          615,   19,   10,  542,  619,  268,  269,  544,   26,  371, 
          330,   16,   59,   44,   19,  630,  346,  337,  264,   41, 
          269,   41,   44,   10,   44,  349,  350,  566,  643,   47, 
           48,   49,  690,   41,  267,   53,   44,   41,  630,   61, 
          655,   61,  263,  264,  544,  545,  657,  662,  663,   56, 
           57,   59,  271,  668,  669,   44,   44,   41,  369,  370, 
          371,  319,   44,  678,  679,  565,  125,   41,   41,   91, 
          607,   91,   59,   32,  689,  330,   93,  330,  339,  579, 
          339,   44,  337,  741,  337,  339,  744,  105,   41,  107, 
          348,  339,   93,   10,  352,  353,  264,  712,  713,  714, 
           61,   44,   44,   91,  657,  720,  579,  607,   44,   44, 
          662,  663,  727,  279,  310,  304,  668,  732,  733,  304, 
            2,    3,    4,    5,  732,  340,    8,  263,  339,  732, 
          630,  339,   14,  633,  339,  630,  264,   93,  404,  264, 
          732,  269,   59,  271,  683,   10,  264,  627,  628,  702, 
          650,   44,  767,  310,  769,   91,   44,  657,  658,  349, 
          660,  661,  662,  663,  330,   47,   93,   44,  668,   51, 
           10,  337,  709,  369,  370,  371,  342,  650,   10,  267, 
           44,  796,   41,  798,   41,  658,  725,  660,  661,  804, 
           41,   93,  358,  808,   59,    2,    3,  812,   91,  125, 
          339,    8,  702,  264,  222,  223,  706,   14,   90,  709, 
           41,  264,  369,  370,  371,  767,   10,  339,   58,   59, 
          835,  721,  722,  723,  264,  107,  244,   59,  246,  247, 
           10,  264,  847,  706,  849,   41,  125,  358,  256,  244, 
           47,  246,  247,  264,  125,  263,  834,   44,  721,  722, 
          723,   91,  867,  264,  869,  847,   41,  279,  280,  279, 
          280,  264,  877,  308,   58,   59,  881,  767,  264,   44, 
           44,  771,  772,   41,  264,  262,  263,  264,   58,   59, 
          125,  264,  269,  301,  302,  303,  304,  305,  306,  307, 
          308,  279,  792,   93,  264,   44,   10,   91,  771,  125, 
          107,    2,    3,    4,    5,    6,   93,    8,  330,  271, 
          330,   91,  342,   14,   41,  337,   41,  337,   41,  792, 
          342,   93,  342,   93,  342,   44,  826,  345,  346,  125, 
          348,  349,   93,  125,  352,  835,  358,  837,  358,  361, 
          835,  361,  330,  279,  844,   59,   47,   41,  614,  337, 
           51,  369,  370,  371,  834,  264,   61,    5,  624,  293, 
          294,  295,  296,  297,  837,  383,  776,   10,    6,  387, 
          358,  844,   91,  391,  256,  393,    2,    3,  863,   10, 
          559,  263,    8,  657,  402,   78,  279,  304,   90,   90, 
          307,  308,  309,  836,  330,  247,  414,    0,  697,  264, 
          697,  337,   71,  268,  269,   -1,  107,  304,   -1,   -1, 
          428,   -1,   -1,  330,   -1,   58,   59,   -1,   -1,  301, 
          337,   47,  358,  310,  306,  342,   -1,  267,   59,   -1, 
          347,  348,  349,  350,   -1,   -1,  454,  330,   41,   -1, 
          280,    9,   10,   11,  337,   -1,   -1,  310,   91,  256, 
          347,  348,  349,  350,   -1,   -1,  263,   -1,   26,   -1, 
          726,   -1,    0,  729,  730,  358,   44,  349,  350,   49, 
           -1,   -1,  304,  267,   -1,  307,  308,  309,   -1,    0, 
           48,  107,  369,  370,  371,   -1,  280,  267,  370,   10, 
          330,   -1,   -1,   -1,  301,   -1,   -1,  337,  330,  306, 
           -1,  383,  342,   41,   -1,  337,  369,  370,  371,  391, 
          342,  393,   -1,   91,   -1,  347,  348,  349,  350,   -1, 
           41,  361,  125,   -1,   -1,  304,  544,  545,  307,  308, 
          309,   -1,   41,   -1,   -1,   44,  330,  105,   59,   -1, 
           -1,   -1,  349,  337,  810,  811,  428,  565,  342,   -1, 
          330,   -1,   61,   -1,   -1,  256,   -1,  337,   -1,   -1, 
          279,  579,  263,  370,   -1,   -1,   -1,  361,  347,  348, 
          349,  350,   -1,   -1,   -1,   -1,  383,   -1,   -1,  845, 
          846,   -1,   91,   -1,  391,  851,  393,  125,   -1,  607, 
          304,   -1,   -1,  307,  308,  309,   -1,   -1,   -1,   -1, 
          301,   -1,  868,   -1,  125,  306,   -1,   -1,   10,   -1, 
          876,  330,  630,  879,   -1,  633,  330,  883,  337,  306, 
          307,  428,  309,  337,  267,   -1,  313,  314,  342,   -1, 
          256,   -1,  650,  347,  348,  349,  350,  263,   -1,  358, 
          658,   -1,  660,  661,  662,  663,   -1,   -1,  349,  350, 
          668,   -1,   -1,   -1,  222,  223,   -1,   59,   -1,  262, 
          263,  264,   -1,  545,   -1,  268,  269,   -1,  271,  370, 
           -1,   -1,   -1,  304,   -1,  301,  307,  308,  309,  319, 
          306,   -1,  383,  565,  231,  232,   -1,  330,  706,   -1, 
          391,  709,  393,   -1,  337,  335,  336,  579,   44,  330, 
           -1,  279,  280,  721,  722,  723,  337,   -1,  348,   -1, 
          350,  342,  352,  353,  354,  355,  347,  348,  349,  350, 
           -1,   -1,   -1,  349,  262,  263,  264,  428,   -1,   -1, 
          268,  269,   -1,  271,  302,  303,  304,  305,  545,  307, 
          308,  262,  263,  264,  370,   91,   -1,  268,  269,  767, 
          271,   -1,  330,  771,  772,   -1,   -1,  383,  565,  337, 
           -1,   -1,  342,   -1,  342,  391,   -1,  393,  650,  651, 
          279,  280,  579,   -1,  792,  657,  658,  319,  660,  661, 
          358,   -1,   -1,  361,   -1,   41,   -1,   -1,   44,  369, 
           -1,   44,   -1,  335,  336,   -1,   -1,  377,  378,  346, 
           -1,  348,  428,  371,   -1,   61,  348,  387,  826,   -1, 
          352,  353,  354,  355,   -1,   -1,   -1,  835,   -1,  837, 
          702,  330,  402,   -1,  706,   -1,  844,   -1,  337,   -1, 
          377,   -1,   -1,  342,   -1,   91,   -1,   -1,   91,  721, 
          722,  723,   -1,  650,  545,   -1,  414,  394,  319,  358, 
          657,  658,  361,  660,  661,   -1,   -1,   -1,   -1,  406, 
          407,   -1,   -1,  410,  565,   -1,   -1,  414,   -1,   -1, 
           -1,   -1,   41,   41,  454,   44,   44,  348,  579,   -1, 
           -1,  352,  353,  354,  355,   -1,   -1,   -1,   41,  771, 
          772,   44,   61,   61,  441,  702,   -1,  444,   -1,  706, 
          447,   -1,  304,   -1,   -1,  307,  308,  309,   61,   10, 
          792,   -1,   -1,   -1,  721,  722,  723,   -1,   -1,  545, 
           -1,   41,   91,   91,   44,  505,  506,  507,  330,   -1, 
           -1,  511,   -1,  279,  280,  337,   -1,   -1,   91,  565, 
          342,   61,  522,  523,  826,  347,  348,  349,  350,  650, 
           -1,   -1,   -1,  579,   -1,  837,  657,  658,   59,  660, 
          661,   -1,  844,   -1,  771,  772,  546,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,  544,   -1,   -1,  526, 
           -1,   -1,   -1,   -1,  330,  792,   -1,   10,   -1,   -1, 
           -1,  337,   -1,   -1,   -1,   -1,  342,   -1,  578,   -1, 
          580,  702,  582,   -1,   -1,  706,   -1,   -1,   -1,   -1, 
          590,   -1,  358,   -1,   -1,  361,   -1,   -1,   -1,  826, 
          721,  722,  723,  279,  650,   -1,  279,  280,   -1,   -1, 
          837,   -1,  658,   -1,  660,  661,   59,  844,   -1,  607, 
           -1,   -1,   -1,   -1,   -1,   -1,  593,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,  611,  633,   -1,   -1,  615,   -1, 
          771,  772,  619,   -1,  330,   -1,   -1,  330,   -1,   -1, 
          706,  337,   -1,  630,  337,   -1,  342,   -1,   41,  342, 
            0,  792,   -1,   -1,   -1,  721,  722,  723,   -1,   -1, 
           10,  681,  358,   -1,   -1,  358,   59,   -1,  361,   -1, 
          279,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  826,  279,   -1,   -1,   -1, 
           -1,   41,  679,   -1,   44,   -1,  837,   -1,   -1,   -1, 
           -1,  709,  689,  844,   -1,  771,  772,   -1,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,  737,  738,  279, 
           -1,  330,  330,   -1,   -1,   -1,  792,   -1,  337,  337, 
           -1,   -1,  125,  720,   -1,   -1,   -1,  330,   -1,   -1, 
          727,   91,   -1,   93,  337,   -1,  733,   -1,  304,  358, 
          358,  307,  308,  309,   -1,   -1,   -1,   -1,   -1,   -1, 
          826,   -1,   -1,  304,   -1,  358,  307,  308,  309,   -1, 
          330,  837,   -1,    0,   -1,  125,   -1,  337,  844,  799, 
           -1,   -1,  769,   10,   -1,   -1,  342,   -1,   -1,  330, 
           -1,  347,  348,  349,  350,   -1,  337,   -1,  358,   -1, 
           -1,  342,   -1,   -1,   -1,   -1,  347,  348,  349,  350, 
           -1,  798,   -1,   -1,   41,  835,   -1,   44,   -1,   -1, 
           -1,  808,  319,   -1,   -1,  812,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   61,   -1,   63,   -1,  335,  336, 
           10,  304,   -1,  863,  307,  308,  309,   -1,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,   -1, 
          847,  358,  849,  360,   91,   -1,   93,  330,   -1,  262, 
          263,  264,   -1,   -1,  337,  268,  269,   -1,  271,  342, 
          867,   -1,  869,   -1,  347,  348,  349,  350,   -1,   -1, 
          877,   -1,   -1,   63,  881,   -1,   -1,   -1,  125,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,   -1,  293,  294,  295,  296,  297,   63,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
           -1,  311,  312,  313,  314,   -1,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   -1,   10,  335,  336,  337,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,  363,  364,  365,  366,  367,  368,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   59,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,    0,  363,  364,  365,  366, 
          367,  368,   -1,   -1,   -1,   10,   -1,   -1,   -1,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
           -1,  331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,  348,   44, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,   91,   -1,   93,   -1, 
           -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  304,   -1, 
           -1,  307,  308,  309,   -1,   -1,   -1,   -1,   41,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  330,   58,   59,   -1,   61,   -1, 
           63,  337,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,  347,  348,  349,  350,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,   -1,   -1,   91,   -1, 
           93,  335,  336,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   63,   -1,   -1, 
           -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   58,  311,  312,  313,  314, 
           63,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,  337,  338,   -1,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,   -1,  363,  364, 
          365,  366,  367,  368,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,  311,  312, 
          313,  314,   63,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,  338,   -1,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,    0, 
          363,  364,  365,  366,  367,  368,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,   -1,  331,  332,   -1,   -1,  335, 
          336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,   -1,  348,   44,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,   -1,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   93,   -1,   -1,   -1,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,    0,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  125,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  304,  305,   -1, 
           -1,  308,   41,   -1,   -1,   44,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   58, 
           59,  328,   -1,   -1,   63,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,   91,  360,   93,  362,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  125,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,  363,  364,  365,  366,  367,  368,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,  338, 
           -1,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,    0,  363,  364,  365,  366,  367,  368, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   58,   59,   -1,  265,  266,   63,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   93,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,    0,   -1,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  125,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,  343,  344,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   41,  358,   -1,   44, 
           -1,   -1,  363,  364,  365,  366,  367,  368,  304,  305, 
           -1,   -1,  308,   58,   59,   -1,   -1,   -1,   63,   -1, 
          316,  317,   -1,  319,  320,  321,  322,   -1,  324,  325, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,  338,   -1,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,  363,  364,  365,  366, 
          367,  368,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,  337,  338,   -1,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,    0,  363,  364, 
          365,  366,  367,  368,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   41,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   58,   59,  265,  266,   -1, 
           63,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           93,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,   -1,  311,  312,  313,  314,   -1,   -1,    0, 
          318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  125,   -1,   -1,   -1,   -1,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,  343,  344,  345,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,   -1,   -1,   44,   -1,  363,  364,  365,  366,  367, 
          368,  304,  305,   -1,   -1,  308,   -1,   58,   59,   -1, 
           -1,   -1,   63,  316,  317,   -1,  319,  320,  321,  322, 
           -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   93,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,  311,  312, 
          313,  314,   -1,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,  338,   -1,  340,  341,   -1, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
          363,  364,  365,  366,  367,  368,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,  340, 
          341,   -1,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,    0,  363,  364,  365,  366,  367,  368,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  304,  305,   -1,   -1,  308,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320, 
          321,  322,   41,  324,  325,   44,   -1,  328,   -1,   -1, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,  304,  305,   -1,   -1,  308, 
           -1,   -1,   91,   -1,   93,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   -1,  324,  325,   -1,   -1,  328, 
           -1,   -1,   -1,    0,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  125,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,  304, 
          305,   -1,   -1,  308,   41,   -1,   -1,   44,   -1,   -1, 
           -1,  316,  317,   -1,  319,  320,  321,  322,   -1,  324, 
          325,   58,   59,  328,   -1,   -1,   63,   -1,  333,  334, 
          335,  336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,   91,  360,   93,  362,  319,  320, 
          321,  322,  323,  324,  325,  326,   -1,  328,  329,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  125,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,  338, 
           -1,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363,  364,  365,  366,  367,  368, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          312,  313,  314,   -1,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,  337,  338,   -1,  340,  341, 
           -1,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,    0, 
           -1,  363,  364,  365,  366,  367,  368,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  304,  305,   -1,   -1,  308,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  316,  317,   -1,  319,  320,  321,  322, 
           41,  324,  325,   44,   -1,  328,   -1,   -1,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,  304,  305,   -1,   -1,  308,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,  316,  317,   -1,  319,  320, 
          321,  322,   -1,  324,  325,   -1,   -1,  328,   -1,   -1, 
           -1,    0,  333,  334,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  125,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,  304,  305,   -1, 
           -1,  308,   41,   -1,   -1,   44,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   -1, 
           59,  328,   61,   -1,   63,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,   91,  360,   -1,  362,  319,  320,  321,  322, 
          323,  324,  325,   -1,   -1,  328,  329,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  125,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,  338,   -1,   -1, 
          341,  342,  343,  344,  345,   -1,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,  363,  364,  365,  366,  367,  368,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,  338, 
           -1,   -1,  341,  342,  343,  344,  345,   -1,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,    0,  363,  364,  365,  366,  367,  368, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  304,  305,   -1,   -1,  308, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   41,  324,  325,   44,   -1,  328, 
           -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,  304,  305,   -1, 
           -1,  308,   -1,   -1,   91,   -1,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   -1, 
           -1,  328,   -1,   -1,   -1,    0,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  125,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,  304,  305,   -1,   -1,  308,   41,   -1,   -1,   44, 
           -1,   -1,   -1,  316,  317,   -1,  319,  320,  321,  322, 
           -1,  324,  325,   -1,   59,  328,   61,   -1,   63,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   91,  360,  319,  362, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
          125,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,  338,   -1,   -1,  341,  342,  343,  344,  345,   -1, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,  363,  364,  365,  366, 
          367,  368,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  331,  332,   -1,   -1, 
          335,  336,  337,  338,   -1,   -1,  341,  342,  343,  344, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,    0,   -1,  363,  364, 
          365,  366,  367,  368,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1, 
           44,   -1,   -1,    0,   -1,   -1,   -1,   -1,   41,   -1, 
           -1,   -1,   -1,   10,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,  125,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   41,  125,   -1,   91,   -1,   93,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  125,   -1,  281,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,   -1,  311,  312,  313, 
          314,   -1,  316,  317,  318,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,  330,  271,   -1,  262, 
          263,  264,   -1,  337,  338,  268,  269,  341,  271,  343, 
          344,  345,   -1,  347,   -1,  349,    0,  351,   -1,  293, 
          294,  295,  296,  297,   -1,  359,   10,   -1,   -1,  363, 
          364,  365,  366,  367,  368,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  280,  281,  282,   -1,   41,   -1,   -1, 
           44,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  331,  332,    0,   -1,  335,  336, 
          337,   -1,   -1,  340,   -1,   -1,   10,   -1,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,  361,   -1,   -1,   -1,   -1,   -1, 
           -1,  125,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  125,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   41,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   59,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   41,   -1,   -1,   44,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,  280,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,   -1,  125,  340,   -1,   -1,   -1, 
           -1,   -1,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,  361,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  281,  282,   -1, 
          268,  269,   -1,  271,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   10,   -1,   -1,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  331,  332,   -1, 
           -1,  335,  336,  337,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   -1,  346,   41,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,    0,   -1, 
           58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   41, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  125,   -1,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   -1,   -1,  335,  336,  337,   -1,   91, 
          340,   93,   -1,   -1,   -1,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,    0,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  281,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,  337,   -1,  125,  340,   -1, 
           -1,   -1,   -1,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   41,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,   -1,   91,  340, 
           93,   -1,   -1,   -1,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  125,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   41,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
           -1,   91,  340,   93,   -1,   -1,   -1,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   93,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,   -1,  125,  340,   -1,   -1, 
           -1,   -1,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   41, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   -1,   -1,  335,  336,  337,   -1,   91, 
          340,   93,   -1,   -1,   -1,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,   -1, 
           91,  340,   93,   -1,   -1,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,  337,   -1,  125,  340,   -1, 
           -1,   -1,   -1,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   41,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,   -1,   91,  340, 
           -1,   -1,   -1,   -1,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  125,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   41,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  331,  332,   -1,   -1,  335,  336,  337, 
           -1,   91,  340,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   93,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,   -1,  125,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   41, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  331,  332,   -1,   -1,  335,  336,  337,   -1,   -1, 
          340,   93,   -1,   -1,   -1,   -1,   -1,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,   -1,  331,  332,   -1,   -1,  335,  336,   -1,   -1, 
           -1,  340,   93,   -1,   -1,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   93,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,   -1,  331, 
          332,   -1,   -1,  335,  336,   -1,   -1,  125,  340,   -1, 
           -1,   -1,   -1,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   41,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,   -1, 
          331,  332,   -1,   -1,  335,  336,   -1,   -1,   -1,  340, 
           93,   -1,   -1,   -1,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  125,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   41,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,   -1,  331,  332,   -1,   -1,  335,  336,   -1, 
           -1,   -1,  340,   93,   -1,   -1,   -1,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   93,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,   -1,  331,  332, 
           -1,   -1,  335,  336,   -1,   -1,  125,  340,   -1,   -1, 
           -1,   -1,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   41, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
           -1,  331,  332,   -1,   -1,  335,  336,   -1,   -1,   91, 
          340,   -1,   -1,   -1,   -1,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,   -1,  331,  332,   -1,   -1,  335,  336,   -1,   -1, 
           91,  340,   -1,   -1,   -1,   -1,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  331, 
          332,   -1,   -1,  335,  336,  337,   -1,  339,  125,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   41,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          331,  332,   -1,   -1,  335,  336,  337,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,    0,  360, 
           -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,   10,   -1,   -1,   -1,  125,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   41,   -1,   -1,   44,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
           -1,   -1,  335,  336,  337,   93,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1, 
           44,   -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268, 
          269,   -1,  271,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,  331,  332,   -1,   -1,  335,  336,  337,   -1, 
           -1,  125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,   41,  331,  332,   44,   -1,  335,  336,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,  346,   58, 
           59,   -1,  350,   -1,   63,   -1,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   93,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,   41,  331,  332,   44, 
           -1,  335,  336,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,  346,   58,   59,   -1,  350,   -1,   63,   -1, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   93,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1,   44, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   93,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,   41,  331,  332,   44,   -1,  335,  336,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,  346,   58,   59, 
           -1,  350,   -1,   63,   -1,   -1,   -1,  356,  357,  358, 
           -1,  360,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,   -1, 
          335,  336,   -1,   -1,   -1,  340,   -1,  262,  263,  264, 
           -1,  346,  267,  268,  269,  350,  271,   -1,   -1,   -1, 
           -1,  356,  357,  358,   -1,  360,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   41,  331,  332,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,  346,   58,   59,   -1,  350,   -1,   63,   -1,   -1, 
           -1,  356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   93,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
           -1,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,  346,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  356,  357,  358,   -1, 
          360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,   -1,  331,  332,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1, 
          346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,  358,   -1,  360,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   -1,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           59,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,  338,   -1,   -1, 
          341,  342,  343,  344,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   10,  356,   -1,   -1,  359,   -1, 
          361,   -1,  363,  364,  365,  366,  367,  368,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   59,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,   -1,  311,  312,  313,  314,   -1,  316,  317, 
          318,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,  330,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
          338,   -1,   -1,  341,  342,  343,  344,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1, 
           -1,  359,   10,  361,   -1,  363,  364,  365,  366,  367, 
          368,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   -1, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   59,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  330,   -1,   -1,   -1,   -1,   -1,   -1,  337,  338, 
           -1,   -1,  341,  342,  343,  344,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   10,   -1,  356,   -1,   -1, 
          359,   -1,  361,   -1,  363,  364,  365,  366,  367,  368, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,   -1,  269,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   59,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,  305, 
          306,  307,  308,  309,   -1,  311,  312,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,  338,   -1,   -1,  341,  342,  343,  344,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
          356,   -1,   -1,  359,   10,   -1,   -1,  363,  364,  365, 
          366,  367,  368,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   59,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,   -1,  311,  312,  313,  314,   -1,  316,  317, 
          318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  330,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
          338,   -1,   -1,  341,   -1,  343,  344,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   10,  356,   -1, 
           -1,  359,   -1,   -1,   -1,  363,  364,  365,  366,  367, 
          368,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   59,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,  125,   -1,  359,   10,   -1,   -1,  363,  364, 
          365,  366,  367,  368,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,  264,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   59,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,  305, 
          306,  307,  308,  309,   -1,  311,  312,  313,  314,   -1, 
          316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,  363,  364,  365, 
          366,  367,  368,  256,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,  311,  312, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,    0,   -1,  341,   -1, 
          343,  344,  345,   -1,  347,   -1,   10,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
          363,  364,  365,  366,  367,  368,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   41,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   58,   59,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,    0,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   10,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1,   44, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,  125,   -1,   58,   59,   -1,  351,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,  363,  364, 
          365,  366,  367,  368,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   93,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,    0,   44, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   41, 
           -1,   -1,   44,   -1,   -1,   10,   -1,   -1,   93,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   41,  271,   -1,   44, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,  281,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  290,  291,   63,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,   93,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
          125,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,  262,  263,  264, 
           -1,  346,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,  356,  357,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,    0,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   10,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,  290,  291, 
           -1,  293,  294,  295,  296,  340,   -1,  262,  263,  264, 
           -1,  346,  267,  268,  269,   41,  271,   -1,   -1,   -1, 
            0,  356,  357,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           10,   -1,   58,   59,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   41,   -1,   -1,   44,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,   -1,  331,  332,   58,   59, 
           -1,   -1,   -1,   63,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125, 
            0,  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   41,   -1,   -1,   44,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   -1,   41,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   10,  271,   -1,   93,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   41,   -1,   -1,   44,  125, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
           -1,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,  125, 
          340,   -1,  262,  263,  264,   -1,  346,  267,  268,  269, 
            0,  271,   -1,   -1,   -1,   -1,  356,  357,   -1,   -1, 
           10,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   41,   -1,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,    0,  271,  326,  327,   58,   59, 
           -1,  331,  332,   63,   10,  281,  282,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,  290,  291,  346,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   -1,   41,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
          326,  327,   58,   59,   -1,  331,  332,   63,   10,   -1, 
           -1,   -1,   -1,   -1,  340,  125,  262,  263,  264,   -1, 
          346,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   93,   -1,   41, 
           -1,   -1,   44,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,    0,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   10,   -1,   -1,   -1,   -1,   -1,   -1,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,   -1,   -1,   -1, 
           -1,   93,   -1,   41,  340,   -1,   44,   -1,   -1,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   93,   -1,   41,   -1,   -1, 
           44,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
            0,  271,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           10,  281,  282,   -1,   -1,   -1,   -1,  125,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   41,   -1,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,    0,  271,  326,  327,   58,   59, 
           -1,  331,  332,   63,   10,  281,  282,   -1,   -1,   -1, 
          340,  125,   -1,   -1,  290,  291,  346,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   -1,   41,   -1,   -1,   44,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,    0,  271, 
          326,  327,   58,   59,   -1,  331,  332,   63,   10,  281, 
          282,   -1,   -1,   -1,  340,  125,   -1,   -1,  290,  291, 
          346,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1,   41, 
           -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,    0,  271,  326,  327,   58,   59,   -1,  331, 
          332,   -1,   10,  281,  282,   -1,   -1,   -1,  340,  125, 
           -1,   -1,  290,  291,  346,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   93,   -1,   41,   -1,   -1,   44,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,    0,  271,  326,  327, 
           58,   59,   -1,  331,  332,   -1,   10,  281,  282,   -1, 
           -1,   -1,  340,  125,   -1,   -1,  290,  291,  346,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   93,   -1,   41,   -1,   -1, 
           44,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
            0,  271,   -1,  327,   58,   59,   -1,  331,  332,   -1, 
           10,  281,  282,   -1,   -1,   -1,  340,  125,   -1,   -1, 
          290,  291,  346,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   41,   -1,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,    0,  271,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   10,  281,  282,   -1,   -1,   -1, 
          340,  125,   -1,   -1,  290,  291,  346,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   -1,   41,   -1,   -1,   44,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,    0,  271, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   10,  281, 
          282,   -1,   -1,   -1,  340,  125,   -1,   -1,  290,  291, 
          346,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1,   41, 
           -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,    0,  271,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   10,  281,  282,   -1,   -1,   -1,  340,  125, 
           -1,   -1,  290,  291,  346,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   93,   -1,   41,   -1,   -1,   44,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,    0,  271,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   -1,   10,  281,  282,   -1, 
           -1,   -1,  340,  125,   -1,   -1,  290,  291,  346,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   93,   -1,   41,   -1,   -1, 
           44,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
            0,  271,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           10,  281,  282,   -1,   -1,   -1,  340,  125,   -1,   -1, 
          290,  291,  346,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   41,   -1,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,    0,  271,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   10,  281,  282,   -1,   -1,   -1, 
          340,  125,   -1,   -1,  290,  291,  346,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   -1,   41,   -1,   -1,   44,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,    0,  271, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   10,  281, 
          282,   -1,   -1,   -1,  340,  125,   -1,   -1,  290,  291, 
          346,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1,   41, 
           -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,    0,  271,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   10,  281,  282,   -1,   -1,   -1,  340,  125, 
           -1,   -1,  290,  291,  346,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   93,   -1,   41,   -1,   -1,   44,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,    0,  271,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   -1,   10,  281,  282,   -1, 
           -1,   -1,  340,  125,   -1,   -1,  290,  291,  346,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   93,   -1,   41,   -1,   -1, 
           44,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
            0,  271,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           10,  281,  282,   -1,   -1,   -1,  340,  125,   -1,   -1, 
          290,  291,  346,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   41,   -1,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,    0,  271,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   10,  281,  282,   -1,   -1,   -1, 
          340,  125,   -1,   -1,  290,  291,  346,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   -1,   41,   -1,   -1,   44,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,    0,  271, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   10,  281, 
          282,   -1,   -1,   -1,  340,  125,   -1,   -1,  290,  291, 
          346,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1,   41, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,  340,  125, 
           -1,   -1,  290,  291,  346,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   41,   -1,   -1,   -1,   -1,   -1, 
           -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,  340,  125,   -1,   -1,  290,  291,  346,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,  346,  293,  294,  295,  296,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   59,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,  290,  291,  346,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
          346,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,    0,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   10,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,  346,  302,  303,  304,  305,  306, 
          307,  308,  309,   41,  311,  312,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,  343,  344,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   93,  363,  364,  365,  366, 
          367,  368,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,    0,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   10,   -1,   -1,  125,  283,  284, 
          285,  286,  287,  288,  289,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,   41, 
          311,  312,  313,  314,    0,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,  343,  344,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   41,   -1,   -1,  359,   -1, 
           -1,   93,  363,  364,  365,  366,  367,  368,   -1,   -1, 
            0,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1,   -1, 
           -1,   41,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   58,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,   -1, 
           -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,  338,   -1,   -1,  341,   -1,  343,  344,  345,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  363,  364,  365,  366, 
          367,  368,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  293,  294,  295,  296,  297,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,   -1,  311,  312,  313,  314,   -1,  316,  317, 
          318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,  343,  344,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,  363,  364,  365,  366,  367, 
          368,  256,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,  363,  364, 
          365,  366,  367,  368,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,  311,  312, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
          343,  344,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
          363,  364,  365,  366,  367,  368,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,  343,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,  363,  364,  365,  366,  367,  368,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,  343,  344,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,  363,  364,  365,  366,  367,  368, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,  343,  344,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,  363,  364,  365,  366, 
          367,  368,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,  363,  364, 
          365,  366,  367,  368,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,  311,  312, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
          343,  344,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
          363,  364,  365,  366,  367,  368,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,  343,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,  363,  364,  365,  366,  367,  368,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,  343,  344,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,  363,  364,  365,  366,  367,  368, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,  343,  344,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,  363,  364,  365,  366, 
          367,  368,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,  363,  364, 
          365,  366,  367,  368,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,  311,  312, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
          343,  344,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
          363,  364,  365,  366,  367,  368,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,  343,  344,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,  363,  364,  365,  366,  367,  368,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,  343,  344,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,  363,  364,  365,  366,  367,  368, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,  343,  344,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,  363,  364,  365,  366, 
          367,  368,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,  363,  364, 
          365,  366,  367,  368,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,  311,  312, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
          343,  344,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
          363,  364,  365,  366,  367,  368,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,  343,  344,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,  363,  364,  365,  366,  367,  368,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,  343,  344,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,  363,  364,  365,  366,  367,  368, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,  343,  344,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,  363,  364,  365,  366, 
          367,  368,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,  363,  364, 
          365,  366,  367,  368,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,  311,  312, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
          343,  344,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
          363,  364,  365,  366,  367,  368,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,  316,  317,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,  343,  344,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,  363,  364,  365,  366,  367,  368,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,  316,  317,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,  342,  343,  344,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,  363,  364,  365,  366,  367,  368, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,  316, 
          317,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,  343,  344,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,  363,  364,  365,  366, 
          367,  368,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,  316,  317,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,  363,  364, 
          365,  366,  367,  368,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,  311,  312, 
          313,  314,   -1,  316,  317,  318,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
          343,  344,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
          363,  364,  365,  366,  367,  368,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,   -1, 
          311,  312,  313,  314,   -1,   -1,   -1,  318,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,  343,  344,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  363,  364,  365,  366,  367,  368,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,  311,  312,  313,  314,   -1,   -1,   -1,  318, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,  343,  344,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  363,  364,  365,  366,  367,  368, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,   -1,  311,  312,  313,  314,   -1,   -1, 
           -1,  318,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,  343,  344,  345,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  363,  364,  365,  366, 
          367,  368,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,   -1,  311,  312,  313,  314, 
           -1,   -1,   -1,  318,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,  343,  344, 
          345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,  364, 
          365,  366,  367,  368,  257,  258,  259,  260,  261,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  270,  271,   -1, 
           -1,  274,  275,  276,  277,  278,  279,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,   -1,  308,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  316,  317,   -1,  319,  320,  321,  322, 
           -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
          363,  257,  258,  259,  260,  261,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  270,  271,   -1,   -1,  274,  275, 
          276,  277,  278,  279,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,  299,  300,  301,  302,  303,  304,  305, 
           -1,   -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          316,  317,   -1,  319,  320,  321,  322,   -1,  324,  325, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,  363,  257,  258, 
          259,  260,  261,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  270,  271,   -1,   -1,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,  305,  306,  307,  308, 
          309,   -1,   -1,   -1,   -1,   -1,   -1,  316,  317,   -1, 
          319,  320,  321,  322,   -1,  324,  325,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,  257,  258,  259,  260,  261,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  270,  271,   -1, 
           -1,  274,  275,  276,  277,  278,  279,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,  299,  300,  301,  302, 
          303,  304,  305,  306,  307,  308,  309,   -1,   -1,   -1, 
           -1,   -1,   -1,  316,  317,   -1,  319,  320,  321,  322, 
           -1,  324,  325,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,  305,   -1, 
           -1,  308,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316, 
          317,   -1,  319,  320,  321,  322,   -1,  324,  325,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362, 
      };
   }

}
