/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.wizards;

import java.io.File;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.rdb.connection.internal.ui.RDBConnectionUIPlugin;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.connection.internal.ui.icons.ImageDescription;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.server.internal.ui.wizards.NewConnectionJDBCConfigurationWizardPage;
import org.eclipse.wst.rdb.server.internal.ui.wizards.NewConnectionSchemaFilterWizardPage;

public class NewConnectionWizard
extends Wizard {
    private static final ResourceLoader resource = ResourceLoader.INSTANCE;
    public static final int ALIAS_CONNECTION_TYPE = 1;
    public static final int JDBC_CONNECTION_TYPE = 2;
    public static final int JNDI_CONNECTION_TYPE = 3;
    public static final int DEFAULT_OPTIONS = 0;
    public static final int SHOW_EXISTING_CONS = 1;
    public static final int DISABLE_DB = 2;
    public static final int DISABLE_CURRENT_USERID_PWD = 4;
    public static final int DISABLE_VENDOR_TYPE = 8;
    public static final int DISABLE_DRIVER = 16;
    public static final int SELECT_EXISTING = 32;
    public static final int SHOW_JNDI_DATASOURCES = 64;
    public static final int SHOW_ADD_ALIASES = 128;
    public static final int SHOW_COMBINED_FILTERS = 256;
    public static final int SHOW_CALLING_PAGE = 512;
    public static final String STORE_USE_OS_UID_PWD = "NewConnectionWizard.STORE_USE_OS_UID_PWD";
    public static final String STORE_USERIDS = "NewConnectionWizard.STORE_USERIDS";
    public static final String CONNECTION_NULL = resource.queryString("DATATOOLS.SERVER.UI.EXPLORER.NULL_CONNECTION");
    public static final String CONNECTION_EXCEPTION = resource.queryString("DATATOOLS.SERVER.UI.EXPLORER.CONNECTION_EXCEPTION");
    private static final String CONFIGURE_JDBC_WIZARD_PAGE_NAME = "org.eclipse.wst.rdb.server.internal.ui.wizards.JdbcPage";
    private static final String SCHEMA_FILTER_WIZARD_PAGE_NAME = "org.eclipse.wst.rdb.server.internal.ui.wizards.SchemaFilterPage";
    private List existingConnectionNameList;
    private IWorkbench iWorkbench;
    private IStructuredSelection iSelection;
    private NewConnectionJDBCConfigurationWizardPage jdbcPage;
    private NewConnectionSchemaFilterWizardPage schemaFilterPage;
    private ConnectionInfo connection;
    private DatabaseDefinition definition;
    private boolean enableLogging;
    private static int OPTIONS = 0;
    public static String[] fExtensions = new String[]{"*.jar;*.zip", "*.*"};
    private static String FILE_SEPARATOR = ";";

    public NewConnectionWizard() {
        this.setWindowTitle(resource.queryString("_UI_DIALOG_CONNECTION_TITLE"));
        this.setNeedsProgressMonitor(true);
        this.enableLogging = false;
        OPTIONS = 0;
        this.wizardInit();
    }

    public NewConnectionWizard(int OPTIONS) {
        this();
        NewConnectionWizard.OPTIONS = OPTIONS;
    }

    public NewConnectionWizard(DatabaseDefinition object, boolean loadMetadata) {
        this(object, loadMetadata, 0);
    }

    public NewConnectionWizard(DatabaseDefinition object, boolean loadMetaData, int OPTIONS) {
        this();
        this.definition = object;
        this.enableLogging = false;
        NewConnectionWizard.OPTIONS = OPTIONS;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public void setExistingConnectionNames(List existingConnectionNamesList) {
        this.existingConnectionNameList = existingConnectionNamesList;
    }

    private void wizardInit() {
        IDialogSettings workbenchSettings = RDBConnectionUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewConnectionWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewConnectionWizard");
        }
        this.setDialogSettings(section);
    }

    public static RSCCoreUIWidgetFactory getUIFactory() {
        return RSCCoreUIWidgetFactory.INSTANCE;
    }

    public void addPages() {
        super.addPages();
        this.jdbcPage = new NewConnectionJDBCConfigurationWizardPage(CONFIGURE_JDBC_WIZARD_PAGE_NAME, OPTIONS, this.existingConnectionNameList);
        this.addPage((IWizardPage)this.jdbcPage);
        this.jdbcPage.setDefaultDatabaseDefinition(this.definition);
        this.schemaFilterPage = new NewConnectionSchemaFilterWizardPage(SCHEMA_FILTER_WIZARD_PAGE_NAME);
        this.addPage((IWizardPage)this.schemaFilterPage);
    }

    public boolean canFinish() {
        boolean canFinish = false;
        if (this.jdbcPage.isPageComplete() && this.schemaFilterPage.isPageComplete()) {
            canFinish = true;
        }
        return canFinish;
    }

    public boolean performFinish() {
        boolean isPerformFinishSuccessful = false;
        if (this.getDBConnection(true) != null) {
            this.schemaFilterPage.applyFilter();
            ((ICatalogObject)this.connection.getSharedDatabase()).refresh();
            isPerformFinishSuccessful = true;
        }
        return isPerformFinishSuccessful;
    }

    public boolean performCancel() {
        boolean isPerformCancelSuccessful = true;
        if (this.connection != null) {
            RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(this.connection.getName());
        }
        return isPerformCancelSuccessful;
    }

    public ConnectionInfo getDBConnection(boolean showServerMismatchWarning) {
        if (this.connection == null) {
            this.internalSaveWidgetValues();
            this.jdbcPage.performTestConnection(false, showServerMismatchWarning);
            if (this.jdbcPage.isFinalConnection()) {
                this.connection = this.jdbcPage.getConnection();
            }
            if (this.jdbcPage.isFinalConnection()) {
                this.displayNewServer(this.getConnection());
            }
        }
        return this.connection;
    }

    protected void internalSaveWidgetValues() {
        this.jdbcPage.internalSaveWidgetValues();
    }

    public ConnectionInfo getConnection() {
        return this.connection;
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.init(aWorkbench, aSelection, false);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection, boolean edit) {
        this.setDefaultPageImageDescriptor(ImageDescription.getDescriptor((String)"NewConnectionWiz.gif"));
    }

    public static String getFile(Wizard wizard, String[] fExtensions) {
        StringBuffer result = new StringBuffer();
        FileDialog dialog = new FileDialog(wizard.getShell(), 2);
        if (fExtensions != null) {
            dialog.setFilterExtensions(fExtensions);
        }
        dialog.open();
        String path = dialog.getFilterPath();
        String[] files = dialog.getFileNames();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (result.length() > 0) {
                    result.append(FILE_SEPARATOR);
                }
                result.append(path).append(File.separator).append(files[i]);
                ++i;
            }
        }
        return result.toString();
    }

    public static String getDirectory(Wizard wizard, String current, String message) {
        DirectoryDialog dialog = new DirectoryDialog(wizard.getShell(), 4);
        dialog.setMessage(message);
        dialog.setFilterPath(current);
        return dialog.open();
    }

    private boolean getLogging() {
        return this.enableLogging;
    }

    private void setLogging(boolean enableLogging) {
        this.enableLogging = enableLogging;
    }

    public int getConnectionType() {
        return 2;
    }

    protected void setConnectionDetails(ConnectionInfo connection) {
        if (connection == null) {
            return;
        }
        this.jdbcPage.setConnectionDetails(connection);
    }

    public static String getMessages(Throwable e) {
        StringBuffer eb = new StringBuffer();
        Throwable t = e;
        if (t.getLocalizedMessage() != null) {
            eb.append(t.getLocalizedMessage());
        } else {
            eb.append(t.getClass().getName());
        }
        while (t.getCause() != null) {
            t = t.getCause();
            eb.append("; ");
            if (t.getLocalizedMessage() != null) {
                eb.append(t.getLocalizedMessage());
                continue;
            }
            eb.append(t.getClass().getName());
        }
        return eb.toString();
    }

    private boolean displayNewServer(ConnectionInfo connectionInfo) {
        Connection connection = null;
        try {
            connection = connectionInfo.connect();
            connectionInfo.setSharedConnection(connection);
            connectionInfo.saveConnectionInfo();
            new DatabaseProviderHelper().setDatabase(connection, connectionInfo, connectionInfo.getDatabaseName());
            return true;
        }
        catch (Exception e) {
            RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(connectionInfo.getName());
            this.displayError(e.getMessage());
            return false;
        }
    }

    private void displayError(String message) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)CONNECTION_NULL, (String)MessageFormat.format(CONNECTION_EXCEPTION, message));
    }

    public IWizardPage getNextPage(IWizardPage wizardPage) {
        Object nextPage = null;
        nextPage = wizardPage.getName().equals(CONFIGURE_JDBC_WIZARD_PAGE_NAME) ? this.schemaFilterPage : (wizardPage.getName().equals(SCHEMA_FILTER_WIZARD_PAGE_NAME) ? null : super.getNextPage(wizardPage));
        return nextPage;
    }
}

