/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.internet.monitor.core.internal.MonitorManager;
import org.eclipse.wst.internet.monitor.core.internal.http.ResendHTTPRequest;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;

public class MonitorTreeContentProvider
implements ITreeContentProvider {
    protected static final String ROOT = "root";
    protected boolean sortByResponseTime;

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof Integer) {
            Integer in = (Integer)element;
            ArrayList<Request> list = new ArrayList<Request>();
            Request[] requests = MonitorUIPlugin.getInstance().getRequests();
            if (requests != null) {
                int size = requests.length;
                int i = 0;
                while (i < size) {
                    Request req = requests[i];
                    if (req.getLocalPort() == in.intValue() && !(req instanceof ResendHTTPRequest)) {
                        list.add(req);
                    }
                    ++i;
                }
            }
            if (this.sortByResponseTime) {
                this.sortByResponseTime(list);
            }
            return list.toArray();
        }
        if (element instanceof Request) {
            Request req = (Request)element;
            ResendHTTPRequest[] rr = MonitorManager.getInstance().getResendRequests(req);
            ArrayList<ResendHTTPRequest> list = new ArrayList<ResendHTTPRequest>();
            if (rr != null) {
                int size = rr.length;
                int i = 0;
                while (i < size) {
                    list.add(rr[i]);
                    ++i;
                }
            }
            if (this.sortByResponseTime) {
                this.sortByResponseTime(list);
            }
            return list.toArray();
        }
        return null;
    }

    public Object[] getElements(Object element) {
        if (ROOT.equals(element)) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            Request[] requests = MonitorUIPlugin.getInstance().getRequests();
            if (requests != null) {
                int size = requests.length;
                int i = 0;
                while (i < size) {
                    Request req = requests[i];
                    Integer in = new Integer(req.getLocalPort());
                    if (!list.contains(in)) {
                        list.add(in);
                    }
                    ++i;
                }
            }
            if (this.sortByResponseTime) {
                this.sortByResponseTime(list);
            }
            return list.toArray();
        }
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element != null) {
            ResendHTTPRequest callResend;
            Request parent;
            if (element instanceof Integer) {
                return ROOT;
            }
            Request call = (Request)element;
            if (call instanceof ResendHTTPRequest && (parent = (callResend = (ResendHTTPRequest)call).getOriginalRequest()) != null) {
                return parent;
            }
            return new Integer(call.getLocalPort());
        }
        return null;
    }

    public boolean getSortByResponseTime() {
        return this.sortByResponseTime;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Integer) {
            return true;
        }
        if (element instanceof Request) {
            return MonitorManager.getInstance().getResendRequests((Request)element).length > 0;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setSortByResponseTime(boolean b) {
        this.sortByResponseTime = b;
    }

    protected void sortByResponseTime(List list) {
        int size = list.size();
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                Request c1 = (Request)list.get(i);
                Request c2 = (Request)list.get(j);
                if (c1.getResponseTime() < c2.getResponseTime()) {
                    list.set(i, c2);
                    list.set(j, c1);
                }
                ++j;
            }
            ++i;
        }
    }
}

