//@line 39 "/usr/obj/i386/firefox-5.0/mozilla-release/browser/base/content/aboutDialog.js"

// Services = object with smart getters for common XPCOM services
Components.utils.import("resource://gre/modules/Services.jsm");

function init(aEvent)
{
  if (aEvent.target != document)
    return;

  try {
    var distroId = Services.prefs.getCharPref("distribution.id");
    if (distroId) {
      var distroVersion = Services.prefs.getCharPref("distribution.version");
      var distroAbout = Services.prefs.getComplexValue("distribution.about",
        Components.interfaces.nsISupportsString);

      var distroField = document.getElementById("distribution");
      distroField.value = distroAbout;
      distroField.style.display = "block";

      var distroIdField = document.getElementById("distributionId");
      distroIdField.value = distroId + " - " + distroVersion;
      distroIdField.style.display = "block";
    }
  }
  catch (e) {
    // Pref is unset
  }

  // Include the build ID if this is an "a#" (nightly or aurora) build
  let version = Services.appinfo.version;
  if (/a\d+$/.test(version)) {
    let buildID = Services.appinfo.appBuildID;
    let buildDate = buildID.slice(0,4) + "-" + buildID.slice(4,6) + "-" + buildID.slice(6,8);
    document.getElementById("version").value += " (" + buildDate + ")";
  }

//@line 77 "/usr/obj/i386/firefox-5.0/mozilla-release/browser/base/content/aboutDialog.js"
  // Hide the Charlton trademark attribution for non-en-US/en-GB
  // DO NOT REMOVE without consulting people involved with bug 616193
  let chromeRegistry = Components.classes["@mozilla.org/chrome/chrome-registry;1"].
                       getService(Components.interfaces.nsIXULChromeRegistry);
  let currentLocale = chromeRegistry.getSelectedLocale("global");
  if (currentLocale != "en-US" && currentLocale != "en-GB") {
    document.getElementById("extra-trademark").hidden = true;
  }
//@line 86 "/usr/obj/i386/firefox-5.0/mozilla-release/browser/base/content/aboutDialog.js"

//@line 90 "/usr/obj/i386/firefox-5.0/mozilla-release/browser/base/content/aboutDialog.js"

  gChannelSelector.init();

//@line 98 "/usr/obj/i386/firefox-5.0/mozilla-release/browser/base/content/aboutDialog.js"
}

//@line 576 "/usr/obj/i386/firefox-5.0/mozilla-release/browser/base/content/aboutDialog.js"

var gChannelSelector = {
  // Disable this UI entirely for now by not including any valid channels
  validChannels: {},
  
  init: function() {
    try {
      this.channelValue = Services.prefs.getCharPref("app.update.desiredChannel");
    } catch (e) {
      let defaults = Services.prefs.getDefaultBranch("");
      this.channelValue = defaults.getCharPref("app.update.channel");
    }

    // Only show channel selector UI on valid update channels.
    if (this.channelValue in this.validChannels) {
      document.getElementById("currentChannelText").hidden = false;
      this.setChannelLabel(this.channelValue);
      this.setChannelMenuitem(this.channelValue);
    }
  },

  selectChannel: function(aSelectedItem) {
    document.getElementById("channelDescriptionDeck").selectedPanel =
      document.getElementById(aSelectedItem.value + "Description");
  },

  cancel: function() {
    this.setChannelMenuitem(this.channelValue);
    this.hide();
  },

  apply: function() {
    this.channelValue = document.getElementById("channelMenulist").selectedItem.value;
    this.setChannelLabel(this.channelValue);

    // Change app update channel.
    Services.prefs.setCharPref("app.update.desiredChannel", this.channelValue);

    // Stop any downloads in progress
    gAppUpdater.aus.pauseDownload();
    // App updater will look at app.update.desiredChannel for new channel value
    // and will clear it when the update is complete.
    gAppUpdater.isChecking = true;
    gAppUpdater.checker.checkForUpdates(gAppUpdater.updateCheckListener, true);

    this.hide();
  },

  show: function() {
    document.getElementById("contentDeck").selectedPanel =
      document.getElementById("channelSelector");
  },

  hide: function() {
    document.getElementById("contentDeck").selectedPanel =
      document.getElementById("detailsBox");  
  },

  setChannelLabel: function(aValue) {
    let channelLabel = document.getElementById("currentChannel");
    channelLabel.value = document.getElementById(aValue + "Menuitem").label;
  },

  setChannelMenuitem: function(aValue) {
    document.getElementById("channelMenulist").selectedItem =
      document.getElementById(aValue + "Menuitem");
  }
}
