/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.core;

import gnu.gcj.Core;
import gnu.gcj.RawData;
import java.io.InputStream;

public class CoreInputStream
extends InputStream {
    protected RawData ptr;
    protected int pos;
    protected int mark;
    protected int count;

    private native int unsafeGetByte(long var1);

    private native int copyIntoByteArray(byte[] var1, int var2, int var3);

    public CoreInputStream(Core core) {
        this.ptr = core.ptr;
        this.count = core.length;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public synchronized void mark(int n) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() {
        if (this.pos < this.count) {
            return this.unsafeGetByte(this.pos++) & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        int n3 = Math.min(this.count - this.pos, n2);
        this.copyIntoByteArray(byArray, n, n3);
        this.pos += n3;
        return n3;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public synchronized long skip(long l) {
        long l2 = Math.min((long)(this.count - this.pos), l < 0L ? 0L : l);
        this.pos += (int)l2;
        return l2;
    }
}

