/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;

public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private Vector contents;
    private Vector directories;
    private Vector files;
    private int listingMode;
    private JFileChooser filechooser;
    private DirectoryLoadThread loadThread;
    private Comparator comparator;

    private /* synthetic */ void finit$() {
        this.comparator = new Comparator(this){
            private /* synthetic */ BasicDirectoryModel this$0;
            {
                this.this$0 = basicDirectoryModel;
            }

            public int compare(Object object, Object object2) {
                if (this.this$0.lt((File)object, (File)object2)) {
                    return -1;
                }
                return 1;
            }
        };
    }

    static /* synthetic */ JFileChooser access$16(BasicDirectoryModel basicDirectoryModel, JFileChooser jFileChooser) {
        basicDirectoryModel.filechooser = jFileChooser;
        return basicDirectoryModel.filechooser;
    }

    static /* synthetic */ Vector access$14(BasicDirectoryModel basicDirectoryModel) {
        return basicDirectoryModel.directories;
    }

    static /* synthetic */ Vector access$13(BasicDirectoryModel basicDirectoryModel) {
        return basicDirectoryModel.files;
    }

    static /* synthetic */ Vector access$12(BasicDirectoryModel basicDirectoryModel, Vector vector) {
        basicDirectoryModel.contents = vector;
        return basicDirectoryModel.contents;
    }

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.finit$();
        this.filechooser = jFileChooser;
        jFileChooser.addPropertyChangeListener(this);
        this.listingMode = jFileChooser.getFileSelectionMode();
        this.contents = new Vector();
        this.validateFileCache();
    }

    public boolean contains(Object object) {
        return this.contents.contains(object);
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public Vector getDirectories() {
        Vector vector = this.contents;
        synchronized (vector) {
            try {
                Vector vector2 = this.directories;
                if (vector2 == null) {
                    this.getFiles();
                    vector2 = this.directories;
                }
                Vector vector3 = vector2;
                Object var4_4 = null;
                return vector3;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public Object getElementAt(int n) {
        if (n > this.getSize() - 1) {
            return null;
        }
        return this.contents.elementAt(n);
    }

    public Vector getFiles() {
        Vector vector = this.contents;
        synchronized (vector) {
            try {
                Iterator iterator;
                Vector vector2;
                Vector vector3 = this.files;
                if (vector3 == null) {
                    vector3 = new Vector();
                    vector2 = new Vector();
                    iterator = this.contents.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        if (this.filechooser.isTraversable(file)) {
                            vector2.add(file);
                            continue;
                        }
                        vector3.add(file);
                    }
                    this.files = vector3;
                    this.directories = vector2;
                }
                vector2 = vector3;
                iterator = null;
                return vector2;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public int getSize() {
        return this.contents.size();
    }

    public int indexOf(Object object) {
        return this.contents.indexOf(object);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void invalidateFileCache() {
    }

    protected boolean lt(File file, File file2) {
        boolean bl;
        boolean bl2 = this.filechooser.isTraversable(file);
        if (bl2 == (bl = this.filechooser.isTraversable(file2))) {
            String string;
            String string2 = file.getName().toLowerCase();
            return string2.compareTo(string = file2.getName().toLowerCase()) < 0;
        }
        return bl2;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("directoryChanged") || string.equals("fileFilterChanged") || string.equals("FileHidingChanged") || string.equals("fileSelectionChanged") || string.equals("fileViewChanged")) {
            this.validateFileCache();
        }
    }

    public boolean renameFile(File file, File file2) {
        return file.renameTo(file2);
    }

    protected void sort(Vector vector) {
        Collections.sort(vector, this.comparator);
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file != null) {
            if (this.loadThread != null) {
                this.loadThread.interrupt();
                this.loadThread.cancelPending();
            }
            this.loadThread = new DirectoryLoadThread(this, file);
            this.loadThread.start();
        }
    }

    private class DirectoryLoadThread
    extends Thread {
        private /* synthetic */ BasicDirectoryModel this$0;
        File directory;
        private UpdateSwingRequest pending;

        static /* synthetic */ BasicDirectoryModel access$15(DirectoryLoadThread directoryLoadThread, BasicDirectoryModel basicDirectoryModel) {
            directoryLoadThread.this$0 = basicDirectoryModel;
            return directoryLoadThread.this$0;
        }

        static BasicDirectoryModel access$0(DirectoryLoadThread directoryLoadThread) {
            return directoryLoadThread.this$0;
        }

        DirectoryLoadThread(BasicDirectoryModel basicDirectoryModel, File file) {
            this.this$0 = basicDirectoryModel;
            super("Basic L&F directory loader");
            this.directory = file;
        }

        public void run() {
            int n;
            int n2;
            FileSystemView fileSystemView = this.this$0.filechooser.getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.directory, this.this$0.filechooser.isFileHidingEnabled());
            if (this.isInterrupted()) {
                return;
            }
            Vector vector = new Vector();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!this.this$0.filechooser.accept(fileArray[i])) continue;
                vector.add(fileArray[i]);
            }
            if (this.isInterrupted()) {
                return;
            }
            this.this$0.sort(vector);
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            Object object = vector.iterator();
            while (object.hasNext()) {
                File file = (File)object.next();
                n2 = this.this$0.filechooser.isTraversable(file);
                if (n2 != 0) {
                    vector3.add(file);
                } else if (n2 == 0 && this.this$0.filechooser.isFileSelectionEnabled()) {
                    vector2.add(file);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
            object = new Vector(vector3);
            ((Vector)object).addAll(vector2);
            int n3 = ((Vector)object).size();
            n2 = this.this$0.contents.size();
            if (n3 < n2) {
                n = -1;
                int n4 = -1;
                boolean bl = false;
                for (int i = 0; i < n3 && !bl; ++i) {
                    if (((Vector)object).get(i).equals(this.this$0.contents.get(i))) continue;
                    n = i;
                    n4 = i + n2 - n3;
                    bl = true;
                }
                if (n >= 0 && n4 > n && this.this$0.contents.subList(n4, n2).equals(((Vector)object).subList(n, n3))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    Vector vector4 = new Vector(this.this$0.contents.subList(n, n4));
                    UpdateSwingRequest updateSwingRequest = new UpdateSwingRequest(this, null, 0, vector4, n);
                    this.invokeLater(updateSwingRequest);
                    object = null;
                }
            } else if (n3 > n2) {
                n = n2;
                int n5 = n3;
                boolean bl = false;
                for (int i = 0; i < n2 && !bl; ++i) {
                    if (((Vector)object).get(i).equals(this.this$0.contents.get(i))) continue;
                    n = i;
                    boolean bl2 = false;
                    for (int j = i; j < n3 && !bl2; ++j) {
                        if (!((Vector)object).get(j).equals(this.this$0.contents.get(i))) continue;
                        n5 = j;
                        bl2 = true;
                    }
                    n5 = i + n2 - n3;
                }
                if (n >= 0 && n5 > n && ((Vector)object).subList(n5, n3).equals(this.this$0.contents.subList(n, n2))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    List list2 = ((Vector)object).subList(n, n5);
                    UpdateSwingRequest updateSwingRequest = new UpdateSwingRequest(this, list2, n, null, 0);
                    this.invokeLater(updateSwingRequest);
                    object = null;
                }
            }
            if (object != null && !this.this$0.contents.equals(object)) {
                if (this.isInterrupted()) {
                    return;
                }
                UpdateSwingRequest updateSwingRequest = new UpdateSwingRequest(this, (List)object, 0, this.this$0.contents, 0);
                this.invokeLater(updateSwingRequest);
            }
        }

        private void invokeLater(UpdateSwingRequest updateSwingRequest) {
            this.pending = updateSwingRequest;
            SwingUtilities.invokeLater(updateSwingRequest);
        }

        void cancelPending() {
            if (this.pending != null) {
                this.pending.cancel();
            }
        }

        private class UpdateSwingRequest
        implements Runnable {
            private /* synthetic */ DirectoryLoadThread this$1;
            private List added;
            private int addIndex;
            private List removed;
            private int removeIndex;
            private boolean cancel;

            UpdateSwingRequest(DirectoryLoadThread directoryLoadThread, List list2, int n, List list3, int n2) {
                this.this$1 = directoryLoadThread;
                this.added = list2;
                this.addIndex = n;
                this.removed = list3;
                this.removeIndex = n2;
                this.cancel = false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if (this.cancel) return;
                int n = this.removed == null ? 0 : this.removed.size();
                int n2 = this.added == null ? 0 : this.added.size();
                Vector vector = DirectoryLoadThread.access$0(this.this$1).contents;
                synchronized (vector) {
                    try {
                        if (n > 0) {
                            DirectoryLoadThread.access$0(this.this$1).contents.removeAll(this.removed);
                        }
                        if (n2 > 0) {
                            DirectoryLoadThread.access$0(this.this$1).contents.addAll(this.added);
                        }
                        DirectoryLoadThread.access$0(this.this$1).files = null;
                        DirectoryLoadThread.access$0(this.this$1).directories = null;
                    }
                    finally {
                        Object var4_4 = null;
                    }
                    if (n > 0 && n2 == 0) {
                        this.this$1.this$0.fireIntervalRemoved(DirectoryLoadThread.access$0(this.this$1), this.removeIndex, this.removeIndex + n - 1);
                        return;
                    } else if (n == 0 && n2 > 0) {
                        this.this$1.this$0.fireIntervalAdded(DirectoryLoadThread.access$0(this.this$1), this.addIndex, this.addIndex + n2 - 1);
                        return;
                    } else {
                        this.this$1.this$0.fireContentsChanged();
                    }
                    return;
                }
            }

            void cancel() {
                this.cancel = true;
            }
        }
    }
}

