#!/bin/sh
echo 'name: redis
version: 0.11
id: redis-0.11-f3bda613ca68059933701a7042e91f77

license: MIT
copyright: Copyright (c) 2009-2010 Alexander Bogdanov
maintainer: Alexander Bogdanov <andorn@gmail.com>
stability: beta
homepage:
package-url:
description: Redis (<http://redis.io>) is an open source, BSD licensed, advanced
             key-value store. It is often referred as a data structure server
             since keys can contain different data structures, such as strings,
             hashes, lists, sets and sorted sets.
             .
             This library is a Haskell driver for Redis. It'\''s tested with
             current git version and with v2.2.4 of redis server. It also
             tested with v2.0.5 and basic functions are works correctly but not
             all of them.
             .
             You can use Test module from the source package to run unit
             tests. Try /runhaskell Test.hs --help/ for usage info. Caution! Do not
             run tests on your working database - test database will be
             flushed.
             .
             There are simple benchmark module included: Benchmark.hs. It shows
             me about two times less requests per second than redis-benchmark
             from server distribution.
             .
             Please let me know if tests or benchmark goes terribly wrong.
             .
             Changes from v0.10:
             .
             - Simple optimisation of redis protocol replays parsing that leads to
             significant speed improvement on get-like commands
             .
             - New commandline options for test runner (see above)
             .
             - Simple benchmark included (see above)
             .
             - New commands implemented: brpoplpush (blocking rpoplpush),
             getrange, setrange, getbit and setbit
             .
             - getType reply is now parsed into RedisKeyType datatype instead
             of just returning Reply. Warning! It'\''s backward incompatible!
             .
             - info reply is now parsed into Map String String. Warning! It'\''s
             backward incompatible!
category: Database
author: Alexander Bogdanov <andorn@gmail.com>
pkgpath: databases/hs-redis
exposed: True
exposed-modules: Database.Redis.Redis Database.Redis.Monad
                 Database.Redis.ByteStringClass Database.Redis.Monad.State
                 Database.Redis.Utils.Lock Database.Redis.Utils.Monad.Lock
hidden-modules: Database.Redis.Internal Database.Redis.Info
import-dirs: /usr/local/lib/ghc/redis-0.11
library-dirs: /usr/local/lib/ghc/redis-0.11
hs-libraries: HSredis-0.11
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: MonadCatchIO-mtl-0.3.0.2-d37299717086611240bcc2c804af186d
         base-4.3.1.0-912d55d387093f740e3bcd2ffbf1dd83
         bytestring-0.9.1.10-e7cebdd905566e960c42140389871ec1
         containers-0.4.0.0-18deac99a132f04751d862b77aab136e
         mtl-2.0.1.0-9763a8821c812a910d327bad2c0d23b2
         network-2.3.0.2-51cd64b57afa0471aa34f65914adc9bc
         old-time-1.0.0.6-37d6575186c36059fbc372c289dbddd4
         parsec-3.1.1-f737418bc255d829c47b208a553987bf
         utf8-string-0.3.6-41fffa08ae1349e9fe1e9be7575781f1
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-redis-0.11/html/redis.haddock
haddock-html: /usr/local/share/doc/hs-redis-0.11/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
