#!/bin/sh
echo 'name: snap-core
version: 0.2.16
id: snap-core-0.2.16-6f34eb53399d05513878f31925632b6c

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
description: This is the first developer prerelease of the Snap framework.  Snap is a
             simple and fast web development framework and server written in Haskell. For
             more information or to download the latest version, you can visit the Snap
             project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", inspired by
             happstack'\''s (<http://happstack.com/index.html>), which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Types",
             some iteratee utilities are in "Snap.Iteratee".
             .
             Higher-level facilities for building web applications (like user/session
             management, component interfaces, data modeling, etc.) are planned but not
             yet implemented, so this release will mostly be of interest for those who:
             .
             * need a fast and minimal HTTP API at roughly the same level of abstraction
             as Java servlets, or
             .
             * are interested in contributing to the Snap Framework project.
category: Web
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Data.CIByteString Snap.Types Snap.Iteratee
                 Snap.Internal.Debug Snap.Internal.Http.Types
                 Snap.Internal.Iteratee.Debug Snap.Util.FileServe Snap.Util.GZip
hidden-modules: Snap.Internal.Parsing Snap.Internal.Routing
                Snap.Internal.Types
import-dirs: /usr/local/lib/ghc/snap-core-0.2.16
library-dirs: /usr/local/lib/ghc/snap-core-0.2.16
hs-libraries: HSsnap-core-0.2.16
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: ListLike-1.0.1-24733b29426ef902776a2ed67e62da90
         MonadCatchIO-transformers-0.2.2.0-20de5f1552a5f929e72e65b3e224d8d4
         attoparsec-0.8.1.0-eefa709ae8bad60a3a00cef97649541a
         base-4.3.1.0-912d55d387093f740e3bcd2ffbf1dd83
         bytestring-0.9.1.10-e7cebdd905566e960c42140389871ec1
         bytestring-nums-0.3.2-aad74142ff217482f19f1823fafccff6
         bytestring-show-0.3.4-f618dd181e8e5c0a88d11ae342166bc0
         cereal-0.3.0.0-3cb8b258e48ebb16acfcc9dfed280198
         containers-0.4.0.0-18deac99a132f04751d862b77aab136e
         deepseq-1.1.0.2-09b3aed0c4982bbc6569c668100876fa
         directory-1.1.0.0-9b4fc50fd8f1413dca2a5e01dd665f6d
         directory-tree-0.2.0-b448076cd28e0d932f59dc4562d05755
         dlist-0.5-7af76ca304bfdc972badbaffe8582d08
         filepath-1.2.0.0-679ac50c41ba31bfc69abf444d9852e4
         haskell98-1.1.0.1-37bbd494afca009c19843e11b5432f37
         iteratee-0.3.5-de0b3e57957c5fcc3503587087928df6
         monads-fd-0.1.0.1-44860ea6230bfd05855a3c8d11d889cf
         old-locale-1.0.0.2-6e2a3c0744e8cf4e0ac2d4e58659f7b5
         old-time-1.0.0.6-37d6575186c36059fbc372c289dbddd4
         template-haskell-2.5.0.0-45b8378871fd7cfc4fb167b5347ef44e
         text-0.11.0.6-ace87dcbd28176f4bf784c8b8e080ab9
         time-1.2.0.3-57ebba2cc05370f666b7eceba5e468a9
         transformers-0.2.2.0-a8a2dbba7d96131db605cf631ea0c8c4
         unix-compat-0.2-6d3b6d3520a3164e3f2d5dc9a14c02a4
         zlib-0.5.3.1-5fbdf714525b76e0e601c2ffb25f2044
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.2.16/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.2.16/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
