/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.gpp.GppClosureParameterTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GppTypeConverter
extends GrTypeConverter {
    public static boolean hasTypedContext(PsiElement context) {
        if (context == null) {
            return false;
        }
        if (context instanceof PsiModifierListOwner && GppTypeConverter.isTyped(((PsiModifierListOwner)context).getModifierList())) {
            return true;
        }
        GrMember parentMember = (GrMember)PsiTreeUtil.getContextOfType((PsiElement)context, GrMember.class, (boolean)true);
        if (parentMember != null) {
            return GppTypeConverter.hasTypedContext((PsiElement)parentMember);
        }
        PsiFile file = context.getContainingFile();
        if (file instanceof GroovyFile) {
            String extension;
            GrPackageDefinition packageDefinition = ((GroovyFile)file).getPackageDefinition();
            if (packageDefinition != null && GppTypeConverter.isTyped((PsiModifierList)packageDefinition.getAnnotationList())) {
                return true;
            }
            VirtualFile vfile = file.getVirtualFile();
            return vfile != null && ("gpp".equals(extension = vfile.getExtension()) || "grunit".equals(vfile.getExtension()));
        }
        return false;
    }

    private static boolean isTyped(PsiModifierList modifierList) {
        return modifierList != null && modifierList.findAnnotation("groovy.lang.Typed") != null;
    }

    public Boolean isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppTypeConverter.isConvertible must not be null");
        }
        if (rType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppTypeConverter.isConvertible must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppTypeConverter.isConvertible must not be null");
        }
        if (rType instanceof GrTupleType) {
            PsiType[] componentTypes = ((GrTupleType)rType).getComponentTypes();
            PsiType expectedComponent = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lType, (boolean)false);
            if (expectedComponent != null && GppTypeConverter.hasDefaultConstructor(lType)) {
                return true;
            }
            if (lType instanceof PsiClassType && GppTypeConverter.hasConstructor((PsiClassType)lType, componentTypes, context)) {
                return true;
            }
            return null;
        }
        if (rType instanceof GrMapType) {
            if (GppTypeConverter.hasDefaultConstructor(lType)) {
                return true;
            }
            return null;
        }
        if (rType instanceof GrClosureType) {
            PsiType[] methodParameters = GppClosureParameterTypeProvider.findSingleAbstractMethodSignature(lType);
            GrClosureSignature signature = ((GrClosureType)rType).getSignature();
            if (methodParameters != null && GrClosureSignatureUtil.isSignatureApplicable((GrClosureSignature)signature, (PsiType[])methodParameters, (GroovyPsiElement)context)) {
                return true;
            }
            return false;
        }
        return null;
    }

    private static boolean hasDefaultConstructor(PsiType type) {
        PsiClass psiClass = com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)type);
        return psiClass != null && com.intellij.psi.util.PsiUtil.hasDefaultConstructor((PsiClass)psiClass, (boolean)true);
    }

    private static boolean hasConstructor(PsiClassType lType, PsiType[] argTypes, GroovyPsiElement context) {
        return GppTypeConverter.getConstructorCandidates(lType, argTypes, context).length == 1;
    }

    public static GroovyResolveResult[] getConstructorCandidates(PsiClassType classType, PsiType[] argTypes, GroovyPsiElement context) {
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (psiClass == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult grResult = resolveResult instanceof GroovyResolveResult ? (GroovyResolveResult)resolveResult : new GroovyResolveResultImpl((PsiElement)psiClass, context, substitutor, true, true);
        return PsiUtil.getConstructorCandidates((GroovyPsiElement)context, (GroovyResolveResult[])new GroovyResolveResult[]{grResult}, (PsiType[])argTypes);
    }
}

