/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonAnalyzerTestCase;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.statistics.impl.StatisticsManagerImpl;
import java.util.Arrays;

public abstract class CompletionTestCase
extends DaemonAnalyzerTestCase {
    protected String myPrefix;
    protected LookupElement[] myItems;
    private CompletionType myType = CompletionType.BASIC;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ((StatisticsManagerImpl)StatisticsManager.getInstance()).clearStatistics();
    }

    @Override
    protected void tearDown() throws Exception {
        LookupManager.getInstance((Project)this.myProject).hideActiveLookup();
        super.tearDown();
        this.myItems = null;
    }

    @Override
    protected void configureByFile(String filePath) throws Exception {
        super.configureByFile(filePath);
        this.complete();
    }

    protected void configureByFileNoCompletion(String filePath) throws Exception {
        super.configureByFile(filePath);
    }

    protected void complete() {
        new CodeCompletionHandlerBase(this.myType).invoke(this.myProject, this.myEditor, this.myFile);
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
        this.myItems = lookup == null ? null : lookup.getItems().toArray(LookupElement.EMPTY_ARRAY);
        this.myPrefix = lookup == null ? "" : ((LookupElement)((Object)lookup.getItems().get(0))).getPrefixMatcher().getPrefix();
    }

    public void setType(CompletionType type) {
        this.myType = type;
    }

    protected void selectItem(LookupElement item, char ch) {
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance((Project)this.myProject).getActiveLookup();
        lookup.setCurrentItem(item);
        lookup.finishLookup(ch);
    }

    protected void selectItem(LookupElement item) {
        this.selectItem(item, '\u0000');
    }

    protected void testByCount(int finalCount, String ... values) {
        int index = 0;
        if (this.myItems == null) {
            CompletionTestCase.assertEquals((int)0, (int)finalCount);
            return;
        }
        block0: for (int i = 0; i < this.myItems.length; ++i) {
            LookupElement myItem = this.myItems[i];
            for (int j = 0; j < values.length; ++j) {
                if (values[j] == null) {
                    CompletionTestCase.assertFalse((String)"Unacceptable value reached", (boolean)true);
                }
                if (!values[j].equals(myItem.getLookupString())) continue;
                ++index;
                continue block0;
            }
        }
        CompletionTestCase.assertEquals((String)Arrays.toString((Object[])this.myItems), (int)finalCount, (int)index);
    }

    protected LookupImpl getActiveLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
    }
}

