/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offline;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OfflineProblemDescriptor {
    public String myType;
    public String myFQName;
    public String myDescription;
    public List<String> myHints;
    public int myProblemIndex;
    public int myLine;
    public String[] myParentType;
    public String[] myParentFQName;
    public String myModuleName;

    public String getType() {
        return this.myType;
    }

    public void setType(String type) {
        this.myType = type;
    }

    public String getFQName() {
        return this.myFQName;
    }

    public void setFQName(String FQName) {
        this.myFQName = FQName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public List<String> getHints() {
        return this.myHints;
    }

    public void setHints(List<String> hints) {
        this.myHints = hints;
    }

    public int getProblemIndex() {
        return this.myProblemIndex;
    }

    public void setProblemIndex(int problemIndex) {
        this.myProblemIndex = problemIndex;
    }

    public int getLine() {
        return this.myLine;
    }

    public void setLine(int line) {
        this.myLine = line;
    }

    public String[] getParentType() {
        return this.myParentType;
    }

    public void setParentType(String[] parentType) {
        this.myParentType = parentType;
    }

    public String[] getParentFQName() {
        return this.myParentFQName;
    }

    public void setParentFQName(String[] parentFQName) {
        this.myParentFQName = parentFQName;
    }

    @Nullable
    public RefEntity getRefElement(RefManager refManager) {
        PsiElement element;
        RefEntity refElement = refManager.getReference(this.myType, this.myFQName);
        if (refElement instanceof RefElement && (element = ((RefElement)refElement).getElement()) != null && element.isValid()) {
            PsiDocumentManager.getInstance(element.getProject()).commitAllDocuments();
        }
        return refElement;
    }

    @Nullable
    public OfflineProblemDescriptor getOwner() {
        if (this.myParentType != null && this.myParentFQName != null) {
            OfflineProblemDescriptor descriptor = new OfflineProblemDescriptor();
            descriptor.setLine(this.myLine);
            descriptor.setFQName(this.myParentFQName[0]);
            descriptor.setType(this.myParentType[0]);
            if (this.myParentType.length > 1 && this.myParentFQName.length > 1) {
                descriptor.setParentType((String[])ArrayUtil.remove((Object[])this.myParentType, (int)0));
                descriptor.setParentFQName((String[])ArrayUtil.remove((Object[])this.myParentFQName, (int)0));
            }
            return descriptor;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfflineProblemDescriptor that = (OfflineProblemDescriptor)o;
        if (this.myLine != that.myLine) {
            return false;
        }
        if (this.myProblemIndex != that.myProblemIndex) {
            return false;
        }
        if (this.myDescription != null ? !this.myDescription.equals(that.myDescription) : that.myDescription != null) {
            return false;
        }
        if (this.myFQName != null ? !this.myFQName.equals(that.myFQName) : that.myFQName != null) {
            return false;
        }
        if (this.myHints != null ? !((Object)this.myHints).equals(that.myHints) : that.myHints != null) {
            return false;
        }
        if (this.myModuleName != null ? !this.myModuleName.equals(that.myModuleName) : that.myModuleName != null) {
            return false;
        }
        if (!Arrays.equals(this.myParentFQName, that.myParentFQName)) {
            return false;
        }
        if (!Arrays.equals(this.myParentType, that.myParentType)) {
            return false;
        }
        return !(this.myType != null ? !this.myType.equals(that.myType) : that.myType != null);
    }

    public int hashCode() {
        int result = this.myType != null ? this.myType.hashCode() : 0;
        result = 31 * result + (this.myFQName != null ? this.myFQName.hashCode() : 0);
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myHints != null ? ((Object)this.myHints).hashCode() : 0);
        result = 31 * result + this.myProblemIndex;
        result = 31 * result + this.myLine;
        result = 31 * result + (this.myParentType != null ? Arrays.hashCode(this.myParentType) : 0);
        result = 31 * result + (this.myParentFQName != null ? Arrays.hashCode(this.myParentFQName) : 0);
        result = 31 * result + (this.myModuleName != null ? this.myModuleName.hashCode() : 0);
        return result;
    }

    public void setModule(String moduleName) {
        this.myModuleName = moduleName;
    }

    public String getModuleName() {
        return this.myModuleName;
    }
}

