/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationBase
extends UserDataHolderBase
implements RunConfiguration {
    private final ConfigurationFactory myFactory;
    private final Project myProject;
    private String myName = "";
    private ArrayList<LogFileOptions> myLogFiles = new ArrayList();
    private ArrayList<PredefinedLogFile> myPredefinedLogFiles = new ArrayList();
    @NonNls
    private static final String LOG_FILE = "log_file";
    @NonNls
    private static final String PREDEFINED_LOG_FILE_ELEMENT = "predefined_log_file";
    private Icon myIcon;

    protected RunConfigurationBase(Project project, ConfigurationFactory factory, String name) {
        this.myProject = project;
        this.myFactory = factory;
        this.myName = name;
        this.myIcon = factory.getIcon();
    }

    @Override
    public int getUniqueID() {
        return System.identityHashCode(this);
    }

    @Override
    public final ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public final void setName(String name) {
        this.myName = name;
    }

    @Override
    public final Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ConfigurationType getType() {
        ConfigurationType configurationType = this.myFactory.getType();
        if (configurationType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/configurations/RunConfigurationBase.getType must not return null");
        }
        return configurationType;
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public final String getName() {
        return this.myName;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void checkRunnerSettings(@NotNull ProgramRunner runner, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
        if (runner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/RunConfigurationBase.checkRunnerSettings must not be null");
        }
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public RunConfiguration clone() {
        RunConfigurationBase runConfiguration = (RunConfigurationBase)super.clone();
        runConfiguration.myLogFiles = new ArrayList<LogFileOptions>(this.myLogFiles);
        runConfiguration.myPredefinedLogFiles = new ArrayList<PredefinedLogFile>(this.myPredefinedLogFiles);
        this.copyCopyableDataTo(runConfiguration);
        return runConfiguration;
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        return null;
    }

    public void removeAllPredefinedLogFiles() {
        this.myPredefinedLogFiles.clear();
    }

    public void addPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        this.myPredefinedLogFiles.add(predefinedLogFile);
    }

    public ArrayList<PredefinedLogFile> getPredefinedLogFiles() {
        return this.myPredefinedLogFiles;
    }

    public ArrayList<LogFileOptions> getAllLogFiles() {
        ArrayList<LogFileOptions> list = new ArrayList<LogFileOptions>(this.myLogFiles);
        for (PredefinedLogFile predefinedLogFile : this.myPredefinedLogFiles) {
            LogFileOptions options = this.getOptionsForPredefinedLogFile(predefinedLogFile);
            if (options == null) continue;
            list.add(options);
        }
        return list;
    }

    public ArrayList<LogFileOptions> getLogFiles() {
        return this.myLogFiles;
    }

    public void addLogFile(String file, String alias, boolean checked) {
        this.myLogFiles.add(new LogFileOptions(alias, file, checked, true, false));
    }

    public void addLogFile(String file, String alias, boolean checked, boolean skipContent, boolean showAll) {
        this.myLogFiles.add(new LogFileOptions(alias, file, checked, skipContent, showAll));
    }

    public void removeAllLogFiles() {
        this.myLogFiles.clear();
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
    }

    public void customizeLogConsole(LogConsole console) {
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myLogFiles.clear();
        for (Object o : element.getChildren(LOG_FILE)) {
            LogFileOptions logFileOptions = new LogFileOptions();
            logFileOptions.readExternal((Element)o);
            this.myLogFiles.add(logFileOptions);
        }
        this.myPredefinedLogFiles.clear();
        List list = element.getChildren(PREDEFINED_LOG_FILE_ELEMENT);
        for (Object fileElement : list) {
            PredefinedLogFile logFile = new PredefinedLogFile();
            logFile.readExternal((Element)fileElement);
            this.myPredefinedLogFiles.add(logFile);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (LogFileOptions options : this.myLogFiles) {
            Element logFile = new Element(LOG_FILE);
            options.writeExternal(logFile);
            element.addContent(logFile);
        }
        for (PredefinedLogFile predefinedLogFile : this.myPredefinedLogFiles) {
            Element fileElement = new Element(PREDEFINED_LOG_FILE_ELEMENT);
            predefinedLogFile.writeExternal(fileElement);
            element.addContent(fileElement);
        }
    }

    public boolean needAdditionalConsole() {
        return true;
    }
}

