/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;

public class CompositeFilter
implements Filter {
    private final List<Filter> myFilters = new ArrayList<Filter>();
    private final Project myProject;

    public CompositeFilter(Project project) {
        this.myProject = project;
    }

    @Override
    public Filter.Result applyFilter(String line, int entireLength) {
        boolean dumb = DumbService.getInstance(this.myProject).isDumb();
        for (Filter filter : this.myFilters) {
            Filter.Result info;
            if (dumb && !(filter instanceof DumbAware) || (info = filter.applyFilter(line, entireLength)) == null) continue;
            return info;
        }
        return null;
    }

    public void addFilter(Filter filter) {
        this.myFilters.add(filter);
    }
}

