/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewNode<Value>
extends AbstractTreeNode<Value> {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.ProjectViewNode");
    private final ViewSettings mySettings;

    protected ProjectViewNode(Project project, Value value, ViewSettings viewSettings) {
        super(project, value);
        this.mySettings = viewSettings;
    }

    public abstract boolean contains(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    public final ViewSettings getSettings() {
        return this.mySettings;
    }

    public static List<AbstractTreeNode> wrap(Collection objects, Project project, Class<? extends AbstractTreeNode> nodeClass, ViewSettings settings) {
        try {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (Object object : objects) {
                result.add(ProjectViewNode.createTreeNode(nodeClass, project, object, settings));
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new ArrayList<AbstractTreeNode>();
        }
    }

    public static AbstractTreeNode createTreeNode(Class<? extends AbstractTreeNode> nodeClass, Project project, Object value, ViewSettings settings) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] parameters = new Object[]{project, value, settings};
        for (Constructor<?> constructor : nodeClass.getConstructors()) {
            if (constructor.getParameterTypes().length != 3) continue;
            try {
                return (AbstractTreeNode)constructor.newInstance(parameters);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        throw new InstantiationException("no constructor found in " + nodeClass);
    }

    public boolean someChildContainsFile(VirtualFile file) {
        Collection<AbstractTreeNode> kids = this.getChildren();
        for (AbstractTreeNode kid : kids) {
            ProjectViewNode node = (ProjectViewNode)kid;
            if (!node.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasProblemFileBeneath() {
        return WolfTheProblemSolver.getInstance(this.getProject()).hasProblemFilesBeneath(new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                return ProjectViewNode.this.contains(virtualFile) && (ProjectViewNode.this.getValue() instanceof PsiElement && PsiUtilBase.getVirtualFile((PsiElement)ProjectViewNode.this.getValue()) == virtualFile || ProjectViewNode.this.someChildContainsFile(virtualFile));
            }
        });
    }

    public boolean canHaveChildrenMatching(Condition<PsiFile> condition) {
        return true;
    }

    @Nullable
    public String getTitle() {
        return null;
    }

    public boolean isSortByFirstChild() {
        return false;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 0;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return null;
    }

    @Nullable
    public Comparable getSortKey() {
        return null;
    }

    @Nullable
    public String getQualifiedNameSortKey() {
        return null;
    }

    public boolean shouldDrillDownOnEmptyElement() {
        return false;
    }

    public boolean validate() {
        this.update();
        return this.getValue() != null;
    }

    @Override
    public boolean isAlwaysLeaf() {
        return false;
    }
}

