/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.Shortcut;
import javax.swing.KeyStroke;

public class KeyboardModifierGestureShortuct
extends Shortcut {
    private final KeyStroke myStroke;
    private final KeyboardGestureAction.ModifierType myType;

    public static Shortcut newInstance(KeyboardGestureAction.ModifierType type, KeyStroke stroke) {
        switch (type) {
            case dblClick: {
                return new DblClick(stroke);
            }
            case hold: {
                return new Hold(stroke);
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    protected KeyboardModifierGestureShortuct(KeyStroke stroke, KeyboardGestureAction.ModifierType type) {
        this.myStroke = stroke;
        this.myType = type;
    }

    public KeyStroke getStroke() {
        return this.myStroke;
    }

    public KeyboardGestureAction.ModifierType getType() {
        return this.myType;
    }

    @Override
    public boolean isKeyboard() {
        return true;
    }

    @Override
    public boolean startsWith(Shortcut sc) {
        if (!(sc instanceof KeyboardModifierGestureShortuct)) {
            return false;
        }
        KeyboardModifierGestureShortuct other = (KeyboardModifierGestureShortuct)sc;
        if (this.myType.equals((Object)other.myType)) {
            if (this.myStroke.getModifiers() != other.myStroke.getModifiers()) {
                return false;
            }
            return other.myStroke.getKeyCode() != -1 || other.myStroke.getKeyCode() == this.myStroke.getKeyCode();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyboardModifierGestureShortuct that = (KeyboardModifierGestureShortuct)o;
        if (this.myStroke != null ? !this.myStroke.equals(that.myStroke) : that.myStroke != null) {
            return false;
        }
        return this.myType == that.myType;
    }

    public int hashCode() {
        int result = this.myStroke != null ? this.myStroke.hashCode() : 0;
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }

    public static class Hold
    extends KeyboardModifierGestureShortuct {
        public Hold(KeyStroke stroke) {
            super(stroke, KeyboardGestureAction.ModifierType.hold);
        }
    }

    public static class DblClick
    extends KeyboardModifierGestureShortuct {
        public DblClick(KeyStroke stroke) {
            super(stroke, KeyboardGestureAction.ModifierType.dblClick);
        }
    }
}

