/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public abstract class CheckboxAction
extends ToggleAction
implements CustomComponentAction {
    private JCheckBox myCheckBox;

    protected CheckboxAction() {
    }

    protected CheckboxAction(String text) {
        super(text);
    }

    protected CheckboxAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    public JComponent createCustomComponent(Presentation presentation) {
        this.myCheckBox = new JCheckBox(presentation.getText());
        this.myCheckBox.setToolTipText(presentation.getDescription());
        this.myCheckBox.setMnemonic(presentation.getMnemonic());
        this.myCheckBox.setDisplayedMnemonicIndex(presentation.getDisplayedMnemonicIndex());
        this.myCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckboxAction.this.actionPerformed(new AnActionEvent(null, DataManager.getInstance().getDataContext(CheckboxAction.this.myCheckBox), "unknown", CheckboxAction.this.getTemplatePresentation(), ActionManager.getInstance(), 0));
            }
        });
        return this.myCheckBox;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        if (this.myCheckBox != null) {
            this.myCheckBox.setSelected((Boolean)e.getPresentation().getClientProperty("selected"));
        }
    }
}

