/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public abstract class ModalityState {
    @NotNull
    public static final ModalityState NON_MODAL;
    @Deprecated
    @NotNull
    public static final ModalityState NON_MMODAL;

    public static ModalityState current() {
        return ApplicationManager.getApplication().getCurrentModalityState();
    }

    public static ModalityState stateForComponent(Component component) {
        return ApplicationManager.getApplication().getModalityStateForComponent(component);
    }

    public static ModalityState defaultModalityState() {
        return ApplicationManager.getApplication().getDefaultModalityState();
    }

    public abstract boolean dominates(ModalityState var1);

    static {
        try {
            Class<?> ex = Class.forName("com.intellij.openapi.application.impl.ModalityStateEx");
            NON_MMODAL = NON_MODAL = (ModalityState)ex.newInstance();
            assert (NON_MODAL != null);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

