/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.StringTokenizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isClassAvailableInLibrary(Library library, String fqn) {
        return LibraryUtil.isClassAvailableInLibrary(library.getFiles(OrderRootType.CLASSES), fqn);
    }

    public static boolean isClassAvailableInLibrary(VirtualFile[] files, String fqn) {
        for (VirtualFile file : files) {
            if (!LibraryUtil.findInFile(file, new StringTokenizer(fqn, "."))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Library findLibraryByClass(String fqn, @Nullable Project project) {
        LibraryTable projectTable;
        Library library;
        if (project != null && (library = LibraryUtil.findInTable(projectTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project), fqn)) != null) {
            return library;
        }
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable();
        return LibraryUtil.findInTable(table, fqn);
    }

    private static boolean findInFile(VirtualFile file, StringTokenizer tokenizer) {
        VirtualFile child;
        if (!tokenizer.hasMoreTokens()) {
            return true;
        }
        StringBuilder name = new StringBuilder(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            name.append(".class");
        }
        return (child = file.findChild(name.toString())) != null && LibraryUtil.findInFile(child, tokenizer);
    }

    @Nullable
    private static Library findInTable(LibraryTable table, String fqn) {
        for (Library library : table.getLibraries()) {
            if (!LibraryUtil.isClassAvailableInLibrary(library, fqn)) continue;
            return library;
        }
        return null;
    }

    public static Library createLibrary(LibraryTable libraryTable, @NonNls String baseName) {
        String name = baseName;
        int count = 2;
        while (libraryTable.getLibraryByName(name) != null) {
            name = baseName + " (" + count++ + ")";
        }
        return libraryTable.createLibrary(name);
    }

    public static VirtualFile[] getLibraryRoots(Project project) {
        return LibraryUtil.getLibraryRoots(project, true, true);
    }

    public static VirtualFile[] getLibraryRoots(Project project, boolean includeSourceFiles, boolean includeJdk) {
        return LibraryUtil.getLibraryRoots(ModuleManager.getInstance(project).getModules(), includeSourceFiles, includeJdk);
    }

    public static VirtualFile[] getLibraryRoots(Module[] modules, boolean includeSourceFiles, boolean includeJdk) {
        HashSet roots = new HashSet();
        for (Module module : modules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry entry : orderEntries = moduleRootManager.getOrderEntries()) {
                VirtualFile[] files;
                if (entry instanceof LibraryOrderEntry) {
                    VirtualFile[] files2;
                    Library library = ((LibraryOrderEntry)entry).getLibrary();
                    if (library == null) continue;
                    VirtualFile[] virtualFileArray = files2 = includeSourceFiles ? library.getFiles(OrderRootType.SOURCES) : null;
                    if (files2 == null || files2.length == 0) {
                        files2 = library.getFiles(OrderRootType.CLASSES);
                    }
                    roots.addAll(Arrays.asList(files2));
                    continue;
                }
                if (!includeJdk || !(entry instanceof JdkOrderEntry)) continue;
                VirtualFile[] virtualFileArray = files = includeSourceFiles ? entry.getFiles(OrderRootType.SOURCES) : null;
                if (files == null || files.length == 0) {
                    files = entry.getFiles(OrderRootType.CLASSES);
                }
                roots.addAll(Arrays.asList(files));
            }
        }
        return VfsUtil.toVirtualFileArray((Collection<? extends VirtualFile>)roots);
    }

    public static Library findLibrary(Module module, final String name) {
        return ModuleRootManager.getInstance(module).processOrder(new RootPolicy<Library>(){

            @Override
            public Library visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Library value) {
                if (value != null) {
                    return value;
                }
                if (name.equals(libraryOrderEntry.getLibraryName())) {
                    return libraryOrderEntry.getLibrary();
                }
                return null;
            }
        }, null);
    }

    @Nullable
    public static OrderEntry findLibraryEntry(VirtualFile file, Project project) {
        List<OrderEntry> entries = ProjectRootManager.getInstance(project).getFileIndex().getOrderEntriesForFile(file);
        for (OrderEntry entry : entries) {
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry)) continue;
            return entry;
        }
        return null;
    }
}

