/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ReadonlyStatusHandler {
    public static boolean ensureFilesWritable(@NotNull Project project, VirtualFile ... files) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/ReadonlyStatusHandler.ensureFilesWritable must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ReadonlyStatusHandler.ensureFilesWritable must not be null");
        }
        return !ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(files).hasReadonlyFiles();
    }

    public abstract OperationStatus ensureFilesWritable(VirtualFile ... var1);

    public OperationStatus ensureFilesWritable(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/ReadonlyStatusHandler.ensureFilesWritable must not be null");
        }
        return this.ensureFilesWritable(VfsUtil.toVirtualFileArray(files));
    }

    public static ReadonlyStatusHandler getInstance(Project project) {
        return ServiceManager.getService(project, ReadonlyStatusHandler.class);
    }

    public static abstract class OperationStatus {
        @NotNull
        public abstract VirtualFile[] getReadonlyFiles();

        public abstract boolean hasReadonlyFiles();

        @NotNull
        public abstract String getReadonlyFilesMessage();
    }
}

