/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.artifacts;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactType {
    public static final ExtensionPointName<ArtifactType> EP_NAME = ExtensionPointName.create((String)"com.intellij.packaging.artifactType");
    private final String myId;
    private final String myTitle;

    protected ArtifactType(@NonNls String id, String title) {
        this.myId = id;
        this.myTitle = title;
    }

    public final String getId() {
        return this.myId;
    }

    public String getPresentableName() {
        return this.myTitle;
    }

    @NotNull
    public abstract Icon getIcon();

    @Nullable
    public String getDefaultPathFor(@NotNull PackagingSourceItem sourceItem) {
        if (sourceItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.getDefaultPathFor must not be null");
        }
        return this.getDefaultPathFor(sourceItem.getKindOfProducedElements());
    }

    @Nullable
    public abstract String getDefaultPathFor(@NotNull PackagingElementOutputKind var1);

    public boolean isSuitableItem(@NotNull PackagingSourceItem sourceItem) {
        if (sourceItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.isSuitableItem must not be null");
        }
        return true;
    }

    public static ArtifactType[] getAllTypes() {
        return (ArtifactType[])Extensions.getExtensions(EP_NAME);
    }

    @Nullable
    public static ArtifactType findById(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.findById must not be null");
        }
        for (ArtifactType type : ArtifactType.getAllTypes()) {
            if (!id.equals(type.getId())) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public abstract CompositePackagingElement<?> createRootElement(@NotNull String var1);

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.getNewArtifactTemplates must not be null");
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/artifacts/ArtifactType.getNewArtifactTemplates must not return null");
        }
        return list;
    }

    public void checkRootElement(@NotNull CompositePackagingElement<?> rootElement, @NotNull Artifact artifact, @NotNull ArtifactProblemsHolder manager) {
        if (rootElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.checkRootElement must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.checkRootElement must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.checkRootElement must not be null");
        }
    }

    @Nullable
    public List<? extends PackagingElement<?>> getSubstitution(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType parentType) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.getSubstitution must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.getSubstitution must not be null");
        }
        if (parentType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/artifacts/ArtifactType.getSubstitution must not be null");
        }
        return null;
    }
}

