/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.CommonBundle;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class PsiBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    private static final String BUNDLE = "messages.PsiBundle";

    private PsiBundle() {
    }

    public static String message(@PropertyKey(resourceBundle="messages.PsiBundle") String key, Object ... params) {
        return CommonBundle.message((ResourceBundle)PsiBundle.getBundle(), (String)key, (Object[])params);
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = null;
        if (ourBundle != null) {
            bundle = ourBundle.get();
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    @NotNull
    public static String visibilityPresentation(@NotNull String modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiBundle.visibilityPresentation must not be null");
        }
        String string = PsiBundle.message(modifier + ".visibility.presentation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiBundle.visibilityPresentation must not return null");
        }
        return string;
    }
}

