/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.annotations.NotNull;

public abstract class CachedValuesManager {
    private static final NotNullLazyKey<CachedValuesManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(CachedValuesManager.class);

    public static CachedValuesManager getManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getManager must not be null");
        }
        return (CachedValuesManager)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    public abstract <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> var1, boolean var2);

    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.createCachedValue must not be null");
        }
        return this.createCachedValue(provider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, D extends UserDataHolder, P> T getParameterizedCachedValue(@NotNull D dataHolder, @NotNull Key<ParameterizedCachedValue<T, P>> key, @NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue, P parameter) {
        ParameterizedCachedValue value;
        if (dataHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getParameterizedCachedValue must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getParameterizedCachedValue must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/CachedValuesManager.getParameterizedCachedValue must not be null");
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = (ParameterizedCachedValue)dh.getUserData(key);
            if (value == null) {
                value = this.createParameterizedCachedValue(provider, trackValue);
                value = (ParameterizedCachedValue)dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = (ParameterizedCachedValue)dataHolder.getUserData(key);
                if (value == null) {
                    value = this.createParameterizedCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, (Object)value);
                }
            }
        }
        return value.getValue(parameter);
    }

    public abstract <T, D extends UserDataHolder> T getCachedValue(@NotNull D var1, @NotNull Key<CachedValue<T>> var2, @NotNull CachedValueProvider<T> var3, boolean var4);
}

