/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class CommandButtonGroup
extends JPanel {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private int myPreferredH = 0;
    private int myPreferredW = 0;
    private int myAxis;

    public CommandButtonGroup() {
        this(0);
    }

    public CommandButtonGroup(int axis) {
        this.myAxis = axis;
        this.setLayout(new BoxLayout(this, axis));
        if (axis == 0) {
            this.add(Box.createHorizontalGlue());
        }
    }

    public void addButton(AbstractButton button) {
        this.addButton(button, 2);
    }

    public void addButton(AbstractButton button, int position) {
        if (1 == position) {
            this.add((Component)button, 0);
            if (this.myAxis == 0) {
                this.add(Box.createHorizontalStrut(5), 1);
            } else {
                this.add(Box.createVerticalStrut(5), 1);
            }
        } else {
            if (this.myAxis == 0) {
                this.add(Box.createHorizontalStrut(5));
            } else {
                this.add(Box.createVerticalStrut(5));
            }
            this.add(button);
        }
        Dimension prefSize = button.getPreferredSize();
        if (prefSize.height > this.myPreferredH) {
            this.myPreferredH = prefSize.height;
        }
        if (prefSize.width > this.myPreferredW) {
            this.myPreferredW = prefSize.width;
        }
        this.updateButtonSizes();
    }

    private void updateButtonSizes() {
        Dimension dim = new Dimension(this.myPreferredW, this.myPreferredH);
        Component[] components = this.getComponents();
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)components[i];
            button.setPreferredSize(dim);
            button.setMaximumSize(dim);
            button.setMinimumSize(dim);
        }
    }
}

