/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;

public class TableCellState {
    private boolean mySelected;
    private Color myForeground;
    private Color myBackground;
    private Font myFont;
    private Border myCellBorder;

    public void collectState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
        this.clear();
        this.mySelected = isSelected;
        this.myFont = table.getFont();
        if (isSelected) {
            this.myForeground = table.getSelectionForeground();
            this.myBackground = table.getSelectionBackground();
        } else {
            this.myForeground = table.getForeground();
            this.myBackground = table.getBackground();
        }
        if (hasFocus) {
            this.myCellBorder = UIUtil.getTableFocusCellHighlightBorder();
            if (table.isCellEditable(row, column)) {
                this.myForeground = UIUtil.getTableFocusCellForeground();
                this.myBackground = UIUtil.getTableFocusCellBackground();
            }
        }
    }

    public void updateRenderer(JComponent renderer) {
        renderer.setForeground(this.myForeground);
        renderer.setBackground(this.myBackground);
        renderer.setFont(this.myFont);
        renderer.setBorder(this.myCellBorder);
    }

    protected void clear() {
        this.mySelected = false;
        this.myForeground = null;
        this.myBackground = null;
        this.myFont = null;
        this.myCellBorder = null;
    }

    public SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
        if (!this.mySelected) {
            return attributes;
        }
        return new SimpleTextAttributes(attributes.getStyle(), this.myForeground);
    }
}

