/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.NodeDescriptor;
import java.util.Comparator;

public class WeightBasedComparator
implements Comparator<NodeDescriptor> {
    public static final int UNDEFINED_WEIGHT = Integer.MIN_VALUE;
    private final boolean myCompareToString;
    public static final WeightBasedComparator INSTANCE = new WeightBasedComparator();
    public static final WeightBasedComparator FULL_INSTANCE = new WeightBasedComparator(true){

        @Override
        protected int compareWeights(int w1, int w2) {
            return w1 - w2;
        }
    };

    public WeightBasedComparator() {
        this(false);
    }

    public WeightBasedComparator(boolean compareToString) {
        this.myCompareToString = compareToString;
    }

    @Override
    public int compare(NodeDescriptor o1, NodeDescriptor o2) {
        int w1 = o1.getWeight();
        int w2 = o2.getWeight();
        if (this.myCompareToString && w1 == w2) {
            return WeightBasedComparator.compareToString(o1, o2);
        }
        int weights = this.compareWeights(w1, w2);
        return weights != 0 ? weights : o1.getIndex() - o2.getIndex();
    }

    protected int compareWeights(int w1, int w2) {
        return w2 - w1;
    }

    protected static int compareToString(NodeDescriptor first, NodeDescriptor second) {
        String s1 = first.toString();
        String s2 = second.toString();
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareToIgnoreCase(s2);
    }
}

