/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;

public class UsageViewTreeModelBuilder
extends DefaultTreeModel {
    private final RootGroupNode myRootNode = new RootGroupNode();
    private final DefaultMutableTreeNode myTargetsNode;
    private final UsageTarget[] myTargets;
    private UsageTargetNode[] myTargetNodes;
    private final String myTargetsNodeText;
    private final boolean myDetachedMode;

    public UsageViewTreeModelBuilder(UsageViewPresentation presentation, UsageTarget[] targets) {
        super(new DefaultMutableTreeNode("temp root"));
        this.setRoot(this.myRootNode);
        this.myTargets = targets;
        this.myTargetsNodeText = presentation.getTargetsNodeText();
        if (this.myTargetsNodeText != null) {
            this.myTargetsNode = new TargetsRootNode(this.myTargetsNodeText);
            this.addTargetNodes();
        } else {
            this.myTargetsNode = null;
        }
        this.myDetachedMode = presentation.isDetachedMode();
    }

    private void addTargetNodes() {
        if (this.myTargets.length == 0) {
            return;
        }
        this.myTargetNodes = new UsageTargetNode[this.myTargets.length];
        this.myTargetsNode.removeAllChildren();
        for (int i = 0; i < this.myTargets.length; ++i) {
            UsageTarget target = this.myTargets[i];
            UsageTargetNode targetNode = new UsageTargetNode(target, this);
            this.myTargetsNode.add(targetNode);
            this.myTargetNodes[i] = targetNode;
        }
        this.myRootNode.addNode(this.myTargetsNode);
    }

    public UsageNode getFirstUsageNode() {
        return (UsageNode)UsageViewTreeModelBuilder.getFirstChildOfType(this.myRootNode, UsageNode.class);
    }

    private static TreeNode getFirstChildOfType(TreeNode parent, Class type) {
        int childCount = parent.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            TreeNode child = parent.getChildAt(idx);
            if (type.isAssignableFrom(child.getClass())) {
                return child;
            }
            TreeNode firstChildOfType = UsageViewTreeModelBuilder.getFirstChildOfType(child, type);
            if (firstChildOfType == null) continue;
            return firstChildOfType;
        }
        return null;
    }

    public boolean areTargetsValid() {
        if (this.myTargetNodes == null) {
            return true;
        }
        for (UsageTargetNode targetNode : this.myTargetNodes) {
            if (targetNode.isValid()) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.myRootNode.removeAllChildren();
        if (this.myTargetsNodeText != null && this.myTargets.length > 0) {
            this.addTargetNodes();
        }
    }

    public boolean isDetachedMode() {
        return this.myDetachedMode;
    }

    private class RootGroupNode
    extends GroupNode {
        private RootGroupNode() {
            super(null, 0, UsageViewTreeModelBuilder.this);
        }

        public void addNode(final DefaultMutableTreeNode node) {
            if (!UsageViewTreeModelBuilder.this.myDetachedMode) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RootGroupNode.this.myTreeModel.insertNodeInto(node, RootGroupNode.this, RootGroupNode.this.getNodeInsertionIndex(node));
                    }
                });
            }
        }

        @Override
        @NonNls
        public String toString() {
            return "Root " + super.toString();
        }
    }

    public static class TargetsRootNode
    extends DefaultMutableTreeNode {
        public TargetsRootNode(String name) {
            super(name);
        }
    }
}

