/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomTarget
extends DelegatePsiTarget
implements PsiDeclaredTarget,
PomRenameableTarget {
    private final DomElement myDomElement;
    private final TextRange myRange;

    private DomTarget(DomElement domElement, PsiElement navigationElement, TextRange range) {
        super(navigationElement);
        this.myDomElement = domElement;
        this.myRange = range;
    }

    @Nullable
    public static DomTarget getTarget(@NotNull DomElement element) {
        XmlTag tag;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomTarget.getTarget must not be null");
        }
        GenericDomValue value = element.getGenericInfo().getNameDomElement(element);
        if (value == null) {
            return null;
        }
        if (value instanceof GenericAttributeValue) {
            GenericAttributeValue genericAttributeValue = (GenericAttributeValue)value;
            XmlAttributeValue attributeValue = genericAttributeValue.getXmlAttributeValue();
            if (attributeValue == null) {
                return null;
            }
            int length = attributeValue.getTextLength();
            if (length > 2) {
                return new DomTarget(element, attributeValue, new TextRange(1, length - 1));
            }
        }
        if ((tag = value.getXmlTag()) == null) {
            return null;
        }
        XmlTagValue tagValue = tag.getValue();
        if (StringUtil.isEmpty((String)tagValue.getTrimmedText())) {
            return null;
        }
        return new DomTarget(element, tag, XmlTagUtil.getTrimmedValueRange(tag));
    }

    @Override
    public TextRange getNameIdentifierRange() {
        return this.myRange;
    }

    @Override
    public boolean isWritable() {
        return this.getNavigationElement().isWritable();
    }

    public Object setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomTarget.setName must not be null");
        }
        ((GenericDomValue)ObjectUtils.assertNotNull((Object)this.myDomElement.getGenericInfo().getNameDomElement(this.myDomElement))).setStringValue(newName);
        return this.myDomElement;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myDomElement.getGenericInfo().getElementName(this.myDomElement);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DomTarget domTarget = (DomTarget)o;
        return !(this.myDomElement != null ? !this.myDomElement.equals(domTarget.myDomElement) : domTarget.myDomElement != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myDomElement != null ? this.myDomElement.hashCode() : 0);
        result = 31 * result + (this.myRange != null ? this.myRange.hashCode() : 0);
        return result;
    }

    public DomElement getDomElement() {
        return this.myDomElement;
    }
}

