/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.spellchecker.compress.UnitBitSet;
import com.intellij.util.Consumer;
import java.util.ArrayList;

public final class Compressor {
    public static int WORD_LENGTH = 8;
    public static byte TRANSITION_WORD = new Double(-Math.pow(2.0, WORD_LENGTH - 1)).byteValue();
    public final int skipFirst;

    public Compressor(int skipFirst) {
        this.skipFirst = skipFirst;
    }

    public UnitBitSet decompress(byte[] value) {
        UnitBitSet bs = new UnitBitSet(WORD_LENGTH - 1, true);
        int index = 0;
        byte bitsPerUnitInOrigin = value[this.skipFirst];
        for (int i = this.skipFirst + 1; i < value.length; ++i) {
            byte b = value[i];
            if (b > 0) {
                bs.setUnitValue(index++, b);
                continue;
            }
            int count = -TRANSITION_WORD + b;
            index = index + count + 1;
        }
        UnitBitSet result = UnitBitSet.create(bs, (int)bitsPerUnitInOrigin);
        result.moveRight(this.skipFirst);
        for (int i = 0; i < this.skipFirst; ++i) {
            result.setUnitValue(i, value[i]);
        }
        return result;
    }

    public byte[] compress(UnitBitSet origin) {
        if (origin == null) {
            return new byte[0];
        }
        final ArrayList words = new ArrayList();
        ArrayList<Byte> compressed = new ArrayList<Byte>();
        UnitBitSet copyOfOrigin = UnitBitSet.create(origin, origin.bitsPerUnit);
        for (int i = 0; i < this.skipFirst; ++i) {
            compressed.add(Integer.valueOf(copyOfOrigin.getUnitValue(i)).byteValue());
        }
        copyOfOrigin.moveLeft(this.skipFirst);
        compressed.add(Integer.valueOf(copyOfOrigin.bitsPerUnit).byteValue());
        UnitBitSet bs = UnitBitSet.create(copyOfOrigin, WORD_LENGTH - 1);
        bs.iterateParUnits(new Consumer<Integer>(){

            public void consume(Integer integer) {
                if (integer != 0) {
                    words.add(integer.byteValue());
                } else {
                    words.add(TRANSITION_WORD);
                }
            }
        }, 0, true);
        int count = -1;
        for (Byte word : words) {
            if (word == TRANSITION_WORD && count == -1) {
                ++count;
                continue;
            }
            if (word == TRANSITION_WORD && count > -1) {
                ++count;
                continue;
            }
            if (word != TRANSITION_WORD && count > -1) {
                while (count > 120) {
                    compressed.add((byte)(TRANSITION_WORD + 120));
                    count -= 121;
                }
                if (count > -1) {
                    compressed.add((byte)(TRANSITION_WORD + count));
                }
                compressed.add(word);
                count = -1;
                continue;
            }
            if (word == TRANSITION_WORD || count != -1) continue;
            compressed.add(word);
            count = -1;
        }
        byte[] result = new byte[compressed.size()];
        int i = 0;
        for (Byte word : compressed) {
            result[i++] = word;
        }
        return result;
    }
}

