/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.EncodingException;
import com.intellij.spellchecker.compress.UnitBitSet;
import com.intellij.util.Consumer;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public final class Encoder {
    private final Alphabet alphabet;
    private final int offset = 2;

    public Encoder() {
        this.alphabet = new Alphabet();
    }

    public Encoder(Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public UnitBitSet encode(@NotNull CharSequence letters, boolean force) throws EncodingException {
        if (letters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/compress/Encoder.encode must not be null");
        }
        UnitBitSet bs = new UnitBitSet(this.alphabet.getMaxIndex(), false);
        bs.setUnitValue(0, letters.length());
        bs.setUnitValue(1, this.alphabet.getIndex(Character.valueOf(letters.charAt(0)), force));
        for (int i = 0; i < letters.length(); ++i) {
            Character letter = Character.valueOf(letters.charAt(i));
            int index = this.alphabet.getIndex(letter, force);
            bs.setUnitValue(i + 2, index);
        }
        return bs;
    }

    public String decode(@NotNull UnitBitSet bitSet) throws EncodingException {
        if (bitSet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/compress/Encoder.decode must not be null");
        }
        int wordLength = bitSet.getUnitValue(0);
        Character firstLetter = this.alphabet.getLetter(bitSet.getUnitValue(1));
        final StringBuffer result = new StringBuffer();
        bitSet.iterateParUnits(new Consumer<Integer>(){

            public void consume(Integer value) {
                if (value > 0 && value <= Encoder.this.alphabet.getLastIndexUsed()) {
                    result.append(Encoder.this.alphabet.getLetter(value));
                }
            }
        }, 2, true);
        String word = result.toString();
        if (word.length() != wordLength || !word.startsWith(String.valueOf(firstLetter))) {
            throw new EncodingException(new MessageFormat("Error during encoding: required length - {0}, starts with {1}, but decoded: {2}").format(new Object[]{wordLength, firstLetter, word}));
        }
        return word;
    }
}

