/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.CheckArea;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.SplitterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentSplitter
extends BaseSplitter {
    private static final Pattern HTML = Pattern.compile("<(\\S+?).*?>(.*?)</\\1>");

    @Override
    public List<CheckArea> split(@Nullable String text, @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/CommentSplitter.split must not be null");
        }
        if (text == null || StringUtil.isEmpty((String)text)) {
            return null;
        }
        List<TextRange> toCheck = CommentSplitter.excludeByPattern(text, range, HTML, 2);
        if (toCheck == null) {
            return null;
        }
        Splitter ps = SplitterFactory.getInstance().getPlainTextSplitter();
        ArrayList<CheckArea> results = new ArrayList<CheckArea>();
        for (TextRange r : toCheck) {
            List<CheckArea> res = ps.split(text, r);
            if (res == null) continue;
            results.addAll(res);
        }
        return results.size() == 0 ? null : results;
    }
}

