/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.spellchecker.tokenizer.CommentTokenizer;
import com.intellij.spellchecker.tokenizer.PsiIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.TextTokenizer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.XmlAttributeTokenizer;
import com.intellij.spellchecker.tokenizer.XmlTextTokenizer;
import org.jetbrains.annotations.NotNull;

public class SpellcheckingStrategy {
    public static final ExtensionPointName<SpellcheckingStrategy> EP_NAME = ExtensionPointName.create((String)"com.intellij.spellchecker.support");
    public static final Tokenizer EMPTY_TOKENIZER = new Tokenizer();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        Tokenizer tokenizer;
        if (element instanceof PsiNameIdentifierOwner) {
            tokenizer = new PsiIdentifierOwnerTokenizer();
            if (tokenizer == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/tokenizer/SpellcheckingStrategy.getTokenizer must not return null");
            return tokenizer;
        }
        if (element instanceof PsiComment) {
            tokenizer = new CommentTokenizer();
            if (tokenizer == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/tokenizer/SpellcheckingStrategy.getTokenizer must not return null");
            return tokenizer;
        }
        if (element instanceof XmlAttributeValue) {
            tokenizer = new XmlAttributeTokenizer();
            if (tokenizer == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/tokenizer/SpellcheckingStrategy.getTokenizer must not return null");
            return tokenizer;
        }
        if (element instanceof XmlText) {
            tokenizer = new XmlTextTokenizer();
            if (tokenizer == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/tokenizer/SpellcheckingStrategy.getTokenizer must not return null");
            return tokenizer;
        }
        if (element instanceof PsiPlainText) {
            tokenizer = new TextTokenizer();
            if (tokenizer == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/tokenizer/SpellcheckingStrategy.getTokenizer must not return null");
            return tokenizer;
        }
        tokenizer = EMPTY_TOKENIZER;
        if (tokenizer != null) return tokenizer;
        throw new IllegalStateException("@NotNull method com/intellij/spellchecker/tokenizer/SpellcheckingStrategy.getTokenizer must not return null");
    }

    @NotNull
    public Language getLanguage() {
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        if (plainTextLanguage == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/tokenizer/SpellcheckingStrategy.getLanguage must not return null");
        }
        return plainTextLanguage;
    }
}

