/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunJavaConfiguration;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitProcessHandler;
import com.intellij.execution.junit.TestClass;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.segments.DeferredActionsQueue;
import com.intellij.execution.junit2.segments.DeferredActionsQueueImpl;
import com.intellij.execution.junit2.segments.DispatchListener;
import com.intellij.execution.junit2.ui.JUnitTreeConsoleView;
import com.intellij.execution.junit2.ui.TestsPacketsReceiver;
import com.intellij.execution.junit2.ui.actions.RerunFailedTestsAction;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.ExternalOutput;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.util.Function;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class TestObject
implements JavaCommandLine {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit.TestObject");
    private static final String MESSAGE = ExecutionBundle.message((String)"configuration.not.speficied.message", (Object[])new Object[0]);
    protected JavaParameters myJavaParameters;
    private final Project myProject;
    protected final JUnitConfiguration myConfiguration;
    private final RunnerSettings myRunnerSettings;
    private final ConfigurationPerRunnerSettings myConfigurationSettings;
    protected File myTempFile = null;
    public File myListenersFile;
    private static final TestObject NOT_CONFIGURED = new TestObject(null, null, null, null){

        @Override
        public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
            return null;
        }

        @Override
        public String suggestActionName() {
            throw new RuntimeException(String.valueOf((Object)this.myConfiguration));
        }

        @Override
        public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiElement element) {
            return false;
        }

        @Override
        public void checkConfiguration() throws RuntimeConfigurationException {
            throw new RuntimeConfigurationError(MESSAGE);
        }

        public ExecutionResult execute() throws ExecutionException {
            throw TestObject.createExecutionException();
        }

        @Override
        public JavaParameters getJavaParameters() throws ExecutionException {
            throw TestObject.createExecutionException();
        }

        @Override
        protected void initialize() throws ExecutionException {
            throw TestObject.createExecutionException();
        }

        protected ProcessHandler startProcess() throws ExecutionException {
            throw TestObject.createExecutionException();
        }
    };

    public static TestObject fromString(String id, Project project, JUnitConfiguration configuration, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        if ("method".equals(id)) {
            return new TestMethod(project, configuration, runnerSettings, configurationSettings);
        }
        if ("class".equals(id)) {
            return new TestClass(project, configuration, runnerSettings, configurationSettings);
        }
        if ("package".equals(id)) {
            return new TestPackage(project, configuration, runnerSettings, configurationSettings);
        }
        return NOT_CONFIGURED;
    }

    public Module[] getModulesToCompile() {
        SourceScope sourceScope = this.getSourceScope();
        return sourceScope != null ? sourceScope.getModulesToCompile() : Module.EMPTY_ARRAY;
    }

    protected TestObject(Project project, JUnitConfiguration configuration, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        this.myProject = project;
        this.myConfiguration = configuration;
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationSettings = configurationSettings;
    }

    public abstract String suggestActionName();

    public RunnerSettings getRunnerSettings() {
        return this.myRunnerSettings;
    }

    public ConfigurationPerRunnerSettings getConfigurationSettings() {
        return this.myConfigurationSettings;
    }

    public abstract RefactoringElementListener getListener(PsiElement var1, JUnitConfiguration var2);

    public abstract boolean isConfiguredByElement(JUnitConfiguration var1, PsiElement var2);

    protected void configureModule(JavaParameters parameters, RunConfigurationModule configurationModule, String mainClassName) throws CantRunException {
        int classPathType = JavaParametersUtil.getClasspathType((RunConfigurationModule)configurationModule, (String)mainClassName, (boolean)true);
        JavaParametersUtil.configureModule((RunConfigurationModule)configurationModule, (JavaParameters)parameters, (int)classPathType, this.myConfiguration.isAlternativeJrePathEnabled() ? this.myConfiguration.getAlternativeJrePath() : null);
    }

    private static ExecutionException createExecutionException() {
        return new ExecutionException(MESSAGE);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.myConfiguration.isAlternativeJrePathEnabled() && (this.myConfiguration.getAlternativeJrePath() == null || this.myConfiguration.getAlternativeJrePath().length() == 0 || !JavaSdk.checkForJre((String)this.myConfiguration.getAlternativeJrePath()))) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.mesage", (Object[])new Object[]{this.myConfiguration.getAlternativeJrePath()}));
        }
    }

    public SourceScope getSourceScope() {
        return SourceScope.modulesWithDependencies((Module[])this.myConfiguration.getModules());
    }

    protected void initialize() throws ExecutionException {
        this.myJavaParameters.setupEnvs(this.myConfiguration.getPersistentData().getEnvs(), this.myConfiguration.getPersistentData().PASS_PARENT_ENVS);
        JavaParametersUtil.configureConfiguration((JavaParameters)this.myJavaParameters, (RunJavaConfiguration)this.myConfiguration);
        this.myJavaParameters.setMainClass("com.intellij.rt.execution.junit.JUnitStarter");
        Module module = ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getModule();
        if (this.myJavaParameters.getJdk() == null) {
            this.myJavaParameters.setJdk(module != null ? ModuleRootManager.getInstance((Module)module).getSdk() : ProjectRootManager.getInstance((Project)this.myProject).getProjectJdk());
        }
        this.myJavaParameters.getClassPath().add(JavaSdkUtil.getIdeaRtJarPath());
        this.myJavaParameters.getClassPath().add(PathUtil.getJarPathForClass(JUnitStarter.class));
        this.myJavaParameters.getProgramParametersList().add("-ideVersion5");
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
            ext.updateJavaParameters((ModuleBasedConfiguration)this.myConfiguration, this.myJavaParameters, this.myRunnerSettings);
        }
        Object[] listeners = Extensions.getExtensions((String)"com.intellij.junitListener");
        StringBuffer buf = new StringBuffer();
        for (Object listener : listeners) {
            boolean enabled = true;
            for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
                if (!ext.isListenerDisabled((ModuleBasedConfiguration)this.myConfiguration, listener)) continue;
                enabled = false;
                break;
            }
            if (!enabled) continue;
            Class<?> classListener = listener.getClass();
            buf.append(classListener.getName()).append("\n");
            this.myJavaParameters.getClassPath().add(PathUtil.getJarPathForClass(classListener));
        }
        if (buf.length() > 0) {
            try {
                this.myListenersFile = FileUtil.createTempFile((String)"junitlisteners", (String)"");
                this.myListenersFile.deleteOnExit();
                this.myJavaParameters.getProgramParametersList().add("@@" + this.myListenersFile.getPath());
                FileUtil.writeToFile((File)this.myListenersFile, (byte[])buf.toString().getBytes());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myJavaParameters == null) {
            Object[] patchers;
            this.myJavaParameters = new JavaParameters();
            this.initialize();
            Module module = ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getModule();
            for (Object patcher : patchers = Extensions.getExtensions((String)"com.intellij.junitPatcher")) {
                ((JUnitPatcher)patcher).patchJavaParameters(module, this.myJavaParameters);
            }
        }
        return this.myJavaParameters;
    }

    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/junit/TestObject.execute must not be null");
        }
        final JUnitProcessHandler handler = JUnitProcessHandler.runJava((JavaParameters)this.getJavaParameters(), (Project)this.myProject);
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
            ext.handleStartProcess((ModuleBasedConfiguration)this.myConfiguration, (OSProcessHandler)handler);
        }
        final JUnitConsoleProperties consoleProperties = new JUnitConsoleProperties(this.myConfiguration);
        final JUnitTreeConsoleView consoleView = new JUnitTreeConsoleView(consoleProperties, this.getRunnerSettings(), this.getConfigurationSettings());
        consoleView.initUI();
        consoleView.attachToProcess((ProcessHandler)handler);
        final TestsPacketsReceiver packetsReceiver = new TestsPacketsReceiver(consoleView){

            @Override
            public void notifyStart(TestProxy root) {
                super.notifyStart(root);
                JUnitRunningModel model = this.getModel();
                if (model != null) {
                    handler.getOut().setDispatchListener((DispatchListener)model.getNotifier());
                    Disposer.register((Disposable)model, (Disposable)new Disposable(){

                        public void dispose() {
                            handler.getOut().setDispatchListener(DispatchListener.DEAF);
                        }
                    });
                    consoleView.attachToModel(model);
                }
            }
        };
        DeferredActionsQueueImpl queue = new DeferredActionsQueueImpl();
        handler.getOut().setPacketDispatcher((PacketProcessor)packetsReceiver, (DeferredActionsQueue)queue);
        handler.getErr().setPacketDispatcher((PacketProcessor)packetsReceiver, (DeferredActionsQueue)queue);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                handler.removeProcessListener((ProcessListener)this);
                if (TestObject.this.myTempFile != null) {
                    FileUtil.delete((File)TestObject.this.myTempFile);
                }
                if (TestObject.this.myListenersFile != null) {
                    FileUtil.delete((File)TestObject.this.myListenersFile);
                }
                IJSwingUtilities.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        packetsReceiver.checkTerminated();
                        JUnitRunningModel model = packetsReceiver.getModel();
                        TestsUIUtil.notifyByBalloon((Project)TestObject.this.myProject, (AbstractTestProxy)(model != null ? model.getRoot() : null), (TestConsoleProperties)consoleProperties, (Filter)Filter.DEFECTIVE_LEAF);
                    }
                });
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                ConsoleViewContentType consoleViewType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                TestProxy currentTest = packetsReceiver.getCurrentTest();
                if (currentTest != null) {
                    currentTest.onOutput(text, consoleViewType);
                } else {
                    consoleView.getPrinter().onNewAvailable((Printable)new ExternalOutput(text, consoleViewType));
                }
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new DefaultExecutionResult(null, (ProcessHandler)handler);
        }
        RerunFailedTestsAction rerunFailedTestsAction = new RerunFailedTestsAction(consoleView.getComponent());
        rerunFailedTestsAction.init((TestConsoleProperties)consoleProperties, this.myRunnerSettings, this.myConfigurationSettings);
        rerunFailedTestsAction.setModelProvider((Getter)new Getter<TestFrameworkRunningModel>(){

            public TestFrameworkRunningModel get() {
                return packetsReceiver.getModel();
            }
        });
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)handler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void addClassesListToJavaParameters(Collection<? extends T> elements, Function<T, String> nameFunction, String packageName, boolean createTempFile, boolean junit4) {
        try {
            if (createTempFile) {
                this.myTempFile = File.createTempFile("idea_junit", ".tmp");
                this.myTempFile.deleteOnExit();
                this.myJavaParameters.getProgramParametersList().add("@" + this.myTempFile.getAbsolutePath());
            }
            PrintWriter writer = new PrintWriter(new FileWriter(this.myTempFile));
            try {
                writer.println(junit4 ? "-junit4" : "-junit3");
                writer.println(packageName);
                ArrayList<String> testNames = new ArrayList<String>();
                for (T element : elements) {
                    String name = (String)nameFunction.fun(element);
                    if (name == null) {
                        LOG.error("invalid element " + element);
                        return;
                    }
                    testNames.add(name);
                }
                Collections.sort(testNames);
                for (String testName : testNames) {
                    writer.println(testName);
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void clear() {
        this.myJavaParameters = null;
    }
}

