/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JUnitConfigurationModel {
    public static final int ALL_IN_PACKAGE = 0;
    public static final int CLASS = 1;
    public static final int METHOD = 2;
    private static final List<String> ourTestObjects = Arrays.asList("package", "class", "method");
    private JUnitConfigurable myListener;
    private int myType = -1;
    private final Document[] myJUnitDocuments = new Document[3];
    private final Project myProject;

    public JUnitConfigurationModel(Project project) {
        for (int i = 0; i < this.myJUnitDocuments.length; ++i) {
            this.myJUnitDocuments[i] = new PlainDocument();
        }
        this.myProject = project;
    }

    public void setType(int type) {
        if (type == this.myType) {
            return;
        }
        if (type < 0 || type >= ourTestObjects.size()) {
            type = 1;
        }
        this.myType = type;
        this.fireTypeChanged(type);
    }

    private void fireTypeChanged(int newType) {
        this.myListener.onTypeChanged(newType);
    }

    public void setListener(JUnitConfigurable listener) {
        this.myListener = listener;
    }

    public Document getJUnitDocument(int i) {
        return this.myJUnitDocuments[i];
    }

    public void apply(Module module, JUnitConfiguration configuration) {
        boolean shouldUpdateName = configuration.isGeneratedName();
        this.applyTo(configuration.getPersistentData(), module);
        if (shouldUpdateName && !JavaExecutionUtil.isNewName((String)configuration.getName())) {
            configuration.setGeneratedName();
        }
    }

    private void applyTo(JUnitConfiguration.Data data, Module module) {
        String testObject = this.getTestObject();
        String className = this.getJUnitTextValue(1);
        data.TEST_OBJECT = testObject;
        if (testObject != "package") {
            PsiClass testClass = JUnitUtil.findPsiClass((String)className, (Module)module, (Project)this.myProject);
            data.METHOD_NAME = this.getJUnitTextValue(2);
            if (testClass != null && testClass.isValid()) {
                data.setMainClass(testClass);
            } else {
                data.MAIN_CLASS_NAME = className;
            }
        } else {
            data.PACKAGE_NAME = this.getJUnitTextValue(0);
            data.MAIN_CLASS_NAME = "";
            data.METHOD_NAME = "";
        }
    }

    private String getTestObject() {
        return ourTestObjects.get(this.myType);
    }

    private String getJUnitTextValue(int index) {
        return JUnitConfigurationModel.getDocumentText(index, this.myJUnitDocuments);
    }

    private static String getDocumentText(int index, Document[] documents) {
        Document document = documents[index];
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset(JUnitConfiguration configuration) {
        JUnitConfiguration.Data data = configuration.getPersistentData();
        this.setTestType(data.TEST_OBJECT);
        this.setJUnitTextValue(0, data.getPackageName());
        this.setJUnitTextValue(1, data.getMainClassName());
        this.setJUnitTextValue(2, data.getMethodName());
    }

    private void setJUnitTextValue(int index, String text) {
        JUnitConfigurationModel.setDocumentText(index, text, this.myJUnitDocuments);
    }

    private static void setDocumentText(int index, String text, Document[] documents) {
        Document document = documents[index];
        try {
            document.remove(0, document.getLength());
            document.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void setTestType(String testObject) {
        this.setType(ourTestObjects.indexOf(testObject));
    }
}

