/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.states;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.TestProxyListener;
import com.intellij.execution.junit2.states.CumulativeStatistics;
import com.intellij.execution.junit2.states.Statistics;
import com.intellij.execution.junit2.states.TestState;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SuiteState
extends TestState {
    private final TestProxy myTest;
    private int myMaxMagnitude = 2;
    private boolean myHasRunning;
    private final StateCache myCache = new StateCache();
    private static final CachedAcpect<List<TestProxy>> ALL_TESTS = new CachedAcpect<List<TestProxy>>(){

        @Override
        public List<TestProxy> calculate(SuiteState state) {
            ArrayList<TestProxy> allTests = new ArrayList<TestProxy>();
            state.myTest.collectAllTestsTo(allTests);
            return allTests;
        }
    };
    private static final CachedAcpect<Statistics> GET_STATISTICS = new CachedAcpect<Statistics>(){

        @Override
        public Statistics calculate(SuiteState state) {
            CumulativeStatistics result = new CumulativeStatistics();
            for (TestProxy testCase : state.myTest.getChildren()) {
                result.add(testCase.getStatistics());
            }
            return result;
        }
    };
    private static final CachedAcpect<Boolean> IS_IN_PROGRESS = new CachedAcpect<Boolean>(){

        @Override
        public Boolean calculate(SuiteState state) {
            for (TestProxy proxy : state.myTest.getChildren()) {
                if (!proxy.isInProgress()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    };

    public SuiteState(TestProxy test) {
        this.myTest = test;
        this.myTest.addListener(new TestProxyListener(){

            @Override
            public void onChildAdded(AbstractTestProxy testProxy, AbstractTestProxy newChild) {
                if (newChild.getParent() == SuiteState.this.myTest) {
                    SuiteState.this.myCache.invalidate();
                }
            }

            @Override
            public void onChanged(AbstractTestProxy test) {
                if (test == SuiteState.this.myTest) {
                    SuiteState.this.myCache.invalidate();
                }
            }

            @Override
            public void onStatisticsChanged(AbstractTestProxy test) {
                if (test == SuiteState.this.myTest) {
                    SuiteState.this.myCache.invalidate();
                }
            }
        });
    }

    @Override
    public int getMagnitude() {
        return this.myHasRunning ? 3 : this.myMaxMagnitude;
    }

    @Override
    public void update() {
        this.myCache.invalidate();
    }

    public void printOn(Printer printer) {
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isDefect() {
        return this.getMagnitude() >= 6;
    }

    @Override
    public boolean isInProgress() {
        return this.myCache.get(IS_IN_PROGRESS);
    }

    @Override
    public Statistics getStatisticsFor(TestProxy test) {
        return this.myCache.get(GET_STATISTICS);
    }

    @Override
    public List<TestProxy> getAllTestsOf(TestProxy test) {
        return this.myCache.get(ALL_TESTS);
    }

    @Override
    public void changeStateAfterAddingChildTo(TestProxy test, TestProxy child) {
        if (child.getState().getMagnitude() <= this.getMagnitude()) {
            test.onStatisticsChanged();
            return;
        }
        test.onChanged((AbstractTestProxy)test);
    }

    public void setRunning(boolean running) {
        this.myHasRunning = running;
    }

    public void updateMagnitude(int magnitude) {
        if (this.myMaxMagnitude == 2) {
            this.myMaxMagnitude = magnitude;
        } else if (this.myMaxMagnitude < magnitude) {
            this.myMaxMagnitude = magnitude;
        }
    }

    private class StateCache {
        private final Object[] myValues = new Object[3];

        private StateCache() {
        }

        public <T> T get(CachedAcpect<T> aspect) {
            int id = aspect.getId();
            Object value = this.myValues[id];
            if (value == null) {
                this.myValues[id] = value = aspect.calculate(SuiteState.this);
            }
            return (T)value;
        }

        public void invalidate() {
            Arrays.fill(this.myValues, null);
        }
    }

    private static abstract class CachedAcpect<T> {
        private static int ourNextInstanceIndex = 0;
        private final int myId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CachedAcpect() {
            Class<CachedAcpect> clazz = CachedAcpect.class;
            synchronized (CachedAcpect.class) {
                this.myId = ourNextInstanceIndex++;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public abstract T calculate(SuiteState var1);

        public int getId() {
            return this.myId;
        }
    }
}

