/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import org.jetbrains.annotations.NotNull;

class ComplexityVisitor
extends JavaRecursiveElementVisitor {
    private int m_complexity = 1;

    ComplexityVisitor() {
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ComplexityVisitor.visitAnonymousClass must not be null");
        }
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ComplexityVisitor.visitForStatement must not be null");
        }
        super.visitForStatement(statement);
        ++this.m_complexity;
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ComplexityVisitor.visitForeachStatement must not be null");
        }
        super.visitForeachStatement(statement);
        ++this.m_complexity;
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ComplexityVisitor.visitIfStatement must not be null");
        }
        super.visitIfStatement(statement);
        ++this.m_complexity;
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ComplexityVisitor.visitDoWhileStatement must not be null");
        }
        super.visitDoWhileStatement(statement);
        ++this.m_complexity;
    }

    public void visitConditionalExpression(PsiConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        ++this.m_complexity;
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ComplexityVisitor.visitSwitchStatement must not be null");
        }
        super.visitSwitchStatement(statement);
        PsiCodeBlock body = statement.getBody();
        if (body == null) {
            return;
        }
        PsiStatement[] statements = body.getStatements();
        boolean pendingLabel = false;
        for (PsiStatement child : statements) {
            if (child instanceof PsiSwitchLabelStatement) {
                if (!pendingLabel) {
                    ++this.m_complexity;
                }
                pendingLabel = true;
                continue;
            }
            pendingLabel = false;
        }
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/ComplexityVisitor.visitWhileStatement must not be null");
        }
        super.visitWhileStatement(statement);
        ++this.m_complexity;
    }

    public int getComplexity() {
        return this.m_complexity;
    }

    public void reset() {
        this.m_complexity = 1;
    }
}

