/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class VariableUsedInInnerClassVisitor
extends JavaRecursiveElementVisitor {
    private final PsiVariable variable;
    private boolean usedInInnerClass = false;
    private boolean inInnerClass = false;

    VariableUsedInInnerClassVisitor(PsiVariable variable) {
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/VariableUsedInInnerClassVisitor.visitElement must not be null");
        }
        if (this.usedInInnerClass) {
            return;
        }
        super.visitElement(element);
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass psiAnonymousClass) {
        if (psiAnonymousClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/VariableUsedInInnerClassVisitor.visitAnonymousClass must not be null");
        }
        if (this.usedInInnerClass) {
            return;
        }
        boolean wasInInnerClass = this.inInnerClass;
        this.inInnerClass = true;
        super.visitAnonymousClass(psiAnonymousClass);
        this.inInnerClass = wasInInnerClass;
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
        PsiElement element;
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/VariableUsedInInnerClassVisitor.visitReferenceExpression must not be null");
        }
        if (this.usedInInnerClass) {
            return;
        }
        super.visitReferenceExpression(reference);
        if (this.inInnerClass && this.variable.equals(element = reference.resolve())) {
            this.usedInInnerClass = true;
        }
    }

    public boolean isUsedInInnerClass() {
        return this.usedInInnerClass;
    }
}

