/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NestedTryStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.try.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/NestedTryStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.try.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/NestedTryStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedTryStatementVisitor();
    }

    private static class NestedTryStatementVisitor
    extends BaseInspectionVisitor {
        private NestedTryStatementVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/NestedTryStatementInspection$NestedTryStatementVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            PsiTryStatement parentTry = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiTryStatement.class);
            if (parentTry == null) {
                return;
            }
            PsiCodeBlock tryBlock = parentTry.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)statement, (boolean)true)) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            PsiMethod containingContainingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parentTry, PsiMethod.class);
            if (containingMethod == null || containingContainingMethod == null || !containingMethod.equals(containingContainingMethod)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

