/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonFinalFieldOfExceptionInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.final.field.of.exception.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/NonFinalFieldOfExceptionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.final.field.of.exception.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/NonFinalFieldOfExceptionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonFinalFieldOfExceptionVisitor();
    }

    private static class NonFinalFieldOfExceptionVisitor
    extends BaseInspectionVisitor {
        private NonFinalFieldOfExceptionVisitor() {
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            if (field.hasModifierProperty("final")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!ClassUtils.isSubclass(containingClass, "java.lang.Exception")) {
                return;
            }
            this.registerFieldError(field, field);
        }
    }
}

