/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class OverriddenMethodCallDuringObjectConstructionInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overridden.method.call.in.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverriddenMethodCallDuringObjectConstructionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overridden.method.call.in.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverriddenMethodCallDuringObjectConstructionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverriddenMethodCallInConstructorVisitor();
    }

    private static class OverriddenMethodCallInConstructorVisitor
    extends BaseInspectionVisitor {
        private OverriddenMethodCallInConstructorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression;
            PsiExpression qualifier;
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/initialization/OverriddenMethodCallDuringObjectConstructionInspection$OverriddenMethodCallInConstructorVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(call);
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)call, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class});
            if (member instanceof PsiClassInitializer) {
                PsiClassInitializer classInitializer = (PsiClassInitializer)member;
                if (classInitializer.hasModifierProperty("static")) {
                    return;
                }
            } else if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                if (!OverriddenMethodCallInConstructorVisitor.isObjectConstructionMethod(method)) {
                    return;
                }
            } else {
                return;
            }
            if ((qualifier = (methodExpression = call.getMethodExpression()).getQualifierExpression()) != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return;
            }
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null || containingClass.hasModifierProperty("final")) {
                return;
            }
            PsiMethod calledMethod = (PsiMethod)methodExpression.resolve();
            if (calledMethod == null || !PsiUtil.canBeOverriden((PsiMethod)calledMethod)) {
                return;
            }
            PsiClass calledMethodClass = calledMethod.getContainingClass();
            if (!InheritanceUtil.isCorrectDescendant((PsiClass)containingClass, (PsiClass)calledMethodClass, (boolean)true)) {
                return;
            }
            if (!MethodUtils.isOverriddenInHierarchy(calledMethod, containingClass)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        public static boolean isObjectConstructionMethod(PsiMethod method) {
            if (method.isConstructor()) {
                return true;
            }
            if (CloneUtils.isClone(method)) {
                return true;
            }
            if (MethodUtils.simpleMethodMatches(method, null, "void", "readObject", "java.io.ObjectInputStream")) {
                return true;
            }
            return MethodUtils.simpleMethodMatches(method, null, "void", "readObjectNoData", new String[0]);
        }
    }
}

