/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class EnumAsNameInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("EnumAsIdentifier" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/EnumAsNameInspection.getID must not return null");
        }
        return "EnumAsIdentifier";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.enum.as.identifier.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/EnumAsNameInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.enum.as.identifier.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/EnumAsNameInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EnumAsNameVisitor();
    }

    private static class EnumAsNameVisitor
    extends BaseInspectionVisitor {
        private EnumAsNameVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk/EnumAsNameInspection$EnumAsNameVisitor.visitVariable must not be null");
            }
            super.visitVariable(variable);
            String variableName = variable.getName();
            if (!"enum".equals(variableName)) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk/EnumAsNameInspection$EnumAsNameVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            String name = method.getName();
            if (!"enum".equals(name)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk/EnumAsNameInspection$EnumAsNameVisitor.visitClass must not be null");
            }
            String name = aClass.getName();
            if (!"enum".equals(name)) {
                return;
            }
            PsiTypeParameterList params = aClass.getTypeParameterList();
            if (params != null) {
                params.accept((PsiElementVisitor)this);
            }
            this.registerClassError(aClass, new Object[0]);
        }

        public void visitTypeParameter(PsiTypeParameter parameter) {
            super.visitTypeParameter(parameter);
            String name = parameter.getName();
            if (!"enum".equals(name)) {
                return;
            }
            this.registerTypeParameterError(parameter, new Object[0]);
        }
    }
}

