/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ForeachStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("extended.for.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/ForeachStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("extended.for.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/ForeachStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ForEachFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForeachStatementVisitor();
    }

    private static class ForeachStatementVisitor
    extends BaseInspectionVisitor {
        private ForeachStatementVisitor() {
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk/ForeachStatementInspection$ForeachStatementVisitor.visitForeachStatement must not be null");
            }
            super.visitForeachStatement(statement);
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }

    private static class ForEachFix
    extends InspectionGadgetsFix {
        private ForEachFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("extended.for.statement.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/ForeachStatementInspection$ForEachFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiForeachStatement statement = (PsiForeachStatement)element.getParent();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            assert (statement != null);
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            StringBuffer newStatement = new StringBuffer();
            PsiParameter iterationParameter = statement.getIterationParameter();
            if (iteratedValue.getType() instanceof PsiArrayType) {
                PsiType type = iterationParameter.getType();
                String index = codeStyleManager.suggestUniqueVariableName("i", (PsiElement)statement, true);
                newStatement.append("for(int ");
                newStatement.append(index);
                newStatement.append(" = 0;");
                newStatement.append(index);
                newStatement.append('<');
                newStatement.append(iteratedValue.getText());
                newStatement.append(".length;");
                newStatement.append(index);
                newStatement.append("++)");
                newStatement.append("{ ");
                newStatement.append(type.getCanonicalText());
                newStatement.append(' ');
                newStatement.append(iterationParameter.getName());
                newStatement.append(" = ");
                newStatement.append(iteratedValue.getText());
                newStatement.append('[');
                newStatement.append(index);
                newStatement.append("];");
            } else {
                PsiType type;
                PsiType iteratedType = iteratedValue.getType();
                if (iteratedType instanceof PsiClassType) {
                    PsiClassType classType = (PsiClassType)iteratedType;
                    PsiType[] types = classType.getParameters();
                    type = types[0];
                } else {
                    type = iterationParameter.getType();
                }
                String iterator = codeStyleManager.suggestUniqueVariableName("it", (PsiElement)statement, true);
                String typeText = type.getCanonicalText();
                newStatement.append("for(java.util.Iterator<");
                newStatement.append(typeText);
                newStatement.append("> ");
                newStatement.append(iterator);
                newStatement.append(" = ");
                newStatement.append(iteratedValue.getText());
                newStatement.append(".iterator();");
                newStatement.append(iterator);
                newStatement.append(".hasNext();)");
                newStatement.append('{');
                newStatement.append(typeText);
                newStatement.append(' ');
                newStatement.append(iterationParameter.getName());
                newStatement.append(" = ");
                newStatement.append(iterator);
                newStatement.append(".next();");
            }
            PsiStatement body = statement.getBody();
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                PsiElement[] children = block.getChildren();
                for (int i = 1; i < children.length - 1; ++i) {
                    newStatement.append(children[i].getText());
                }
            } else {
                String bodyText = body == null ? "" : body.getText();
                newStatement.append(bodyText);
            }
            newStatement.append('}');
            ForEachFix.replaceStatement((PsiStatement)statement, newStatement.toString());
        }
    }
}

