/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assertequals.between.inconvertible.types.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/AssertEqualsBetweenInconvertibleTypesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType comparedType = (PsiType)infos[0];
        PsiType comparisonType = (PsiType)infos[1];
        String comparedTypeText = comparedType.getPresentableText();
        String comparisonTypeText = comparisonType.getPresentableText();
        String string = InspectionGadgetsBundle.message("assertequals.between.inconvertible.types.problem.descriptor", StringUtil.escapeXml((String)comparedTypeText), StringUtil.escapeXml((String)comparisonTypeText));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/AssertEqualsBetweenInconvertibleTypesInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsBetweenInconvertibleTypesVisitor();
    }

    private static class AssertEqualsBetweenInconvertibleTypesVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiPrimitiveType primitiveType;
            PsiClassType boxedType;
            PsiType parameterType2;
            int argumentIndex;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/AssertEqualsBetweenInconvertibleTypesInspection$AssertEqualsBetweenInconvertibleTypesVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"assertEquals".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!ClassUtils.isSubclass(containingClass, "junit.framework.Assert") && !ClassUtils.isSubclass(containingClass, "org.junit.Assert")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length < 2) {
                return;
            }
            PsiType firstParameterType = parameters[0].getType();
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (firstParameterType.equalsToText("java.lang.String")) {
                if (arguments.length < 3) {
                    return;
                }
                argumentIndex = 1;
            } else {
                if (arguments.length < 2) {
                    return;
                }
                argumentIndex = 0;
            }
            PsiExpression expression1 = arguments[argumentIndex];
            PsiExpression expression2 = arguments[argumentIndex + 1];
            PsiType type1 = expression1.getType();
            if (type1 == null) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            PsiType parameterType1 = parameters[argumentIndex].getType();
            if (!parameterType1.equals(parameterType2 = parameters[argumentIndex + 1].getType())) {
                return;
            }
            PsiManager manager = PsiManager.getInstance((Project)expression.getProject());
            GlobalSearchScope scope = expression.getResolveScope();
            if (type2 instanceof PsiPrimitiveType && parameterType2.equals(PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope)) && (boxedType = (primitiveType = (PsiPrimitiveType)type2).getBoxedType(manager, scope)) != null && TypeConversionUtil.areTypesConvertible((PsiType)type1, (PsiType)boxedType)) {
                return;
            }
            if (TypeConversionUtil.areTypesConvertible((PsiType)type1, (PsiType)type2)) {
                return;
            }
            this.registerMethodCallError(expression, type1, type2);
        }
    }
}

