/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JUnit4AnnotatedMethodInJUnit3TestCaseInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit4.test.method.in.class.extending.junit3.testcase.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("junit4.test.method.in.class.extending.junit3.testcase.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection.buildErrorString must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray;
        String className = (String)infos[0];
        if (className != null) {
            inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RemoveTestAnnotationFix(), new RemoveExtendsTestCaseFix(className)};
            if (inspectionGadgetsFixArray == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection.buildFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RemoveTestAnnotationFix()};
        if (inspectionGadgetsFixArray != null) return inspectionGadgetsFixArray;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection.buildFixes must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Junit4AnnotatedMethodInJunit3TestCaseVisitor();
    }

    private static class Junit4AnnotatedMethodInJunit3TestCaseVisitor
    extends BaseInspectionVisitor {
        private Junit4AnnotatedMethodInJunit3TestCaseVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!TestUtils.isJUnit4TestMethod(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!TestUtils.isJUnitTestClass(containingClass)) {
                return;
            }
            String className = containingClass.getName();
            this.registerMethodError(method, className);
        }
    }

    private static class RemoveTestAnnotationFix
    extends InspectionGadgetsFix {
        private RemoveTestAnnotationFix() {
        }

        @NotNull
        public String getName() {
            if ("Remove @Test annotation" == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$RemoveTestAnnotationFix.getName must not return null");
            }
            return "Remove @Test annotation";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiModifierListOwner)) {
                return;
            }
            PsiModifierListOwner method = (PsiModifierListOwner)parent;
            PsiModifierList modifierList = method.getModifierList();
            if (modifierList == null) {
                return;
            }
            PsiAnnotation annotation = modifierList.findAnnotation("org.junit.Test");
            if (annotation == null) {
                return;
            }
            annotation.delete();
        }
    }

    private static class RemoveExtendsTestCaseFix
    extends InspectionGadgetsFix {
        private final String className;

        RemoveExtendsTestCaseFix(String className) {
            this.className = className;
        }

        @NotNull
        public String getName() {
            String string = "remove 'extends TestCase' from class '" + this.className + '\'';
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$RemoveExtendsTestCaseFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMember)) {
                return;
            }
            PsiMember method = (PsiMember)parent;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiReferenceList extendsList = containingClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            extendsList.delete();
        }
    }
}

