/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseWithConstructorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("JUnitTestCaseWithNonTrivialConstructors" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseWithConstructorInspection.getID must not return null");
        }
        return "JUnitTestCaseWithNonTrivialConstructors";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.case.with.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseWithConstructorInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        if (Boolean.TRUE.equals(infos[0])) {
            string = InspectionGadgetsBundle.message("test.case.with.constructor.problem.descriptor.initializer", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseWithConstructorInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("test.case.with.constructor.problem.descriptor", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseWithConstructorInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseWithConstructorVisitor();
    }

    private static class TestCaseWithConstructorVisitor
    extends BaseInspectionVisitor {
        private TestCaseWithConstructorVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/TestCaseWithConstructorInspection$TestCaseWithConstructorVisitor.visitMethod must not be null");
            }
            if (!method.isConstructor()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (!TestUtils.isJUnitTestClass(aClass)) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (TestCaseWithConstructorVisitor.isTrivial(body)) {
                return;
            }
            this.registerMethodError(method, Boolean.FALSE);
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            if (initializer.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = initializer.getContainingClass();
            if (!TestUtils.isJUnitTestClass(aClass)) {
                return;
            }
            this.registerClassInitializerError(initializer, Boolean.TRUE);
        }

        private static boolean isTrivial(@Nullable PsiCodeBlock codeBlock) {
            if (codeBlock == null) {
                return true;
            }
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length == 0) {
                return true;
            }
            if (statements.length > 1) {
                return false;
            }
            PsiStatement statement = statements[0];
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String text = methodExpression.getText();
            return "super".equals(text);
        }
    }
}

