/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.HighlightUtils;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DynamicRegexReplaceableByCompiledPatternInspection
extends BaseInspection {
    @NonNls
    private static final Collection<String> regexMethodNames = new HashSet<String>(4);

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/DynamicRegexReplaceableByCompiledPatternInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/DynamicRegexReplaceableByCompiledPatternInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DynamicRegexReplaceableByCompiledPatternFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DynamicRegexReplaceableByCompiledPatternVisitor();
    }

    static {
        regexMethodNames.add("matches");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }

    private static class DynamicRegexReplaceableByCompiledPatternVisitor
    extends BaseInspectionVisitor {
        private DynamicRegexReplaceableByCompiledPatternVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (!DynamicRegexReplaceableByCompiledPatternVisitor.isCallToRegexMethod(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isCallToRegexMethod(PsiMethodCallExpression expression) {
            PsiExpression[] arguments;
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!regexMethodNames.contains(name)) {
                return false;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                if (PsiUtil.isConstantExpression((PsiExpression)argument)) continue;
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            return "java.lang.String".equals(className);
        }
    }

    private static class DynamicRegexReplaceableByCompiledPatternFix
    extends InspectionGadgetsFix {
        private DynamicRegexReplaceableByCompiledPatternFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/DynamicRegexReplaceableByCompiledPatternInspection$DynamicRegexReplaceableByCompiledPatternFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            int i;
            PsiElement element = descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (aClass == null) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
            PsiElement grandParent = methodExpression.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList list = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = list.getExpressions();
            StringBuilder fieldText = new StringBuilder("private static final java.util.regex.Pattern PATTERN = java.util.regex.Pattern.compile(");
            int expressionsLength = expressions.length;
            if (expressionsLength > 0) {
                fieldText.append(expressions[0].getText());
            }
            fieldText.append(");");
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiField newField = factory.createFieldFromText(fieldText.toString(), element);
            PsiElement field = aClass.add((PsiElement)newField);
            StringBuilder expressionText = new StringBuilder("PATTERN.");
            String methodName = methodExpression.getReferenceName();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String qualifierText = qualifier == null ? "this" : qualifier.getText();
            if ("split".equals(methodName)) {
                expressionText.append(methodName);
                expressionText.append('(');
                expressionText.append(qualifierText);
                for (i = 1; i < expressionsLength; ++i) {
                    expressionText.append(',');
                    expressionText.append(expressions[i].getText());
                }
                expressionText.append(')');
            } else {
                expressionText.append("matcher(");
                expressionText.append(qualifierText);
                expressionText.append(").");
                expressionText.append(methodName);
                expressionText.append('(');
                if (expressionsLength > 1) {
                    expressionText.append(expressions[1].getText());
                    for (i = 2; i < expressionsLength; ++i) {
                        expressionText.append(',');
                        expressionText.append(expressions[i].getText());
                    }
                }
                expressionText.append(')');
            }
            PsiExpression newExpression = factory.createExpressionFromText(expressionText.toString(), element);
            PsiMethodCallExpression newMethodCallExpression = (PsiMethodCallExpression)methodCallExpression.replace((PsiElement)newExpression);
            newMethodCallExpression = (PsiMethodCallExpression)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)newMethodCallExpression);
            PsiReferenceExpression reference = DynamicRegexReplaceableByCompiledPatternFix.getReference(newMethodCallExpression);
            HighlightUtils.showRenameTemplate((PsiElement)aClass, (PsiNameIdentifierOwner)field, new PsiReference[]{reference});
        }

        private static PsiReferenceExpression getReference(PsiMethodCallExpression newMethodCallExpression) {
            PsiReferenceExpression methodExpression = newMethodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifierExpression;
                return DynamicRegexReplaceableByCompiledPatternFix.getReference(methodCallExpression);
            }
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return null;
            }
            return (PsiReferenceExpression)qualifierExpression;
        }
    }
}

