/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.performance.InnerClassReferenceVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InnerClassMayBeStaticInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inner.class.may.be.static.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/InnerClassMayBeStaticInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inner.class.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/InnerClassMayBeStaticInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InnerClassMayBeStaticFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassCanBeStaticVisitor();
    }

    private static class InnerClassCanBeStaticVisitor
    extends BaseInspectionVisitor {
        private InnerClassCanBeStaticVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass[] innerClasses;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/InnerClassMayBeStaticInspection$InnerClassCanBeStaticVisitor.visitClass must not be null");
            }
            if (aClass.getContainingClass() != null && !aClass.hasModifierProperty("static")) {
                return;
            }
            for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
                if (innerClass.hasModifierProperty("static")) continue;
                InnerClassReferenceVisitor visitor = new InnerClassReferenceVisitor(innerClass);
                innerClass.accept((PsiElementVisitor)visitor);
                if (!visitor.canInnerClassBeStatic()) continue;
                this.registerClassError(innerClass, new Object[0]);
            }
        }
    }

    private static class InnerClassMayBeStaticFix
    extends InspectionGadgetsFix {
        private InnerClassMayBeStaticFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("make.static.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/InnerClassMayBeStaticInspection$InnerClassMayBeStaticFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiJavaToken classNameToken = (PsiJavaToken)descriptor.getPsiElement();
            PsiClass innerClass = (PsiClass)classNameToken.getParent();
            assert (innerClass != null);
            SearchScope useScope = innerClass.getUseScope();
            Query query = ReferencesSearch.search((PsiElement)innerClass, (SearchScope)useScope);
            Collection references = query.findAll();
            for (PsiReference reference : references) {
                PsiNewExpression newExpression;
                PsiExpression qualifier;
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiNewExpression) || (qualifier = (newExpression = (PsiNewExpression)parent).getQualifier()) == null) continue;
                qualifier.delete();
            }
            PsiModifierList modifiers = innerClass.getModifierList();
            if (modifiers == null) {
                return;
            }
            modifiers.setModifierProperty("static", true);
        }
    }
}

