/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class IteratorUtils {
    private IteratorUtils() {
    }

    public static boolean containsCallToIteratorNext(PsiElement context, PsiVariable target, boolean checkTarget) {
        CallsIteratorNextVisitor visitor = new CallsIteratorNextVisitor(target, checkTarget, false);
        context.accept((PsiElementVisitor)visitor);
        return visitor.callsIteratorNext();
    }

    public static boolean containsCallToScannerNext(PsiElement context, PsiVariable target, boolean checkTarget) {
        CallsIteratorNextVisitor visitor = new CallsIteratorNextVisitor(target, checkTarget, true);
        context.accept((PsiElementVisitor)visitor);
        return visitor.callsIteratorNext();
    }

    public static boolean isCallToHasNext(PsiMethodCallExpression methodCallExpression) {
        return MethodCallUtils.isCallToMethod(methodCallExpression, "java.util.Iterator", PsiType.BOOLEAN, "hasNext", new PsiType[0]);
    }

    public static boolean isIterator(PsiClass aClass) {
        return ClassUtils.isSubclass(aClass, "java.util.Iterator");
    }

    private static class CallsIteratorNextVisitor
    extends JavaRecursiveElementVisitor {
        private static final Pattern SCANNER_PATTERN = Pattern.compile("next.*");
        private final boolean checkTarget;
        private final boolean checkScanner;
        private final PsiVariable target;
        private boolean doesCallIteratorNext = false;

        CallsIteratorNextVisitor(PsiVariable target, boolean checkTarget, boolean checkScanner) {
            this.checkTarget = checkTarget;
            this.target = target;
            this.checkScanner = checkScanner;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/IteratorUtils$CallsIteratorNextVisitor.visitElement must not be null");
            }
            if (this.doesCallIteratorNext) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/IteratorUtils$CallsIteratorNextVisitor.visitMethodCallExpression must not be null");
            }
            if (this.doesCallIteratorNext) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (this.checkScanner ? !MethodCallUtils.isCallToMethod(expression, "java.util.Iterator", null, SCANNER_PATTERN, new PsiType[0]) : !MethodCallUtils.isCallToMethod(expression, "java.util.Iterator", null, "next", new PsiType[0])) {
                return;
            }
            if (this.checkTarget) {
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    if (this.target != null) {
                        return;
                    }
                    if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                        return;
                    }
                } else {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                    PsiElement element = referenceExpression.resolve();
                    if (this.target != element) {
                        return;
                    }
                }
            }
            this.doesCallIteratorNext = true;
        }

        public boolean callsIteratorNext() {
            return this.doesCallIteratorNext;
        }
    }
}

