/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableSearchUtils {
    private VariableSearchUtils() {
    }

    public static boolean existsLocalOrParameter(@NotNull String variableName, @Nullable PsiElement context) {
        if (variableName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableSearchUtils.existsLocalOrParameter must not be null");
        }
        if (context == null) {
            return false;
        }
        if (VariableSearchUtils.existsParameter(variableName, context)) {
            return true;
        }
        if (VariableSearchUtils.existsLocal(variableName, context)) {
            return true;
        }
        if (VariableSearchUtils.existsCatchSectionLocal(variableName, context)) {
            return true;
        }
        if (VariableSearchUtils.existsForLoopLocal(variableName, context)) {
            return true;
        }
        return VariableSearchUtils.existsForeachLoopLocal(variableName, context);
    }

    private static boolean existsParameter(@NotNull String variableName, PsiElement context) {
        if (variableName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableSearchUtils.existsParameter must not be null");
        }
        PsiMethod ancestor = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
        while (ancestor != null) {
            PsiParameter[] parameters;
            PsiParameterList parameterList = ancestor.getParameterList();
            for (PsiParameter parameter : parameters = parameterList.getParameters()) {
                String parameterName = parameter.getName();
                if (!variableName.equals(parameterName)) continue;
                return true;
            }
            ancestor = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)ancestor, PsiMethod.class);
        }
        return false;
    }

    private static boolean existsLocal(@NotNull String variableName, PsiElement context) {
        if (variableName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableSearchUtils.existsLocal must not be null");
        }
        PsiCodeBlock ancestor = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)context, PsiCodeBlock.class);
        while (ancestor != null) {
            PsiStatement[] statements;
            for (PsiStatement statement : statements = ancestor.getStatements()) {
                PsiElement[] elements;
                if (!(statement instanceof PsiDeclarationStatement)) continue;
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
                    PsiLocalVariable localVariable;
                    String localVariableName;
                    if (!(element instanceof PsiLocalVariable) || !variableName.equals(localVariableName = (localVariable = (PsiLocalVariable)element).getName())) continue;
                    return true;
                }
            }
            ancestor = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)ancestor, PsiCodeBlock.class);
        }
        return false;
    }

    private static boolean existsCatchSectionLocal(@NotNull String variableName, PsiElement context) {
        if (variableName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableSearchUtils.existsCatchSectionLocal must not be null");
        }
        PsiCatchSection catchSectionAncestor = (PsiCatchSection)PsiTreeUtil.getParentOfType((PsiElement)context, PsiCatchSection.class);
        while (catchSectionAncestor != null) {
            String parameterName;
            PsiParameter parameter = catchSectionAncestor.getParameter();
            if (parameter != null && variableName.equals(parameterName = parameter.getName())) {
                return true;
            }
            catchSectionAncestor = (PsiCatchSection)PsiTreeUtil.getParentOfType((PsiElement)catchSectionAncestor, PsiCatchSection.class);
        }
        return false;
    }

    private static boolean existsForLoopLocal(@NotNull String variableName, PsiElement context) {
        if (variableName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableSearchUtils.existsForLoopLocal must not be null");
        }
        PsiForStatement forLoopAncestor = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiForStatement.class);
        while (forLoopAncestor != null) {
            PsiStatement initialization = forLoopAncestor.getInitialization();
            if (initialization instanceof PsiDeclarationStatement) {
                PsiElement[] elements;
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)initialization;
                for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
                    PsiLocalVariable localVariable = (PsiLocalVariable)element;
                    String localVariableName = localVariable.getName();
                    if (!variableName.equals(localVariableName)) continue;
                    return true;
                }
            }
            forLoopAncestor = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)forLoopAncestor, PsiForStatement.class);
        }
        return false;
    }

    private static boolean existsForeachLoopLocal(@NotNull String variableName, PsiElement context) {
        if (variableName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableSearchUtils.existsForeachLoopLocal must not be null");
        }
        PsiForeachStatement forLoopAncestor = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiForeachStatement.class);
        while (forLoopAncestor != null) {
            PsiParameter parameter = forLoopAncestor.getIterationParameter();
            String parameterName = parameter.getName();
            if (variableName.equals(parameterName)) {
                return true;
            }
            forLoopAncestor = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)forLoopAncestor, PsiForeachStatement.class);
        }
        return false;
    }

    public static boolean containsConflictingDeclarations(PsiCodeBlock block, PsiCodeBlock parentBlock) {
        PsiStatement[] statements = block.getStatements();
        HashSet<String> variableNames = new HashSet<String>();
        for (PsiStatement statement : statements) {
            PsiElement[] declaredElements;
            if (!(statement instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement;
            for (PsiElement declaredElement : declaredElements = declaration.getDeclaredElements()) {
                PsiLocalVariable variable;
                String variableName;
                if (!(declaredElement instanceof PsiLocalVariable) || (variableName = (variable = (PsiLocalVariable)declaredElement).getName()) == null) continue;
                variableNames.add(variableName);
            }
        }
        ConflictingDeclarationVisitor visitor = new ConflictingDeclarationVisitor(variableNames, block);
        parentBlock.accept((PsiElementVisitor)visitor);
        return visitor.hasConflictingDeclaration();
    }

    private static class ConflictingDeclarationVisitor
    extends JavaRecursiveElementVisitor {
        private final Set<String> variableNames;
        private final PsiCodeBlock exceptBlock;
        private boolean hasConflictingDeclaration;

        ConflictingDeclarationVisitor(@NotNull Set<String> variableNames, PsiCodeBlock exceptBlock) {
            if (variableNames == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableSearchUtils$ConflictingDeclarationVisitor.<init> must not be null");
            }
            this.hasConflictingDeclaration = false;
            this.variableNames = variableNames;
            this.exceptBlock = exceptBlock;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableSearchUtils$ConflictingDeclarationVisitor.visitElement must not be null");
            }
            if (this.hasConflictingDeclaration) {
                return;
            }
            super.visitElement(element);
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            if (this.hasConflictingDeclaration) {
                return;
            }
            if (block.equals(this.exceptBlock)) {
                return;
            }
            super.visitCodeBlock(block);
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableSearchUtils$ConflictingDeclarationVisitor.visitVariable must not be null");
            }
            if (this.hasConflictingDeclaration) {
                return;
            }
            super.visitVariable(variable);
            String name = variable.getName();
            if (this.variableNames.contains(name)) {
                this.hasConflictingDeclaration = true;
            }
        }

        public boolean hasConflictingDeclaration() {
            return this.hasConflictingDeclaration;
        }
    }
}

