/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JNDIResourceInspection
extends ResourceInspection {
    @NotNull
    public String getID() {
        if ("JNDIResourceOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/JNDIResourceInspection.getID must not return null");
        }
        return "JNDIResourceOpenedButNotSafelyClosed";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("jndi.resource.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/JNDIResourceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("resource.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/JNDIResourceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JNDIResourceVisitor();
    }

    private static class JNDIResourceVisitor
    extends BaseInspectionVisitor {
        @NonNls
        private static final String LIST = "list";
        @NonNls
        private static final String LIST_BINDING = "listBindings";
        @NonNls
        private static final String GET_ALL = "getAll";

        private JNDIResourceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/JNDIResourceInspection$JNDIResourceVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!JNDIResourceVisitor.isJNDIFactoryMethod(expression)) {
                return;
            }
            PsiElement parent = ResourceInspection.getExpressionParent((PsiExpression)expression);
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(parent);
            if (ResourceInspection.isSafelyClosed(boundVariable, (PsiExpression)expression)) {
                return;
            }
            if (ResourceInspection.isResourceEscapedFromMethod(boundVariable, (PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/JNDIResourceInspection$JNDIResourceVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            if (!JNDIResourceVisitor.isJNDIResource(expression)) {
                return;
            }
            PsiElement parent = ResourceInspection.getExpressionParent((PsiExpression)expression);
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(parent);
            if (ResourceInspection.isSafelyClosed(boundVariable, (PsiExpression)expression)) {
                return;
            }
            if (ResourceInspection.isResourceEscapedFromMethod(boundVariable, (PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static boolean isJNDIResource(PsiNewExpression expression) {
            return TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression, "javax.naming.InitialContext");
        }

        private static boolean isJNDIFactoryMethod(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (LIST.equals(methodName) || LIST_BINDING.equals(methodName)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null) {
                    return false;
                }
                return TypeUtils.expressionHasTypeOrSubtype(qualifier, "javax.naming.Context");
            }
            if (GET_ALL.equals(methodName)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null) {
                    return false;
                }
                return TypeUtils.expressionHasTypeOrSubtype(qualifier, "javax.naming.directory.Attribute") || TypeUtils.expressionHasTypeOrSubtype(qualifier, "javax.naming.directory.Attributes");
            }
            return false;
        }
    }
}

