/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallToStringConcatCanBeReplacedByOperatorInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.string.concat.can.be.replaced.by.operator.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/CallToStringConcatCanBeReplacedByOperatorInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.string.concat.can.be.replaced.by.operator.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/CallToStringConcatCanBeReplacedByOperatorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new CallToStringConcatCanBeReplacedByOperatorFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToStringConcatCanBeReplacedByOperatorVisitor();
    }

    private static class CallToStringConcatCanBeReplacedByOperatorVisitor
    extends BaseInspectionVisitor {
        private CallToStringConcatCanBeReplacedByOperatorVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiManager manager = expression.getManager();
            PsiClass stringClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.String", expression.getResolveScope());
            if (stringClass == null) {
                return;
            }
            PsiClassType stringType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(stringClass);
            if (!MethodCallUtils.isCallToMethod(expression, "java.lang.String", (PsiType)stringType, "concat", new PsiType[]{stringType})) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionStatement) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }

    private static class CallToStringConcatCanBeReplacedByOperatorFix
    extends InspectionGadgetsFix {
        private CallToStringConcatCanBeReplacedByOperatorFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("call.to.string.concat.can.be.replaced.by.operator.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/CallToStringConcatCanBeReplacedByOperatorInspection$CallToStringConcatCanBeReplacedByOperatorFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiElement grandParent = referenceExpression.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            String newExpression = qualifier.getText() + "+" + argument.getText();
            CallToStringConcatCanBeReplacedByOperatorFix.replaceExpression((PsiExpression)methodCallExpression, newExpression);
        }
    }
}

